/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Iterators;
import java.text.Format;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.StringUtil;

public abstract class ExplainTable {
    private static final List<KeyRange> EVERYTHING = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    protected final StatementContext context;
    protected final TableRef tableRef;
    protected final GroupByCompiler.GroupBy groupBy;
    protected final OrderByCompiler.OrderBy orderBy;
    protected final HintNode hint;
    protected final Integer limit;

    public ExplainTable(StatementContext context, TableRef table) {
        this(context, table, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, HintNode.EMPTY_HINT_NODE, null);
    }

    public ExplainTable(StatementContext context, TableRef table, GroupByCompiler.GroupBy groupBy, OrderByCompiler.OrderBy orderBy, HintNode hintNode, Integer limit) {
        this.context = context;
        this.tableRef = table;
        this.groupBy = groupBy;
        this.orderBy = orderBy;
        this.hint = hintNode;
        this.limit = limit;
    }

    private boolean explainSkipScan(StringBuilder buf) {
        ScanRanges scanRanges = this.context.getScanRanges();
        if (scanRanges.isPointLookup()) {
            int keyCount = scanRanges.getPointLookupCount();
            buf.append("POINT LOOKUP ON " + keyCount + " KEY" + (keyCount > 1 ? "S " : " "));
        } else if (scanRanges.useSkipScanFilter()) {
            buf.append("SKIP SCAN ");
            int count = 1;
            boolean hasRanges = false;
            for (List<KeyRange> ranges : scanRanges.getRanges()) {
                count *= ranges.size();
                for (KeyRange range : ranges) {
                    hasRanges |= !range.isSingleKey();
                }
            }
            buf.append("ON ");
            buf.append(count);
            buf.append(hasRanges ? " RANGE" : " KEY");
            buf.append(count > 1 ? "S " : " ");
        } else {
            buf.append("RANGE SCAN ");
        }
        return scanRanges.useSkipScanFilter();
    }

    protected void explain(String prefix, List<String> planSteps) {
        Iterator<Filter> filterIterator;
        StringBuilder buf = new StringBuilder(prefix);
        ScanRanges scanRanges = this.context.getScanRanges();
        Scan scan = this.context.getScan();
        if (scan.getConsistency() != Consistency.STRONG) {
            buf.append("TIMELINE-CONSISTENCY ");
        }
        if (this.hint.hasHint(HintNode.Hint.SMALL)) {
            buf.append("SMALL ");
        }
        if (OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.orderBy)) {
            buf.append("REVERSE ");
        }
        if (scanRanges.isEverything()) {
            buf.append("FULL SCAN ");
        } else {
            this.explainSkipScan(buf);
        }
        buf.append("OVER " + this.tableRef.getTable().getPhysicalName().getString());
        if (!scanRanges.isPointLookup()) {
            this.appendKeyRanges(buf);
        }
        planSteps.add(buf.toString());
        if (this.context.getScan() != null && this.tableRef.getTable().getRowTimestampColPos() != -1) {
            TimeRange range = this.context.getScan().getTimeRange();
            planSteps.add("    ROW TIMESTAMP FILTER [" + range.getMin() + ", " + range.getMax() + ")");
        }
        if ((filterIterator = ScanUtil.getFilterIterator(scan)).hasNext()) {
            PageFilter pageFilter = null;
            FirstKeyOnlyFilter firstKeyOnlyFilter = null;
            BooleanExpressionFilter whereFilter = null;
            do {
                Filter filter;
                if ((filter = filterIterator.next()) instanceof FirstKeyOnlyFilter) {
                    firstKeyOnlyFilter = (FirstKeyOnlyFilter)filter;
                    continue;
                }
                if (filter instanceof PageFilter) {
                    pageFilter = (PageFilter)filter;
                    continue;
                }
                if (!(filter instanceof BooleanExpressionFilter)) continue;
                whereFilter = (BooleanExpressionFilter)filter;
            } while (filterIterator.hasNext());
            if (whereFilter != null) {
                planSteps.add("    SERVER FILTER BY " + (firstKeyOnlyFilter == null ? "" : "FIRST KEY ONLY AND ") + whereFilter.toString());
            } else if (firstKeyOnlyFilter != null) {
                planSteps.add("    SERVER FILTER BY FIRST KEY ONLY");
            }
            if (!this.orderBy.getOrderByExpressions().isEmpty() && this.groupBy.isEmpty()) {
                planSteps.add("    SERVER" + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString());
            } else if (pageFilter != null) {
                planSteps.add("    SERVER " + pageFilter.getPageSize() + " ROW LIMIT");
            }
        }
        Integer groupByLimit = null;
        byte[] groupByLimitBytes = scan.getAttribute("_GroupByLimit");
        if (groupByLimitBytes != null) {
            groupByLimit = (Integer)PInteger.INSTANCE.toObject(groupByLimitBytes);
        }
        this.groupBy.explain(planSteps, groupByLimit);
    }

    private void appendPKColumnValue(StringBuilder buf, byte[] range, Boolean isNull, int slotIndex) {
        if (Boolean.TRUE.equals(isNull)) {
            buf.append("null");
            return;
        }
        if (Boolean.FALSE.equals(isNull)) {
            buf.append("not null");
            return;
        }
        if (range.length == 0) {
            buf.append('*');
            return;
        }
        ScanRanges scanRanges = this.context.getScanRanges();
        PDataType type = scanRanges.getSchema().getField(slotIndex).getDataType();
        SortOrder sortOrder = this.tableRef.getTable().getPKColumns().get(slotIndex).getSortOrder();
        if (sortOrder == SortOrder.DESC) {
            buf.append('~');
            range = SortOrder.invert(range, 0, new byte[range.length], 0, range.length);
        }
        Format formatter = this.context.getConnection().getFormatter(type);
        buf.append(type.toStringLiteral(range, formatter));
    }

    private void appendScanRow(StringBuilder buf, KeyRange.Bound bound) {
        ScanRanges scanRanges = this.context.getScanRanges();
        KeyRange minMaxRange = scanRanges.getMinMaxRange();
        Iterator<Object> minMaxIterator = Iterators.emptyIterator();
        if (minMaxRange != KeyRange.EVERYTHING_RANGE) {
            RowKeySchema schema = this.tableRef.getTable().getRowKeySchema();
            if (!minMaxRange.isUnbound(bound)) {
                minMaxIterator = new RowKeyValueIterator(schema, minMaxRange.getRange(bound));
            }
        }
        int nRanges = scanRanges.getRanges().size();
        int i = 0;
        int minPos = 0;
        while (minPos < nRanges || minMaxIterator.hasNext()) {
            Boolean isNull;
            List<KeyRange> ranges = minPos >= nRanges ? EVERYTHING : scanRanges.getRanges().get(minPos++);
            KeyRange range = bound == KeyRange.Bound.LOWER ? ranges.get(0) : ranges.get(ranges.size() - 1);
            byte[] b = range.getRange(bound);
            Boolean bl = KeyRange.IS_NULL_RANGE == range ? Boolean.TRUE : (isNull = KeyRange.IS_NOT_NULL_RANGE == range ? Boolean.FALSE : null);
            if (minMaxIterator.hasNext()) {
                byte[] bMinMax = (byte[])minMaxIterator.next();
                int cmp = Bytes.compareTo(bMinMax, b) * (bound == KeyRange.Bound.LOWER ? 1 : -1);
                if (cmp > 0) {
                    minPos = nRanges;
                    b = bMinMax;
                    isNull = null;
                } else if (cmp < 0) {
                    minMaxIterator = Iterators.emptyIterator();
                }
            }
            this.appendPKColumnValue(buf, b, isNull, i);
            buf.append(',');
            ++i;
        }
    }

    private void appendKeyRanges(StringBuilder buf) {
        ScanRanges scanRanges = this.context.getScanRanges();
        if (scanRanges.isDegenerate() || scanRanges.isEverything()) {
            return;
        }
        buf.append(" [");
        StringBuilder buf1 = new StringBuilder();
        this.appendScanRow(buf1, KeyRange.Bound.LOWER);
        buf.append((CharSequence)buf1);
        buf.setCharAt(buf.length() - 1, ']');
        StringBuilder buf2 = new StringBuilder();
        this.appendScanRow(buf2, KeyRange.Bound.UPPER);
        if (!StringUtil.equals(buf1, buf2)) {
            buf.append(" - [");
            buf.append((CharSequence)buf2);
        }
        buf.setCharAt(buf.length() - 1, ']');
    }

    private static class RowKeyValueIterator
    implements Iterator<byte[]> {
        private final RowKeySchema schema;
        private ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        private int position = 0;
        private final int maxOffset;
        private byte[] nextValue;

        public RowKeyValueIterator(RowKeySchema schema, byte[] rowKey) {
            this.schema = schema;
            this.maxOffset = schema.iterator(rowKey, this.ptr);
            this.iterate();
        }

        private void iterate() {
            this.nextValue = (byte[])(this.schema.next(this.ptr, this.position++, this.maxOffset) == null ? null : this.ptr.copyBytes());
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public byte[] next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            byte[] value = this.nextValue;
            this.iterate();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

