/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class DistinctAggregatingResultIterator
implements AggregatingResultIterator {
    private final AggregatingResultIterator delegate;
    private final RowProjector rowProjector;
    private Iterator<ResultEntry> resultIterator;
    private final ImmutableBytesWritable ptr1 = new ImmutableBytesWritable();
    private final ImmutableBytesWritable ptr2 = new ImmutableBytesWritable();

    protected ResultIterator getDelegate() {
        return this.delegate;
    }

    public DistinctAggregatingResultIterator(AggregatingResultIterator delegate, RowProjector rowProjector) {
        this.delegate = delegate;
        this.rowProjector = rowProjector;
    }

    @Override
    public Tuple next() throws SQLException {
        Iterator<ResultEntry> iterator = this.getResultIterator();
        if (iterator.hasNext()) {
            ResultEntry entry = iterator.next();
            Tuple tuple = entry.getResult();
            this.aggregate(tuple);
            return tuple;
        }
        this.resultIterator = Iterators.emptyIterator();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ResultEntry> getResultIterator() throws SQLException {
        if (this.resultIterator != null) {
            return this.resultIterator;
        }
        HashSet<ResultEntry> entries = Sets.newHashSet();
        try {
            Tuple result = this.delegate.next();
            while (result != null) {
                ResultEntry entry = new ResultEntry(result);
                entries.add(entry);
                result = this.delegate.next();
            }
        }
        finally {
            this.delegate.close();
        }
        this.resultIterator = entries.iterator();
        return this.resultIterator;
    }

    @Override
    public void close() {
        this.resultIterator = Iterators.emptyIterator();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT DISTINCT ON " + this.rowProjector.toString());
    }

    @Override
    public void aggregate(Tuple result) {
        this.delegate.aggregate(result);
    }

    public String toString() {
        return "DistinctAggregatingResultIterator [delegate=" + this.delegate + ", rowProjector=" + this.rowProjector + ", resultIterator=" + this.resultIterator + ", ptr1=" + this.ptr1 + ", ptr2=" + this.ptr2 + "]";
    }

    private class ResultEntry {
        private final int hashCode;
        private final Tuple result;

        ResultEntry(Tuple result) {
            int prime = 31;
            this.result = result;
            int hashCode = 0;
            for (ColumnProjector columnProjector : DistinctAggregatingResultIterator.this.rowProjector.getColumnProjectors()) {
                Expression e = columnProjector.getExpression();
                if (!e.evaluate(this.result, DistinctAggregatingResultIterator.this.ptr1)) continue;
                hashCode = 31 * hashCode + DistinctAggregatingResultIterator.this.ptr1.hashCode();
            }
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ResultEntry that = (ResultEntry)o;
            for (ColumnProjector columnProjector : DistinctAggregatingResultIterator.this.rowProjector.getColumnProjectors()) {
                boolean isNull2;
                Expression e = columnProjector.getExpression();
                boolean isNull1 = !e.evaluate(this.result, DistinctAggregatingResultIterator.this.ptr1);
                boolean bl = isNull2 = !e.evaluate(that.result, DistinctAggregatingResultIterator.this.ptr2);
                if (isNull1 && isNull2) {
                    return true;
                }
                if (isNull1 || isNull2) {
                    return false;
                }
                if (DistinctAggregatingResultIterator.this.ptr1.compareTo(DistinctAggregatingResultIterator.this.ptr2) == 0) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        Tuple getResult() {
            return this.result;
        }
    }
}

