/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedResultIterator
implements PeekingResultIterator {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedResultIterator.class);
    private final ParallelIteratorFactory delegateIteratorFactory;
    private ImmutableBytesWritable lastKey = new ImmutableBytesWritable();
    private final StatementContext context;
    private final TableRef tableRef;
    private Scan scan;
    private final long chunkSize;
    private PeekingResultIterator resultIterator;

    public ChunkedResultIterator(ParallelIteratorFactory delegateIteratorFactory, StatementContext context, TableRef tableRef, Scan scan, long chunkSize) throws SQLException {
        this.delegateIteratorFactory = delegateIteratorFactory;
        this.context = context;
        this.tableRef = tableRef;
        this.scan = scan;
        this.chunkSize = chunkSize;
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Get first chunked result iterator over " + tableRef.getTable().getName().getString() + " with " + scan, ScanUtil.getCustomAnnotations(scan)));
        }
        SingleChunkResultIterator singleChunkResultIterator = new SingleChunkResultIterator(new TableResultIterator(context, tableRef, scan), chunkSize);
        this.resultIterator = delegateIteratorFactory.newIterator(context, singleChunkResultIterator, scan);
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.getResultIterator().peek();
    }

    @Override
    public Tuple next() throws SQLException {
        return this.getResultIterator().next();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterator.explain(planSteps);
    }

    @Override
    public void close() throws SQLException {
        this.resultIterator.close();
    }

    private PeekingResultIterator getResultIterator() throws SQLException {
        if (this.resultIterator.peek() == null && this.lastKey != null) {
            this.resultIterator.close();
            this.scan = ScanUtil.newScan(this.scan);
            this.scan.setStartRow(ByteUtil.copyKeyBytesIfNecessary(this.lastKey));
            if (logger.isDebugEnabled()) {
                logger.debug(LogUtil.addCustomAnnotations("Get next chunked result iterator over " + this.tableRef.getTable().getName().getString() + " with " + this.scan, ScanUtil.getCustomAnnotations(this.scan)));
            }
            SingleChunkResultIterator singleChunkResultIterator = new SingleChunkResultIterator(new TableResultIterator(this.context, this.tableRef, this.scan), this.chunkSize);
            this.resultIterator = this.delegateIteratorFactory.newIterator(this.context, singleChunkResultIterator, this.scan);
        }
        return this.resultIterator;
    }

    private class SingleChunkResultIterator
    implements ResultIterator {
        private int rowCount = 0;
        private boolean chunkComplete;
        private final ResultIterator delegate;
        private final long chunkSize;

        private SingleChunkResultIterator(ResultIterator delegate, long chunkSize) {
            Preconditions.checkArgument(chunkSize > 0L);
            this.delegate = delegate;
            this.chunkSize = chunkSize;
        }

        @Override
        public Tuple next() throws SQLException {
            if (this.chunkComplete || ChunkedResultIterator.this.lastKey == null) {
                return null;
            }
            Tuple next = this.delegate.next();
            if (next != null) {
                if ((long)this.rowCount == this.chunkSize) {
                    next.getKey(ChunkedResultIterator.this.lastKey);
                    if (ChunkedResultIterator.this.scan.getAttribute("_StartKeyOffset") != null) {
                        this.addRegionStartKeyToLaskKey();
                    }
                } else if ((long)this.rowCount > this.chunkSize && this.rowKeyChanged(next)) {
                    this.chunkComplete = true;
                    return null;
                }
                ++this.rowCount;
            } else {
                ChunkedResultIterator.this.lastKey = null;
            }
            return next;
        }

        @Override
        public void explain(List<String> planSteps) {
            this.delegate.explain(planSteps);
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        private boolean rowKeyChanged(Tuple newTuple) {
            byte[] currentKey = ChunkedResultIterator.this.lastKey.get();
            int offset = ChunkedResultIterator.this.lastKey.getOffset();
            int length = ChunkedResultIterator.this.lastKey.getLength();
            newTuple.getKey(ChunkedResultIterator.this.lastKey);
            if (ChunkedResultIterator.this.scan.getAttribute("_StartKeyOffset") != null) {
                this.addRegionStartKeyToLaskKey();
            }
            return Bytes.compareTo(currentKey, offset, length, ChunkedResultIterator.this.lastKey.get(), ChunkedResultIterator.this.lastKey.getOffset(), ChunkedResultIterator.this.lastKey.getLength()) != 0;
        }

        private void addRegionStartKeyToLaskKey() {
            byte[] offsetBytes = ChunkedResultIterator.this.scan.getAttribute("_StartKeyOffset");
            if (offsetBytes != null) {
                int startKeyOffset = Bytes.toInt(offsetBytes);
                byte[] actualLastkey = new byte[startKeyOffset + ChunkedResultIterator.this.lastKey.getLength() - ChunkedResultIterator.this.lastKey.getOffset()];
                System.arraycopy(ChunkedResultIterator.this.scan.getStartRow(), 0, actualLastkey, 0, startKeyOffset);
                System.arraycopy(ChunkedResultIterator.this.lastKey.get(), ChunkedResultIterator.this.lastKey.getOffset(), actualLastkey, startKeyOffset, ChunkedResultIterator.this.lastKey.getLength());
                ChunkedResultIterator.this.lastKey.set(actualLastkey);
            }
        }

        public String toString() {
            return "SingleChunkResultIterator [rowCount=" + this.rowCount + ", chunkComplete=" + this.chunkComplete + ", delegate=" + this.delegate + ", chunkSize=" + this.chunkSize + "]";
        }
    }

    public static class ChunkedResultIteratorFactory
    implements ParallelIteratorFactory {
        private final ParallelIteratorFactory delegateFactory;
        private final TableRef tableRef;

        public ChunkedResultIteratorFactory(ParallelIteratorFactory delegateFactory, TableRef tableRef) {
            this.delegateFactory = delegateFactory;
            this.tableRef = tableRef;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan) throws SQLException {
            scanner.close();
            if (logger.isDebugEnabled()) {
                logger.debug(LogUtil.addCustomAnnotations("ChunkedResultIteratorFactory.newIterator over " + this.tableRef.getTable().getName().getString() + " with " + scan, ScanUtil.getCustomAnnotations(scan)));
            }
            return new ChunkedResultIterator(this.delegateFactory, context, this.tableRef, scan, context.getConnection().getQueryServices().getProps().getLong("phoenix.query.scanResultChunkSize", 2999L));
        }
    }
}

