/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixIndexFailurePolicy
extends KillServerOnFailurePolicy {
    private static final Log LOG = LogFactory.getLog(PhoenixIndexFailurePolicy.class);
    private RegionCoprocessorEnvironment env;

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        super.setup(parent, env);
        this.env = env;
    }

    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) {
        try {
            this.handleFailureWithExceptions(attempted, cause);
        }
        catch (Throwable t) {
            LOG.warn("handleFailure failed", t);
            super.handleFailure(attempted, cause);
        }
    }

    private void handleFailureWithExceptions(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws Throwable {
        Set<HTableInterfaceReference> refs = attempted.asMap().keySet();
        HashMap<String, Long> indexTableNames = new HashMap<String, Long>(refs.size());
        for (HTableInterfaceReference hTableInterfaceReference : refs) {
            long minTimeStamp = 0L;
            Collection<Mutation> mutations = attempted.get(hTableInterfaceReference);
            if (mutations != null) {
                for (Mutation mutation : mutations) {
                    for (List kvs : mutation.getFamilyCellMap().values()) {
                        for (Cell kv : kvs) {
                            if (minTimeStamp != 0L && (kv.getTimestamp() < 0L || minTimeStamp >= kv.getTimestamp())) continue;
                            minTimeStamp = kv.getTimestamp();
                        }
                    }
                }
            }
            if (hTableInterfaceReference.getTableName().startsWith("_LOCAL_IDX_")) {
                for (String string : this.getLocalIndexNames(hTableInterfaceReference, mutations)) {
                    indexTableNames.put(string, minTimeStamp);
                }
                continue;
            }
            indexTableNames.put(hTableInterfaceReference.getTableName(), minTimeStamp);
        }
        for (Map.Entry entry : indexTableNames.entrySet()) {
            String indexTableName = (String)entry.getKey();
            long minTimeStamp = (Long)entry.getValue();
            byte[] indexTableKey = SchemaUtil.getTableKeyFromFullName(indexTableName);
            HTableInterface hTableInterface = this.env.getTable(TableName.valueOf(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES));
            Put put = new Put(indexTableKey);
            put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, PIndexState.DISABLE.getSerializedBytes());
            put.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, PLong.INSTANCE.toBytes(minTimeStamp));
            final List<Put> tableMetadata = Collections.singletonList(put);
            Map<byte[], MetaDataProtos.MetaDataResponse> results = hTableInterface.coprocessorService(MetaDataProtos.MetaDataService.class, indexTableKey, indexTableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

                @Override
                public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                    MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                    for (Mutation m : tableMetadata) {
                        ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                        builder.addTableMetadataMutations(mp.toByteString());
                    }
                    instance.updateIndexState(controller, builder.build(), rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return rpcCallback.get();
                }
            });
            if (results.isEmpty()) {
                throw new IOException("Didn't get expected result size");
            }
            MetaDataProtos.MetaDataResponse tmpResponse = results.values().iterator().next();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataProtocol.MetaDataMutationResult.constructFromProto(tmpResponse);
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                LOG.info("Index " + indexTableName + " has been dropped. Ignore uncommitted mutations");
                continue;
            }
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                LOG.warn("Attempt to disable index " + indexTableName + " failed with code = " + (Object)((Object)result.getMutationCode()) + ". Will use default failure policy instead.");
                throw new DoNotRetryIOException("Attempt to disable " + indexTableName + " failed.");
            }
            LOG.info("Successfully disabled index " + indexTableName + " due to an exception while writing updates.", cause);
        }
    }

    private Collection<? extends String> getLocalIndexNames(HTableInterfaceReference ref, Collection<Mutation> mutations) throws IOException {
        HashSet<String> indexTableNames = new HashSet<String>(1);
        PhoenixConnection conn = null;
        try {
            conn = QueryUtil.getConnection(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            String userTableName = MetaDataUtil.getUserTableName(ref.getTableName());
            PTable dataTable = PhoenixRuntime.getTable(conn, userTableName);
            List<PTable> indexes = dataTable.getIndexes();
            PTable localIndex = null;
            HashMap<ImmutableBytesWritable, String> localIndexNames = new HashMap<ImmutableBytesWritable, String>();
            for (PTable index : indexes) {
                if (index.getIndexType() != PTable.IndexType.LOCAL || index.getIndexState() != PIndexState.ACTIVE) continue;
                if (localIndex == null) {
                    localIndex = index;
                }
                localIndexNames.put(new ImmutableBytesWritable(MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId())), index.getName().getString());
            }
            if (localIndex == null) {
                Set set = Collections.emptySet();
                return set;
            }
            IndexMaintainer indexMaintainer = localIndex.getIndexMaintainer(dataTable, conn);
            HRegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            int offset = regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length;
            byte[] viewId = null;
            for (Mutation mutation : mutations) {
                viewId = indexMaintainer.getViewIndexIdFromIndexRowKey(new ImmutableBytesWritable(mutation.getRow(), offset, mutation.getRow().length - offset));
                String indexTableName = (String)localIndexNames.get(new ImmutableBytesWritable(viewId));
                indexTableNames.add(indexTableName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
        return indexTableNames;
    }
}

