/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.hbase.index.covered.CoveredColumnsIndexBuilder;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixIndexBuilder
extends CoveredColumnsIndexBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        ArrayList<KeyRange> keys = Lists.newArrayListWithExpectedSize(miniBatchOp.size());
        HashMap<ImmutableBytesWritable, IndexMaintainer> maintainers = new HashMap<ImmutableBytesWritable, IndexMaintainer>();
        ImmutableBytesWritable indexTableName = new ImmutableBytesWritable();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            keys.add(PVarbinary.INSTANCE.getKeyRange(m.getRow()));
            List<IndexMaintainer> indexMaintainers = this.getCodec().getIndexMaintainers(m.getAttributesMap());
            for (IndexMaintainer indexMaintainer : indexMaintainers) {
                if (indexMaintainer.isImmutableRows() && indexMaintainer.isLocalIndex()) continue;
                indexTableName.set(indexMaintainer.getIndexTableName());
                if (maintainers.get(indexTableName) != null) continue;
                maintainers.put(indexTableName, indexMaintainer);
            }
        }
        if (maintainers.isEmpty()) {
            return;
        }
        Scan scan = IndexManagementUtil.newLocalStateScan(new ArrayList(maintainers.values()));
        ScanRanges scanRanges = ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keys), ScanUtil.SINGLE_COLUMN_SLOT_SPAN);
        scanRanges.initializeScan(scan);
        scan.setFilter(scanRanges.getSkipScanFilter());
        Region region = this.env.getRegion();
        RegionScanner scanner = region.getScanner(scan);
        region.startRegionOperation();
        try {
            RegionScanner regionScanner = scanner;
            synchronized (regionScanner) {
                ArrayList<Cell> results;
                boolean hasMore;
                while (hasMore = scanner.nextRaw(results = Lists.newArrayList())) {
                }
            }
        }
        finally {
            try {
                scanner.close();
            }
            finally {
                region.closeRegionOperation();
            }
        }
    }

    private PhoenixIndexCodec getCodec() {
        return (PhoenixIndexCodec)this.codec;
    }

    @Override
    public byte[] getBatchId(Mutation m) {
        return this.codec.getBatchId(m);
    }
}

