/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.ValueGetterTuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.BitSet;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class IndexMaintainer
implements Writable,
Iterable<ColumnReference> {
    private static final int EXPRESSION_NOT_PRESENT = -1;
    private static final int ESTIMATED_EXPRESSION_SIZE = 8;
    private byte[] viewIndexId;
    private boolean isMultiTenant;
    private List<Expression> indexedExpressions;
    private Set<ColumnReference> indexedColumns;
    private Set<ColumnReference> coveredColumns;
    private Map<ColumnReference, ColumnReference> coveredColumnsMap;
    private Set<ColumnReference> allColumns;
    private List<PDataType> indexedColumnTypes;
    private RowKeyMetaData rowKeyMetaData;
    private byte[] indexTableName;
    private int nIndexSaltBuckets;
    private byte[] dataEmptyKeyValueCF;
    private ImmutableBytesPtr emptyKeyValueCFPtr;
    private int nDataCFs;
    private boolean indexWALDisabled;
    private boolean isLocalIndex;
    private boolean immutableRows;
    private final boolean isDataTableSalted;
    private final RowKeySchema dataRowKeySchema;
    private List<ImmutableBytesPtr> indexQualifiers;
    private int estimatedIndexRowKeyBytes;
    private int estimatedExpressionSize;
    private int[] dataPkPosition;
    private int maxTrailingNulls;
    private ColumnReference dataEmptyKeyValueRef;
    private volatile RowKeySchema indexRowKeySchema;
    private static int BYTE_OFFSET = 127;

    public static IndexMaintainer create(PTable dataTable, PTable index, PhoenixConnection connection) {
        if (dataTable.getType() == PTableType.INDEX || index.getType() != PTableType.INDEX || !dataTable.getIndexes().contains(index)) {
            throw new IllegalArgumentException();
        }
        IndexMaintainer maintainer = new IndexMaintainer(dataTable, index, connection);
        return maintainer;
    }

    public static Iterator<PTable> nonDisabledIndexIterator(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, new Predicate<PTable>(){

            @Override
            public boolean apply(PTable index) {
                return !PIndexState.DISABLE.equals((Object)index.getIndexState());
            }
        });
    }

    public static Iterator<PTable> enabledGlobalIndexIterator(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, new Predicate<PTable>(){

            @Override
            public boolean apply(PTable index) {
                return !PIndexState.DISABLE.equals((Object)index.getIndexState()) && !index.getIndexType().equals((Object)PTable.IndexType.LOCAL);
            }
        });
    }

    public static Iterator<PTable> enabledLocalIndexIterator(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, new Predicate<PTable>(){

            @Override
            public boolean apply(PTable index) {
                return !PIndexState.DISABLE.equals((Object)index.getIndexState()) && index.getIndexType().equals((Object)PTable.IndexType.LOCAL);
            }
        });
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, PhoenixConnection connection) {
        List<PTable> indexes = dataTable.getIndexes();
        IndexMaintainer.serialize(dataTable, ptr, indexes, connection);
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, List<PTable> indexes, PhoenixConnection connection) {
        Iterator<PTable> indexesItr = IndexMaintainer.nonDisabledIndexIterator(indexes.iterator());
        if (!(!dataTable.isImmutableRows() && indexesItr.hasNext() || (indexesItr = IndexMaintainer.enabledLocalIndexIterator(indexesItr)).hasNext())) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        int nIndexes = 0;
        int estimatedSize = dataTable.getRowKeySchema().getEstimatedByteSize() + 2;
        while (indexesItr.hasNext()) {
            ++nIndexes;
            PTable index = indexesItr.next();
            estimatedSize += index.getIndexMaintainer(dataTable, connection).getEstimatedByteSize();
        }
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(estimatedSize + 1);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt(output, nIndexes * (dataTable.getBucketNum() == null ? 1 : -1));
            dataTable.getRowKeySchema().write(output);
            Iterator<PTable> iterator = indexesItr = dataTable.isImmutableRows() ? IndexMaintainer.enabledLocalIndexIterator(indexes.iterator()) : IndexMaintainer.nonDisabledIndexIterator(indexes.iterator());
            while (indexesItr.hasNext()) {
                indexesItr.next().getIndexMaintainer(dataTable, connection).write(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ptr.set(stream.getBuffer(), 0, stream.size());
    }

    public static List<IndexMaintainer> deserialize(ImmutableBytesWritable metaDataPtr, KeyValueBuilder builder) {
        return IndexMaintainer.deserialize(metaDataPtr.get(), metaDataPtr.getOffset(), metaDataPtr.getLength());
    }

    public static List<IndexMaintainer> deserialize(byte[] buf) {
        return IndexMaintainer.deserialize(buf, 0, buf.length);
    }

    public static List<IndexMaintainer> deserialize(byte[] buf, int offset, int length) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buf, offset, length);
        DataInputStream input = new DataInputStream(stream);
        List<IndexMaintainer> maintainers = Collections.emptyList();
        try {
            int size = WritableUtils.readVInt(input);
            boolean isDataTableSalted = size < 0;
            size = Math.abs(size);
            RowKeySchema rowKeySchema = new RowKeySchema();
            rowKeySchema.readFields(input);
            maintainers = Lists.newArrayListWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                IndexMaintainer maintainer = new IndexMaintainer(rowKeySchema, isDataTableSalted);
                maintainer.readFields(input);
                maintainers.add(maintainer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return maintainers;
    }

    private IndexMaintainer(RowKeySchema dataRowKeySchema, boolean isDataTableSalted) {
        this.dataRowKeySchema = dataRowKeySchema;
        this.isDataTableSalted = isDataTableSalted;
    }

    private IndexMaintainer(PTable dataTable, PTable index, PhoenixConnection connection) {
        this(dataTable.getRowKeySchema(), dataTable.getBucketNum() != null);
        PColumn column;
        int i;
        this.isMultiTenant = dataTable.isMultiTenant();
        this.viewIndexId = index.getViewIndexId() == null ? null : MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId());
        this.isLocalIndex = index.getIndexType() == PTable.IndexType.LOCAL;
        byte[] indexTableName = index.getPhysicalName().getBytes();
        Integer nIndexSaltBuckets = this.isLocalIndex ? dataTable.getBucketNum() : index.getBucketNum();
        boolean indexWALDisabled = index.isWALDisabled();
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
        int nIndexColumns = index.getColumns().size() - indexPosOffset;
        int nIndexPKColumns = index.getPKColumns().size() - indexPosOffset;
        int indexedExpressionCount = 0;
        for (int i2 = indexPosOffset; i2 < index.getPKColumns().size(); ++i2) {
            PColumn indexColumn = index.getPKColumns().get(i2);
            String indexColumnName = indexColumn.getName().getString();
            String dataFamilyName = IndexUtil.getDataColumnFamilyName(indexColumnName);
            String dataColumnName = IndexUtil.getDataColumnName(indexColumnName);
            try {
                PColumn dataColumn;
                PColumn pColumn = dataColumn = dataFamilyName.equals("") ? dataTable.getColumn(dataColumnName) : dataTable.getColumnFamily(dataFamilyName).getColumn(dataColumnName);
                if (SchemaUtil.isPKColumn(dataColumn)) {
                    continue;
                }
            }
            catch (ColumnNotFoundException dataColumn) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++indexedExpressionCount;
        }
        int indexPkColumnCount = this.dataRowKeySchema.getFieldCount() + indexedExpressionCount - (this.isDataTableSalted ? 1 : 0) - (this.isMultiTenant ? 1 : 0);
        this.rowKeyMetaData = this.newRowKeyMetaData(indexPkColumnCount);
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int dataPosOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nDataPKColumns = this.dataRowKeySchema.getFieldCount() - dataPosOffset;
        if (dataTable.getType() == PTableType.VIEW) {
            List<PColumn> dataPKColumns = dataTable.getPKColumns();
            for (int i3 = dataPosOffset; i3 < dataPKColumns.size(); ++i3) {
                PColumn dataPKColumn = dataPKColumns.get(i3);
                if (dataPKColumn.getViewConstant() == null) continue;
                bitSet.set(i3);
                --nDataPKColumns;
            }
        }
        this.indexTableName = indexTableName;
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize(nIndexPKColumns - nDataPKColumns);
        this.indexedExpressions = Lists.newArrayListWithExpectedSize(nIndexPKColumns - nDataPKColumns);
        this.coveredColumns = Sets.newLinkedHashSetWithExpectedSize(nIndexColumns - nIndexPKColumns);
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize(nIndexColumns - nIndexPKColumns);
        this.nIndexSaltBuckets = nIndexSaltBuckets == null ? 0 : nIndexSaltBuckets;
        this.dataEmptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(dataTable);
        this.emptyKeyValueCFPtr = SchemaUtil.getEmptyColumnFamilyPtr(index);
        this.nDataCFs = dataTable.getColumnFamilies().size();
        this.indexWALDisabled = indexWALDisabled;
        this.immutableRows = dataTable.isImmutableRows();
        int indexColByteSize = 0;
        ColumnResolver resolver = null;
        ArrayList<ParseNode> parseNodes = new ArrayList<ParseNode>(1);
        UDFParseNodeVisitor visitor = new UDFParseNodeVisitor();
        for (int i4 = indexPosOffset; i4 < index.getPKColumns().size(); ++i4) {
            PColumn indexColumn = index.getPKColumns().get(i4);
            String expressionStr = IndexUtil.getIndexColumnExpressionStr(indexColumn);
            try {
                ParseNode parseNode = SQLParser.parseCondition(expressionStr);
                parseNode.accept(visitor);
                parseNodes.add(parseNode);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            resolver = FromCompiler.getResolver(connection, new TableRef(dataTable), visitor.getUdfParseNodes());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        StatementContext context = new StatementContext(new PhoenixStatement(connection), resolver);
        IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
        for (i = indexPosOffset; i < index.getPKColumns().size(); ++i) {
            PColumn indexColumn = index.getPKColumns().get(i);
            int indexPos = i - indexPosOffset;
            Expression expression = null;
            try {
                expressionIndexCompiler.reset();
                expression = ((ParseNode)parseNodes.get(indexPos)).accept(expressionIndexCompiler);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (expressionIndexCompiler.getColumnRef() != null) {
                column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                boolean isPKColumn = SchemaUtil.isPKColumn(column);
                if (isPKColumn) {
                    int dataPkPos = dataTable.getPKColumns().indexOf(column) - (dataTable.getBucketNum() == null ? 0 : 1) - (this.isMultiTenant ? 1 : 0);
                    this.rowKeyMetaData.setIndexPkPosition(dataPkPos, indexPos);
                } else {
                    indexColByteSize += column.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(column) : 10;
                    this.indexedExpressions.add(expression);
                }
            } else {
                indexColByteSize += expression.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(expression) : 10;
                this.indexedExpressions.add(expression);
            }
            if (indexColumn.getSortOrder() != SortOrder.DESC) continue;
            this.rowKeyMetaData.getDescIndexColumnBitSet().set(indexPos);
        }
        this.estimatedExpressionSize = expressionIndexCompiler.getTotalNodeCount() * 8;
        for (i = 0; i < index.getColumnFamilies().size(); ++i) {
            PColumnFamily family = index.getColumnFamilies().get(i);
            for (PColumn indexColumn : family.getColumns()) {
                column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                this.coveredColumns.add(new ColumnReference(column.getFamilyName().getBytes(), column.getName().getBytes()));
                if (!this.isLocalIndex) continue;
                this.coveredColumnsMap.put(new ColumnReference(column.getFamilyName().getBytes(), column.getName().getBytes()), new ColumnReference(this.isLocalIndex ? Bytes.toBytes(IndexUtil.getLocalIndexColumnFamily(column.getFamilyName().getString())) : column.getFamilyName().getBytes(), column.getName().getBytes()));
            }
        }
        this.estimatedIndexRowKeyBytes = this.estimateIndexRowKeyByteSize(indexColByteSize);
        this.initCachedState();
    }

    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr, byte[] regionStartKey, byte[] regionEndKey) {
        boolean isIndexSalted;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean prependRegionStartKey = this.isLocalIndex && regionStartKey != null;
        boolean bl = isIndexSalted = !this.isLocalIndex && this.nIndexSaltBuckets > 0;
        int prefixKeyLength = prependRegionStartKey ? (regionStartKey.length != 0 ? regionStartKey.length : regionEndKey.length) : 0;
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes + (prependRegionStartKey ? prefixKeyLength : 0));
        DataOutputStream output = new DataOutputStream(stream);
        try {
            int length;
            if (prependRegionStartKey) {
                if (regionStartKey.length == 0) {
                    output.write(new byte[prefixKeyLength]);
                } else {
                    output.write(regionStartKey);
                }
            }
            if (isIndexSalted) {
                output.write(0);
            }
            int dataPosOffset = this.isDataTableSalted ? 1 : 0;
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            int nIndexedColumns = this.getIndexPkColumnCount() - this.getNumViewConstants();
            int[][] dataRowKeyLocator = new int[2][nIndexedColumns];
            int maxRowKeyOffset = rowKeyPtr.getOffset() + rowKeyPtr.getLength();
            this.dataRowKeySchema.iterator(rowKeyPtr, ptr, dataPosOffset);
            if (this.isMultiTenant) {
                this.dataRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(0);
                }
                ++dataPosOffset;
            }
            if (this.viewIndexId != null) {
                output.write(this.viewIndexId);
            }
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                Boolean hasValue = this.dataRowKeySchema.next(ptr, i, maxRowKeyOffset);
                if (viewConstantColumnBitSet.get(i)) continue;
                int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                if (Boolean.TRUE.equals(hasValue)) {
                    dataRowKeyLocator[0][pos] = ptr.getOffset();
                    dataRowKeyLocator[1][pos] = ptr.getLength();
                    continue;
                }
                dataRowKeyLocator[0][pos] = 0;
                dataRowKeyLocator[1][pos] = 0;
            }
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            Iterator<Expression> expressionIterator = this.indexedExpressions.iterator();
            for (int i = 0; i < nIndexedColumns; ++i) {
                boolean isNullable;
                SortOrder dataSortOrder;
                PDataType dataColumnType;
                if (this.dataPkPosition[i] == -1) {
                    Expression expression = expressionIterator.next();
                    dataColumnType = expression.getDataType();
                    dataSortOrder = expression.getSortOrder();
                    isNullable = expression.isNullable();
                    expression.evaluate(new ValueGetterTuple(valueGetter), ptr);
                } else {
                    ValueSchema.Field field = this.dataRowKeySchema.getField(this.dataPkPosition[i]);
                    dataColumnType = field.getDataType();
                    ptr.set(rowKeyPtr.get(), dataRowKeyLocator[0][i], dataRowKeyLocator[1][i]);
                    dataSortOrder = field.getSortOrder();
                    isNullable = field.isNullable();
                }
                boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                PDataType indexColumnType = IndexUtil.getIndexColumnDataType(isNullable, dataColumnType);
                boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                if (isBytesComparable && isDataColumnInverted == descIndexColumnBitSet.get(i)) {
                    output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                } else {
                    if (!isBytesComparable) {
                        indexColumnType.coerceBytes(ptr, dataColumnType, dataSortOrder, SortOrder.getDefault());
                    }
                    if (descIndexColumnBitSet.get(i) != isDataColumnInverted) {
                        IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                    } else {
                        output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                    }
                }
                if (indexColumnType.isFixedWidth()) continue;
                output.writeByte(0);
            }
            int minLength = length - this.maxTrailingNulls;
            byte[] indexRowKey = stream.getBuffer();
            for (length = stream.size(); length > minLength && indexRowKey[length - 1] == 0; --length) {
            }
            if (isIndexSalted) {
                byte saltByte;
                indexRowKey[0] = saltByte = SaltingUtil.getSaltingByte(indexRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = indexRowKey.length == length ? indexRowKey : Arrays.copyOf(indexRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] buildDataRowKey(ImmutableBytesWritable indexRowKeyPtr, byte[][] viewConstants) {
        RowKeySchema indexRowKeySchema = this.getIndexRowKeySchema();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        int dataPosOffset = 0;
        int viewConstantsIndex = 0;
        try {
            int length;
            int indexPosOffset = !this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0;
            int maxRowKeyOffset = indexRowKeyPtr.getOffset() + indexRowKeyPtr.getLength();
            indexRowKeySchema.iterator(indexRowKeyPtr, ptr, indexPosOffset);
            if (this.isDataTableSalted) {
                ++dataPosOffset;
                output.write(0);
            }
            if (this.isMultiTenant) {
                indexRowKeySchema.next(ptr, indexPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(0);
                }
                ++indexPosOffset;
                ++dataPosOffset;
            }
            indexPosOffset = (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                if (viewConstantColumnBitSet.get(i)) {
                    output.write(viewConstants[viewConstantsIndex++]);
                } else {
                    int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                    Boolean hasValue = indexRowKeySchema.iterator(indexRowKeyPtr, ptr, pos + indexPosOffset + 1);
                    if (Boolean.TRUE.equals(hasValue)) {
                        ValueSchema.Field dataField = this.dataRowKeySchema.getField(i);
                        ValueSchema.Field indexField = indexRowKeySchema.getField(pos + indexPosOffset);
                        PDataType indexColumnType = indexField.getDataType();
                        PDataType dataColumnType = dataField.getDataType();
                        SortOrder dataSortOrder = dataField.getSortOrder();
                        SortOrder indexSortOrder = indexField.getSortOrder();
                        boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                        boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                        if (isBytesComparable && isDataColumnInverted == descIndexColumnBitSet.get(pos)) {
                            output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                        } else {
                            if (!isBytesComparable) {
                                dataColumnType.coerceBytes(ptr, indexColumnType, indexSortOrder, SortOrder.getDefault());
                            }
                            if (descIndexColumnBitSet.get(pos) != isDataColumnInverted) {
                                IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                            } else {
                                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                            }
                        }
                    }
                }
                if (this.dataRowKeySchema.getField(i).getDataType().isFixedWidth() || i + 1 == this.dataRowKeySchema.getFieldCount()) continue;
                output.writeByte(0);
            }
            int minLength = length - this.maxTrailingNulls;
            byte[] dataRowKey = stream.getBuffer();
            for (length = stream.size(); length > minLength && dataRowKey[length - 1] == 0; --length) {
            }
            if (this.isDataTableSalted) {
                byte saltByte;
                dataRowKey[0] = saltByte = SaltingUtil.getSaltingByte(dataRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = dataRowKey.length == length ? dataRowKey : Arrays.copyOf(dataRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getViewIndexIdFromIndexRowKey(ImmutableBytesWritable indexRowKeyPtr) {
        assert (this.isLocalIndex);
        RowKeySchema indexRowKeySchema = this.getIndexRowKeySchema();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            int indexPosOffset = (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
            Boolean hasValue = indexRowKeySchema.iterator(indexRowKeyPtr, ptr, indexPosOffset);
            if (Boolean.TRUE.equals(hasValue)) {
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
            }
            int length = stream.size();
            byte[] dataRowKey = stream.getBuffer();
            byte[] byArray = dataRowKey.length == length ? dataRowKey : Arrays.copyOf(dataRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private RowKeySchema generateIndexRowKeySchema() {
        int dataPosOffset;
        int nIndexedColumns = this.getIndexPkColumnCount() + (this.isMultiTenant ? 1 : 0) + (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.viewIndexId != null ? 1 : 0) - this.getNumViewConstants();
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(nIndexedColumns);
        if (!this.isLocalIndex && this.nIndexSaltBuckets > 0) {
            builder.addField(SaltingUtil.SALTING_COLUMN, false, SortOrder.ASC);
            --nIndexedColumns;
        }
        int n = dataPosOffset = this.isDataTableSalted ? 1 : 0;
        if (this.isMultiTenant) {
            builder.addField(this.dataRowKeySchema.getField(dataPosOffset++));
            --nIndexedColumns;
        }
        if (this.viewIndexId != null) {
            --nIndexedColumns;
            builder.addField(new PDatum(){

                @Override
                public boolean isNullable() {
                    return false;
                }

                @Override
                public PDataType getDataType() {
                    return MetaDataUtil.getViewIndexIdDataType();
                }

                @Override
                public Integer getMaxLength() {
                    return null;
                }

                @Override
                public Integer getScale() {
                    return null;
                }

                @Override
                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        ValueSchema.Field[] indexFields = new ValueSchema.Field[nIndexedColumns];
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (viewConstantColumnBitSet.get(i)) continue;
            int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
            indexFields[pos] = this.dataRowKeySchema.getField(i);
        }
        Iterator<Expression> expressionItr = this.indexedExpressions.iterator();
        for (ValueSchema.Field indexField : indexFields) {
            if (indexField == null) {
                final PDataType dataType = expressionItr.next().getDataType();
                builder.addField(new PDatum(){

                    @Override
                    public boolean isNullable() {
                        return true;
                    }

                    @Override
                    public PDataType getDataType() {
                        return IndexUtil.getIndexColumnDataType(true, dataType);
                    }

                    @Override
                    public Integer getMaxLength() {
                        return null;
                    }

                    @Override
                    public Integer getScale() {
                        return null;
                    }

                    @Override
                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }
                }, true, SortOrder.getDefault());
                continue;
            }
            builder.addField(indexField);
        }
        return builder.build();
    }

    private int getNumViewConstants() {
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int num = 0;
        for (int i = 0; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (!bitSet.get(i)) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowKeySchema getIndexRowKeySchema() {
        if (this.indexRowKeySchema != null) {
            return this.indexRowKeySchema;
        }
        IndexMaintainer indexMaintainer = this;
        synchronized (indexMaintainer) {
            if (this.indexRowKeySchema == null) {
                this.indexRowKeySchema = this.generateIndexRowKeySchema();
            }
        }
        return this.indexRowKeySchema;
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        Put put = null;
        byte[] indexRowKey = this.buildRowKey(valueGetter, dataRowKeyPtr, regionStartKey, regionEndKey);
        if (valueGetter.getLatestValue(this.dataEmptyKeyValueRef) == null) {
            put = new Put(indexRowKey);
            put.add(kvBuilder.buildPut(new ImmutableBytesPtr(indexRowKey), this.getEmptyKeyValueFamily(), QueryConstants.EMPTY_COLUMN_BYTES_PTR, ts, ByteUtil.EMPTY_BYTE_ARRAY_PTR));
            put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        }
        int i = 0;
        for (ColumnReference ref : this.getCoverededColumns()) {
            ImmutableBytesPtr cq = this.indexQualifiers.get(i++);
            ImmutableBytesPtr value = valueGetter.getLatestValue(ref);
            ImmutableBytesPtr rowKey = new ImmutableBytesPtr(indexRowKey);
            if (value == null) continue;
            if (put == null) {
                put = new Put(indexRowKey);
                put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            if (this.isLocalIndex) {
                ColumnReference columnReference = this.coveredColumnsMap.get(ref);
                put.add(kvBuilder.buildPut(rowKey, columnReference.getFamilyWritable(), cq, ts, value));
                continue;
            }
            put.add(kvBuilder.buildPut(rowKey, ref.getFamilyWritable(), cq, ts, value));
        }
        return put;
    }

    public boolean isRowDeleted(Collection<KeyValue> pendingUpdates) {
        int nDeleteCF = 0;
        for (KeyValue kv : pendingUpdates) {
            if (kv.getTypeByte() != KeyValue.Type.DeleteFamily.getCode()) continue;
            ++nDeleteCF;
        }
        return nDeleteCF == this.nDataCFs;
    }

    private boolean hasIndexedColumnChanged(ValueGetter oldState, Collection<KeyValue> pendingUpdates) throws IOException {
        if (pendingUpdates.isEmpty()) {
            return false;
        }
        HashMap<ColumnReference, KeyValue> newState = Maps.newHashMapWithExpectedSize(pendingUpdates.size());
        for (KeyValue kv : pendingUpdates) {
            newState.put(new ColumnReference(CellUtil.cloneFamily(kv), CellUtil.cloneQualifier(kv)), kv);
        }
        for (ColumnReference ref : this.indexedColumns) {
            boolean newValueSetAsNull;
            KeyValue newValue = (KeyValue)newState.get(ref);
            if (newValue == null) continue;
            ImmutableBytesPtr oldValue = oldState.getLatestValue(ref);
            boolean bl = newValueSetAsNull = newValue.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
            if (newValueSetAsNull && oldValue == null) continue;
            if (oldValue == null && !newValueSetAsNull || oldValue != null && newValueSetAsNull) {
                return true;
            }
            if (Bytes.compareTo(oldValue.get(), oldValue.getOffset(), oldValue.getLength(), newValue.getValueArray(), newValue.getValueOffset(), newValue.getValueLength()) == 0) continue;
            return true;
        }
        return false;
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ImmutableBytesWritable dataRowKeyPtr, long ts) throws IOException {
        return this.buildDeleteMutation(kvBuilder, null, dataRowKeyPtr, Collections.emptyList(), ts, null, null);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter oldState, ImmutableBytesWritable dataRowKeyPtr, Collection<KeyValue> pendingUpdates, long ts, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        byte[] indexRowKey = this.buildRowKey(oldState, dataRowKeyPtr, regionStartKey, regionEndKey);
        if (oldState == null || this.isRowDeleted(pendingUpdates) || this.hasIndexedColumnChanged(oldState, pendingUpdates)) {
            Delete delete = new Delete(indexRowKey, ts);
            byte[] emptyCF = this.emptyKeyValueCFPtr.copyBytesIfNecessary();
            for (ColumnReference ref : this.getCoverededColumns()) {
                if (this.isLocalIndex) {
                    ref = this.coveredColumnsMap.get(ref);
                }
                delete.deleteFamily(ref.getFamily(), ts);
            }
            delete.deleteFamily(emptyCF, ts);
            delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            return delete;
        }
        Delete delete = null;
        for (KeyValue kv : pendingUpdates) {
            ColumnReference ref;
            if (kv.getTypeByte() == KeyValue.Type.Put.getCode() || !this.coveredColumns.contains(ref = new ColumnReference(kv.getFamily(), kv.getQualifier()))) continue;
            if (delete == null) {
                delete = new Delete(indexRowKey);
                delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            ColumnReference coveredColumn = ref;
            if (this.isLocalIndex) {
                coveredColumn = this.coveredColumnsMap.get(ref);
            }
            delete.deleteColumns(coveredColumn.getFamily(), IndexUtil.getIndexColumnName(ref.getFamily(), ref.getQualifier()), ts);
        }
        return delete;
    }

    public byte[] getIndexTableName() {
        return this.indexTableName;
    }

    public Set<ColumnReference> getCoverededColumns() {
        return this.coveredColumns;
    }

    public Set<ColumnReference> getAllColumns() {
        return this.allColumns;
    }

    public ImmutableBytesPtr getEmptyKeyValueFamily() {
        return this.emptyKeyValueCFPtr;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int i;
        boolean hasViewIndexId;
        int encodedIndexSaltBucketsAndMultiTenant = WritableUtils.readVInt(input);
        this.isMultiTenant = encodedIndexSaltBucketsAndMultiTenant < 0;
        this.nIndexSaltBuckets = Math.abs(encodedIndexSaltBucketsAndMultiTenant) - 1;
        int encodedIndexedColumnsAndViewId = WritableUtils.readVInt(input);
        boolean bl = hasViewIndexId = encodedIndexedColumnsAndViewId < 0;
        if (hasViewIndexId) {
            this.viewIndexId = new byte[MetaDataUtil.getViewIndexIdDataType().getByteSize().intValue()];
            input.readFully(this.viewIndexId);
        }
        int nIndexedColumns = Math.abs(encodedIndexedColumnsAndViewId) - 1;
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize(nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            byte[] cf = Bytes.readByteArray(input);
            byte[] cq = Bytes.readByteArray(input);
            this.indexedColumns.add(new ColumnReference(cf, cq));
        }
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize(nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            PDataType type = PDataType.values()[WritableUtils.readVInt(input)];
            this.indexedColumnTypes.add(type);
        }
        int encodedCoveredolumnsAndLocalIndex = WritableUtils.readVInt(input);
        this.isLocalIndex = encodedCoveredolumnsAndLocalIndex < 0;
        int nCoveredColumns = Math.abs(encodedCoveredolumnsAndLocalIndex) - 1;
        this.coveredColumns = Sets.newLinkedHashSetWithExpectedSize(nCoveredColumns);
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize(nCoveredColumns);
        for (int i2 = 0; i2 < nCoveredColumns; ++i2) {
            byte[] cf = Bytes.readByteArray(input);
            byte[] cq = Bytes.readByteArray(input);
            this.coveredColumns.add(new ColumnReference(cf, cq));
            ColumnReference ref = new ColumnReference(cf, cq);
            this.coveredColumns.add(ref);
            if (!this.isLocalIndex) continue;
            this.coveredColumnsMap.put(ref, new ColumnReference(Bytes.toBytes(IndexUtil.getLocalIndexColumnFamily(Bytes.toString(cf))), cq));
        }
        this.indexTableName = Bytes.readByteArray(input);
        this.dataEmptyKeyValueCF = Bytes.readByteArray(input);
        int len = WritableUtils.readVInt(input);
        boolean isNewClient = false;
        if (len < 0) {
            isNewClient = true;
            len = Math.abs(len);
        }
        byte[] emptyKeyValueCF = new byte[len];
        input.readFully(emptyKeyValueCF, 0, len);
        this.emptyKeyValueCFPtr = new ImmutableBytesPtr(emptyKeyValueCF);
        if (isNewClient) {
            int numIndexedExpressions = WritableUtils.readVInt(input);
            this.indexedExpressions = Lists.newArrayListWithExpectedSize(numIndexedExpressions);
            for (int i3 = 0; i3 < numIndexedExpressions; ++i3) {
                Expression expression = ExpressionType.values()[WritableUtils.readVInt(input)].newInstance();
                expression.readFields(input);
                this.indexedExpressions.add(expression);
            }
        } else {
            this.indexedExpressions = Lists.newArrayListWithExpectedSize(this.indexedColumns.size());
            Iterator<ColumnReference> colReferenceIter = this.indexedColumns.iterator();
            Iterator<PDataType> dataTypeIter = this.indexedColumnTypes.iterator();
            while (colReferenceIter.hasNext()) {
                ColumnReference colRef = colReferenceIter.next();
                final PDataType dataType = dataTypeIter.next();
                this.indexedExpressions.add(new KeyValueColumnExpression(new PDatum(){

                    @Override
                    public boolean isNullable() {
                        return true;
                    }

                    @Override
                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }

                    @Override
                    public Integer getScale() {
                        return null;
                    }

                    @Override
                    public Integer getMaxLength() {
                        return null;
                    }

                    @Override
                    public PDataType getDataType() {
                        return dataType;
                    }
                }, colRef.getFamily(), colRef.getQualifier()));
            }
        }
        this.rowKeyMetaData = this.newRowKeyMetaData();
        this.rowKeyMetaData.readFields(input);
        int nDataCFs = WritableUtils.readVInt(input);
        this.indexWALDisabled = nDataCFs < 0;
        this.nDataCFs = Math.abs(nDataCFs) - 1;
        int encodedEstimatedIndexRowKeyBytesAndImmutableRows = WritableUtils.readVInt(input);
        this.immutableRows = encodedEstimatedIndexRowKeyBytesAndImmutableRows < 0;
        this.estimatedIndexRowKeyBytes = Math.abs(encodedEstimatedIndexRowKeyBytesAndImmutableRows);
        this.initCachedState();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, (this.nIndexSaltBuckets + 1) * (this.isMultiTenant ? -1 : 1));
        WritableUtils.writeVInt(output, (this.indexedColumns.size() + 1) * (this.viewIndexId != null ? -1 : 1));
        if (this.viewIndexId != null) {
            output.write(this.viewIndexId);
        }
        for (ColumnReference ref : this.indexedColumns) {
            Bytes.writeByteArray(output, ref.getFamily());
            Bytes.writeByteArray(output, ref.getQualifier());
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            WritableUtils.writeVInt(output, type.ordinal());
        }
        WritableUtils.writeVInt(output, (this.coveredColumns.size() + 1) * (this.isLocalIndex ? -1 : 1));
        for (ColumnReference ref : this.coveredColumns) {
            Bytes.writeByteArray(output, ref.getFamily());
            Bytes.writeByteArray(output, ref.getQualifier());
        }
        Bytes.writeByteArray(output, this.indexTableName);
        Bytes.writeByteArray(output, this.dataEmptyKeyValueCF);
        WritableUtils.writeVInt(output, -this.emptyKeyValueCFPtr.getLength());
        output.write(this.emptyKeyValueCFPtr.get(), this.emptyKeyValueCFPtr.getOffset(), this.emptyKeyValueCFPtr.getLength());
        WritableUtils.writeVInt(output, this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            WritableUtils.writeVInt(output, ExpressionType.valueOf(expression).ordinal());
            expression.write(output);
        }
        this.rowKeyMetaData.write(output);
        WritableUtils.writeVInt(output, (this.nDataCFs + 1) * (this.indexWALDisabled ? -1 : 1));
        WritableUtils.writeVInt(output, this.estimatedIndexRowKeyBytes * (this.immutableRows ? -1 : 1));
    }

    public int getEstimatedByteSize() {
        int size = WritableUtils.getVIntSize(this.nIndexSaltBuckets);
        size += WritableUtils.getVIntSize(this.estimatedIndexRowKeyBytes);
        size += WritableUtils.getVIntSize(this.indexedColumns.size());
        size += this.viewIndexId == null ? 0 : this.viewIndexId.length;
        for (ColumnReference ref : this.indexedColumns) {
            size += WritableUtils.getVIntSize(ref.getFamily().length);
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize(ref.getQualifier().length);
            size += ref.getQualifier().length;
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            size += WritableUtils.getVIntSize(type.ordinal());
        }
        size += WritableUtils.getVIntSize(this.coveredColumns.size());
        for (ColumnReference ref : this.coveredColumns) {
            size += WritableUtils.getVIntSize(ref.getFamilyWritable().getSize());
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize(ref.getQualifierWritable().getSize());
            size += ref.getQualifier().length;
        }
        size += this.indexTableName.length + WritableUtils.getVIntSize(this.indexTableName.length);
        size += this.rowKeyMetaData.getByteSize();
        size += this.dataEmptyKeyValueCF.length + WritableUtils.getVIntSize(this.dataEmptyKeyValueCF.length);
        size += this.emptyKeyValueCFPtr.getLength() + WritableUtils.getVIntSize(this.emptyKeyValueCFPtr.getLength());
        size += WritableUtils.getVIntSize(this.nDataCFs + 1);
        size += WritableUtils.getVIntSize(this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            size += WritableUtils.getVIntSize(ExpressionType.valueOf(expression).ordinal());
        }
        return size += this.estimatedExpressionSize;
    }

    private int estimateIndexRowKeyByteSize(int indexColByteSize) {
        int estimatedIndexRowKeyBytes = indexColByteSize + this.dataRowKeySchema.getEstimatedValueLength() + (this.nIndexSaltBuckets == 0 || this.isLocalIndex || this.isDataTableSalted ? 0 : 1);
        return estimatedIndexRowKeyBytes;
    }

    private void initCachedState() {
        int indexPkPos;
        this.dataEmptyKeyValueRef = new ColumnReference(this.emptyKeyValueCFPtr.copyBytesIfNecessary(), QueryConstants.EMPTY_COLUMN_BYTES);
        this.indexQualifiers = Lists.newArrayListWithExpectedSize(this.coveredColumns.size());
        for (ColumnReference ref : this.coveredColumns) {
            this.indexQualifiers.add(new ImmutableBytesPtr(IndexUtil.getIndexColumnName(ref.getFamily(), ref.getQualifier())));
        }
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize(this.indexedExpressions.size() + this.coveredColumns.size());
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize(this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            KeyValueExpressionVisitor visitor = new KeyValueExpressionVisitor(){

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    IndexMaintainer.this.indexedColumns.add(new ColumnReference(expression.getColumnFamily(), expression.getColumnName()));
                    IndexMaintainer.this.indexedColumnTypes.add(expression.getDataType());
                    return null;
                }
            };
            expression.accept(visitor);
        }
        this.allColumns.addAll(this.indexedColumns);
        this.allColumns.addAll(this.coveredColumns);
        int dataPkOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nIndexPkColumns = this.getIndexPkColumnCount();
        this.dataPkPosition = new int[nIndexPkColumns];
        Arrays.fill(this.dataPkPosition, -1);
        int numViewConstantColumns = 0;
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPkOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (!viewConstantColumnBitSet.get(i)) {
                int indexPkPosition = this.rowKeyMetaData.getIndexPkPosition(i - dataPkOffset);
                this.dataPkPosition[indexPkPosition] = i;
                continue;
            }
            ++numViewConstantColumns;
        }
        int expressionsPos = this.indexedExpressions.size();
        for (indexPkPos = nIndexPkColumns - numViewConstantColumns - 1; indexPkPos >= 0; --indexPkPos) {
            PDataType dataType;
            boolean isDataNullable;
            int dataPkPos = this.dataPkPosition[indexPkPos];
            if (dataPkPos == -1) {
                isDataNullable = true;
                dataType = this.indexedExpressions.get(--expressionsPos).getDataType();
            } else {
                ValueSchema.Field dataField = this.dataRowKeySchema.getField(dataPkPos);
                dataType = dataField.getDataType();
                isDataNullable = dataField.isNullable();
            }
            PDataType indexDataType = IndexUtil.getIndexColumnDataType(isDataNullable, dataType);
            if (indexDataType.isFixedWidth()) break;
        }
        this.maxTrailingNulls = nIndexPkColumns - indexPkPos - 1;
    }

    private int getIndexPkColumnCount() {
        return this.dataRowKeySchema.getFieldCount() + this.indexedExpressions.size() - (this.isDataTableSalted ? 1 : 0) - (this.isMultiTenant ? 1 : 0);
    }

    private RowKeyMetaData newRowKeyMetaData() {
        return this.getIndexPkColumnCount() < 255 ? new ByteSizeRowKeyMetaData() : new IntSizedRowKeyMetaData();
    }

    private RowKeyMetaData newRowKeyMetaData(int capacity) {
        return capacity < 255 ? new ByteSizeRowKeyMetaData(capacity) : new IntSizedRowKeyMetaData(capacity);
    }

    private static void writeInverted(byte[] buf, int offset, int length, DataOutput output) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            byte b = SortOrder.invert(buf[i]);
            output.write(b);
        }
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.allColumns.iterator();
    }

    public ValueGetter createGetterFromKeyValues(final byte[] rowKey, Collection<? extends Cell> pendingUpdates) {
        final HashMap<ColumnReference, ImmutableBytesPtr> valueMap = Maps.newHashMapWithExpectedSize(pendingUpdates.size());
        for (Cell cell : pendingUpdates) {
            ImmutableBytesPtr value = new ImmutableBytesPtr(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            valueMap.put(new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()), value);
        }
        return new ValueGetter(){

            @Override
            public ImmutableBytesPtr getLatestValue(ColumnReference ref) {
                if (ref.equals(IndexMaintainer.this.dataEmptyKeyValueRef)) {
                    return null;
                }
                return (ImmutableBytesPtr)valueMap.get(ref);
            }

            @Override
            public byte[] getRowKey() {
                return rowKey;
            }
        };
    }

    public byte[] getDataEmptyKeyValueCF() {
        return this.dataEmptyKeyValueCF;
    }

    public boolean isLocalIndex() {
        return this.isLocalIndex;
    }

    public boolean isImmutableRows() {
        return this.immutableRows;
    }

    public Set<ColumnReference> getIndexedColumns() {
        return this.indexedColumns;
    }

    public byte[] getViewIndexId() {
        return this.viewIndexId;
    }

    public static class UDFParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

        @Override
        public boolean visitEnter(FunctionParseNode node) throws SQLException {
            if (node instanceof UDFParseNode) {
                this.udfParseNodes.put(node.getName(), (UDFParseNode)node);
            }
            return super.visitEnter(node);
        }

        public Map<String, UDFParseNode> getUdfParseNodes() {
            return this.udfParseNodes;
        }
    }

    private class IntSizedRowKeyMetaData
    extends RowKeyMetaData {
        private int[] indexPkPosition;

        private IntSizedRowKeyMetaData() {
        }

        private IntSizedRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new int[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = indexPkPosition;
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                output.writeInt(this.indexPkPosition[i]);
            }
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length * 4;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new int[IndexMaintainer.this.getIndexPkColumnCount()];
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                this.indexPkPosition[i] = input.readInt();
            }
        }
    }

    private class ByteSizeRowKeyMetaData
    extends RowKeyMetaData {
        private byte[] indexPkPosition;

        private ByteSizeRowKeyMetaData() {
        }

        private ByteSizeRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new byte[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition] + BYTE_OFFSET;
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = (byte)(indexPkPosition - BYTE_OFFSET);
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            output.write(this.indexPkPosition);
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new byte[IndexMaintainer.this.getIndexPkColumnCount()];
            input.readFully(this.indexPkPosition);
        }
    }

    private abstract class RowKeyMetaData
    implements Writable {
        private BitSet descIndexColumnBitSet;
        private BitSet viewConstantColumnBitSet;

        private RowKeyMetaData() {
        }

        private RowKeyMetaData(int nIndexedColumns) {
            this.descIndexColumnBitSet = BitSet.withCapacity(nIndexedColumns);
            this.viewConstantColumnBitSet = BitSet.withCapacity(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected int getByteSize() {
            return BitSet.getByteSize(IndexMaintainer.this.getIndexPkColumnCount()) * 3 + BitSet.getByteSize(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected abstract int getIndexPkPosition(int var1);

        protected abstract int setIndexPkPosition(int var1, int var2);

        @Override
        public void readFields(DataInput input) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            this.descIndexColumnBitSet = BitSet.read(input, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            this.viewConstantColumnBitSet = BitSet.read(input, vclength);
        }

        @Override
        public void write(DataOutput output) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            BitSet.write(output, this.descIndexColumnBitSet, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            BitSet.write(output, this.viewConstantColumnBitSet, vclength);
        }

        private BitSet getDescIndexColumnBitSet() {
            return this.descIndexColumnBitSet;
        }

        private BitSet getViewConstantColumnBitSet() {
            return this.viewConstantColumnBitSet;
        }
    }
}

