/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.scanner;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;

public class FilteredKeyValueScanner
implements KeyValueScanner {
    private KeyValueScanner delegate;
    private Filter filter;

    public FilteredKeyValueScanner(Filter filter, KeyValueStore store) {
        this(filter, store.getScanner());
    }

    private FilteredKeyValueScanner(Filter filter, KeyValueScanner delegate) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Cell peek() {
        return this.delegate.peek();
    }

    @Override
    public Cell next() throws IOException {
        this.seekToNextUnfilteredKeyValue();
        return this.delegate.next();
    }

    @Override
    public boolean seek(Cell key) throws IOException {
        if (this.filter.filterAllRemaining()) {
            return false;
        }
        if (!this.delegate.seek(key)) {
            return false;
        }
        return this.seekToNextUnfilteredKeyValue();
    }

    private boolean seekToNextUnfilteredKeyValue() throws IOException {
        Cell peeked;
        while ((peeked = this.delegate.peek()) != null) {
            Filter.ReturnCode code = this.filter.filterKeyValue(peeked);
            switch (code) {
                case INCLUDE: 
                case INCLUDE_AND_NEXT_COL: {
                    return true;
                }
                case SKIP: 
                case NEXT_COL: 
                case NEXT_ROW: {
                    this.delegate.next();
                    break;
                }
                case SEEK_NEXT_USING_HINT: {
                    this.delegate.seek(KeyValueUtil.ensureKeyValue(this.filter.getNextCellHint(peeked)));
                }
            }
        }
        return false;
    }

    @Override
    public boolean reseek(Cell key) throws IOException {
        this.delegate.reseek(key);
        return this.seekToNextUnfilteredKeyValue();
    }

    @Override
    public boolean requestSeek(Cell kv, boolean forward, boolean useBloom) throws IOException {
        return this.reseek(kv);
    }

    @Override
    public boolean isFileScanner() {
        return false;
    }

    @Override
    public long getSequenceID() {
        return this.delegate.getSequenceID();
    }

    @Override
    public boolean shouldUseScanner(Scan scan, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't support checking to see if it should use a scanner!");
    }

    @Override
    public boolean realSeekDone() {
        return this.delegate.realSeekDone();
    }

    @Override
    public void enforceSeek() throws IOException {
        this.delegate.enforceSeek();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean backwardSeek(Cell arg0) throws IOException {
        return this.delegate.backwardSeek(arg0);
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        return this.delegate.seekToLastRow();
    }

    @Override
    public boolean seekToPreviousRow(Cell arg0) throws IOException {
        return this.delegate.seekToPreviousRow(arg0);
    }

    @Override
    public Cell getNextIndexedKey() {
        return null;
    }
}

