/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.example;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.example.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumnIndexSpecifierBuilder;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.index.BaseIndexCodec;

public class CoveredColumnIndexCodec
extends BaseIndexCodec {
    private static final byte[] EMPTY_BYTES = new byte[0];
    public static final byte[] INDEX_ROW_COLUMN_FAMILY = Bytes.toBytes("INDEXED_COLUMNS");
    private List<ColumnGroup> groups;

    public static CoveredColumnIndexCodec getCodecForTesting(List<ColumnGroup> groups) {
        CoveredColumnIndexCodec codec = new CoveredColumnIndexCodec();
        codec.groups = Lists.newArrayList(groups);
        return codec;
    }

    @Override
    public void initialize(RegionCoprocessorEnvironment env) {
        this.groups = CoveredColumnIndexSpecifierBuilder.getColumns(env.getConfiguration());
    }

    @Override
    public Iterable<IndexUpdate> getIndexUpserts(TableState state) {
        ArrayList<IndexUpdate> updates = new ArrayList<IndexUpdate>();
        for (ColumnGroup group : this.groups) {
            IndexUpdate update = this.getIndexUpdateForGroup(group, state);
            updates.add(update);
        }
        return updates;
    }

    private IndexUpdate getIndexUpdateForGroup(ColumnGroup group, TableState state) {
        List<CoveredColumn> refs = group.getColumns();
        try {
            Pair<Scanner, IndexUpdate> stateInfo = state.getIndexedColumnsTableState(refs);
            Scanner kvs = stateInfo.getFirst();
            Pair<Integer, List<ColumnEntry>> columns = this.getNextEntries(refs, kvs, state.getCurrentRowKey());
            kvs.close();
            if (columns.getFirst() == 0) {
                return stateInfo.getSecond();
            }
            byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(state.getCurrentRowKey(), columns.getFirst(), columns.getSecond());
            Put p = new Put(rowKey, state.getCurrentTimestamp());
            CoveredColumnIndexCodec.addColumnsToPut(p, columns.getSecond());
            IndexUpdate update = stateInfo.getSecond();
            update.setTable(Bytes.toBytes(group.getTable()));
            update.setUpdate(p);
            return update;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception when getting state for columns: " + refs);
        }
    }

    private static void addColumnsToPut(Put indexInsert, List<ColumnEntry> columns) {
        int count = 0;
        for (ColumnEntry column : columns) {
            indexInsert.add(INDEX_ROW_COLUMN_FAMILY, ArrayUtils.addAll(Bytes.toBytes(count++), CoveredColumnIndexCodec.toIndexQualifier(column.ref)), null);
        }
    }

    private static byte[] toIndexQualifier(CoveredColumn column) {
        return ArrayUtils.addAll(Bytes.toBytes(column.familyString + ":"), column.getQualifier());
    }

    @Override
    public Iterable<IndexUpdate> getIndexDeletes(TableState state) {
        ArrayList<IndexUpdate> deletes = new ArrayList<IndexUpdate>();
        for (ColumnGroup group : this.groups) {
            deletes.add(this.getDeleteForGroup(group, state));
        }
        return deletes;
    }

    private IndexUpdate getDeleteForGroup(ColumnGroup group, TableState state) {
        List<CoveredColumn> refs = group.getColumns();
        try {
            Pair<Scanner, IndexUpdate> kvs = state.getIndexedColumnsTableState(refs);
            Pair<Integer, List<ColumnEntry>> columns = this.getNextEntries(refs, kvs.getFirst(), state.getCurrentRowKey());
            kvs.getFirst().close();
            if (columns.getFirst() == 0) {
                return kvs.getSecond();
            }
            byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(state.getCurrentRowKey(), columns.getFirst(), columns.getSecond());
            Delete d = new Delete(rowKey);
            d.setTimestamp(state.getCurrentTimestamp());
            IndexUpdate update = kvs.getSecond();
            update.setUpdate(d);
            update.setTable(Bytes.toBytes(group.getTable()));
            return update;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception when getting state for columns: " + refs);
        }
    }

    private Pair<Integer, List<ColumnEntry>> getNextEntries(List<CoveredColumn> refs, Scanner kvs, byte[] currentRow) throws IOException {
        int totalValueLength = 0;
        ArrayList<ColumnEntry> entries = new ArrayList<ColumnEntry>(refs.size());
        for (CoveredColumn ref : refs) {
            byte[] v;
            KeyValue first = ref.getFirstKeyValueForRow(currentRow);
            if (!kvs.seek(first)) {
                entries.add(new ColumnEntry(null, ref));
                continue;
            }
            Cell next = kvs.next();
            if (ref.matchesFamily(next.getFamily()) && ref.matchesQualifier(next.getQualifier())) {
                v = next.getValue();
                totalValueLength += v.length;
            } else {
                entries.add(new ColumnEntry(null, ref));
                continue;
            }
            entries.add(new ColumnEntry(v, ref));
            if (!ref.allColumns()) continue;
            byte[] lastQual = next.getQualifier();
            byte[] nextQual = null;
            while ((next = kvs.next()) != null && ref.matchesFamily(next.getFamily())) {
                nextQual = next.getQualifier();
                if (Arrays.equals(lastQual, nextQual)) continue;
                byte[] v2 = next.getValue();
                totalValueLength += v2.length;
                entries.add(new ColumnEntry(v2, ref));
                lastQual = nextQual;
            }
        }
        return new Pair<Integer, List<ColumnEntry>>(totalValueLength, entries);
    }

    static byte[] composeRowKey(byte[] pk, int length, List<ColumnEntry> values) {
        byte[] output = new byte[length + pk.length];
        int pos = 0;
        int[] lengths = new int[values.size()];
        int i = 0;
        for (ColumnEntry entry : values) {
            byte[] v = entry.value;
            if (v.length != 0) {
                System.arraycopy(v, 0, output, pos, v.length);
                pos += v.length;
            }
            lengths[i++] = v.length;
        }
        System.arraycopy(pk, 0, output, pos, pk.length);
        for (Object l : (Object)lengths) {
            output = ArrayUtils.addAll(output, Bytes.toBytes((int)l));
        }
        return ArrayUtils.addAll(output, Bytes.toBytes(values.size()));
    }

    public static List<KeyValue> getIndexKeyValueForTesting(byte[] pk, long timestamp, List<Pair<byte[], CoveredColumn>> values) {
        int length = 0;
        ArrayList<ColumnEntry> expected = new ArrayList<ColumnEntry>(values.size());
        for (Pair<byte[], CoveredColumn> value : values) {
            ColumnEntry entry = new ColumnEntry(value.getFirst(), value.getSecond());
            length += value.getFirst().length;
            expected.add(entry);
        }
        byte[] rowKey = CoveredColumnIndexCodec.composeRowKey(pk, length, expected);
        Put p = new Put(rowKey, timestamp);
        CoveredColumnIndexCodec.addColumnsToPut(p, expected);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (Map.Entry entry : p.getFamilyMap().entrySet()) {
            kvs.addAll((Collection)entry.getValue());
        }
        return kvs;
    }

    public static List<byte[]> getValues(byte[] bytes) {
        int keyCount = CoveredColumnIndexCodec.getPreviousInteger(bytes, bytes.length);
        ArrayList<byte[]> keys = new ArrayList<byte[]>(keyCount);
        int[] lengths = new int[keyCount];
        int lengthPos = keyCount - 1;
        int pos = bytes.length - 4;
        for (int i = 0; i < keyCount; ++i) {
            lengths[lengthPos--] = CoveredColumnIndexCodec.getPreviousInteger(bytes, pos);
            pos -= 4;
        }
        int current = 0;
        for (int length : lengths) {
            byte[] key = Arrays.copyOfRange(bytes, current, current + length);
            keys.add(key);
            current += length;
        }
        return keys;
    }

    private static int getPreviousInteger(byte[] bytes, int start) {
        return Bytes.toInt(bytes, start - 4);
    }

    public static boolean checkRowKeyForAllNulls(byte[] bytes) {
        int keyCount = CoveredColumnIndexCodec.getPreviousInteger(bytes, bytes.length);
        int pos = bytes.length - 4;
        for (int i = 0; i < keyCount; ++i) {
            int next = CoveredColumnIndexCodec.getPreviousInteger(bytes, pos);
            if (next > 0) {
                return false;
            }
            pos -= 4;
        }
        return true;
    }

    @Override
    public boolean isEnabled(Mutation m) {
        return this.groups.size() > 0;
    }

    static class ColumnEntry {
        byte[] value = CoveredColumnIndexCodec.access$000();
        CoveredColumn ref;

        public ColumnEntry(byte[] value, CoveredColumn ref) {
            this.value = value == null ? EMPTY_BYTES : value;
            this.ref = ref;
        }
    }
}

