/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class LocalTable
implements LocalHBaseState {
    private RegionCoprocessorEnvironment env;

    public LocalTable(RegionCoprocessorEnvironment env) {
        this.env = env;
    }

    @Override
    public Result getCurrentRowState(Mutation m, Collection<? extends ColumnReference> columns) throws IOException {
        byte[] row = m.getRow();
        Scan s = IndexManagementUtil.newLocalStateScan(Collections.singletonList(columns));
        s.setStartRow(row);
        s.setStopRow(row);
        Region region = this.env.getRegion();
        RegionScanner scanner = region.getScanner(s);
        ArrayList<Cell> kvs = new ArrayList<Cell>(1);
        boolean more = scanner.next(kvs);
        assert (!more) : "Got more than one result when scanning a single row in the primary table!";
        Result r = Result.create(kvs);
        scanner.close();
        return r;
    }
}

