/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.builder.BaseIndexBuilder;
import org.apache.phoenix.hbase.index.covered.Batch;
import org.apache.phoenix.hbase.index.covered.IndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.data.LocalTable;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexUpdateManager;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class CoveredColumnsIndexBuilder
extends BaseIndexBuilder {
    private static final Log LOG = LogFactory.getLog(CoveredColumnsIndexBuilder.class);
    public static final String CODEC_CLASS_NAME_KEY = "org.apache.hadoop.hbase.index.codec.class";
    protected RegionCoprocessorEnvironment env;
    protected IndexCodec codec;
    protected LocalHBaseState localTable;

    @Override
    public void setup(RegionCoprocessorEnvironment env) throws IOException {
        this.env = env;
        Configuration conf = env.getConfiguration();
        Class<IndexCodec> codecClass = conf.getClass(CODEC_CLASS_NAME_KEY, null, IndexCodec.class);
        try {
            Constructor<IndexCodec> meth = codecClass.getDeclaredConstructor(new Class[0]);
            meth.setAccessible(true);
            this.codec = meth.newInstance(new Object[0]);
            this.codec.initialize(env);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.localTable = new LocalTable(env);
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(Mutation mutation) throws IOException {
        IndexUpdateManager updateMap = new IndexUpdateManager();
        this.batchMutationAndAddUpdates(updateMap, mutation);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found index updates for Mutation: " + mutation + "\n" + updateMap);
        }
        return updateMap.toMap();
    }

    private void batchMutationAndAddUpdates(IndexUpdateManager manager, Mutation m) throws IOException {
        Collection<Batch> batches = this.createTimestampBatchesFromMutation(m);
        LocalTableState state = new LocalTableState(this.env, this.localTable, m);
        boolean cleanupCurrentState = true;
        for (Batch batch : batches) {
            if (!this.addMutationsForBatch(manager, batch, state, cleanupCurrentState)) continue;
            cleanupCurrentState = false;
        }
    }

    protected Collection<Batch> createTimestampBatchesFromMutation(Mutation m) {
        HashMap<Long, Batch> batches = new HashMap<Long, Batch>();
        for (List family : m.getFamilyCellMap().values()) {
            List<KeyValue> familyKVs = KeyValueUtil.ensureKeyValues(family);
            this.createTimestampBatchesFromKeyValues(familyKVs, batches);
        }
        ArrayList<Batch> sorted = new ArrayList<Batch>(batches.values());
        Collections.sort(sorted, new Comparator<Batch>(){

            @Override
            public int compare(Batch o1, Batch o2) {
                return Longs.compare(o1.getTimestamp(), o2.getTimestamp());
            }
        });
        return sorted;
    }

    protected void createTimestampBatchesFromKeyValues(Collection<KeyValue> kvs, Map<Long, Batch> batches) {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] nowBytes = Bytes.toBytes(now);
        for (KeyValue kv : kvs) {
            Batch batch;
            long ts = kv.getTimestamp();
            if (kv.updateLatestStamp(nowBytes)) {
                ts = now;
            }
            if ((batch = batches.get(ts)) == null) {
                batch = new Batch(ts);
                batches.put(ts, batch);
            }
            batch.add(kv);
        }
    }

    private boolean addMutationsForBatch(IndexUpdateManager updateMap, Batch batch, LocalTableState state, boolean requireCurrentStateCleanup) throws IOException {
        long batchTs = batch.getTimestamp();
        state.setPendingUpdates(batch.getKvs());
        this.addCleanupForCurrentBatch(updateMap, batchTs, state);
        state.applyPendingUpdates();
        long minTs = this.addUpdateForGivenTimestamp(batchTs, state, updateMap);
        if (ColumnTracker.isNewestTime(minTs)) {
            return false;
        }
        while (!ColumnTracker.isNewestTime(minTs)) {
            minTs = this.addUpdateForGivenTimestamp(minTs, state, updateMap);
        }
        if (requireCurrentStateCleanup) {
            state.rollback(batch.getKvs());
            state.setPendingUpdates(batch.getKvs());
            this.cleanupIndexStateFromBatchOnward(updateMap, batchTs, state);
            state.applyPendingUpdates();
            return true;
        }
        return false;
    }

    private long addUpdateForGivenTimestamp(long ts, LocalTableState state, IndexUpdateManager updateMap) throws IOException {
        state.setCurrentTimestamp(ts);
        ts = this.addCurrentStateMutationsForBatch(updateMap, state);
        return ts;
    }

    private void addCleanupForCurrentBatch(IndexUpdateManager updateMap, long batchTs, LocalTableState state) throws IOException {
        state.setCurrentTimestamp(batchTs);
        this.addDeleteUpdatesToMap(updateMap, state, batchTs);
        state.resetTrackedColumns();
    }

    private long addCurrentStateMutationsForBatch(IndexUpdateManager updateMap, LocalTableState state) throws IOException {
        Iterable<IndexUpdate> upserts = this.codec.getIndexUpserts(state);
        state.resetTrackedColumns();
        long minTs = Long.MAX_VALUE;
        ArrayList<ColumnTracker> columnHints = new ArrayList<ColumnTracker>();
        for (IndexUpdate update : upserts) {
            ColumnTracker tracker = update.getIndexedColumns();
            long trackerTs = tracker.getTS();
            if (trackerTs < minTs) {
                minTs = tracker.getTS();
            }
            boolean needsCleanup = false;
            if (tracker.hasNewerTimestamps()) {
                columnHints.add(tracker);
                needsCleanup = true;
            }
            if (!update.isValid()) continue;
            byte[] table = update.getTableName();
            Mutation mutation = update.getUpdate();
            updateMap.addIndexUpdate(table, mutation);
            if (!needsCleanup) continue;
            Delete d = new Delete(mutation.getRow());
            d.setTimestamp(tracker.getTS());
            updateMap.addIndexUpdate(table, d);
        }
        return minTs;
    }

    private void cleanupIndexStateFromBatchOnward(IndexUpdateManager updateMap, long batchTs, LocalTableState state) throws IOException {
        state.setCurrentTimestamp(batchTs);
        this.addDeleteUpdatesToMap(updateMap, state, batchTs);
        Set<ColumnTracker> trackers = state.getTrackedColumns();
        long minTs = Long.MAX_VALUE;
        for (ColumnTracker tracker : trackers) {
            if (tracker.getTS() >= minTs) continue;
            minTs = tracker.getTS();
        }
        state.resetTrackedColumns();
        if (!ColumnTracker.isNewestTime(minTs)) {
            state.setHints(Lists.newArrayList(trackers));
            this.cleanupIndexStateFromBatchOnward(updateMap, minTs, state);
        }
    }

    protected void addDeleteUpdatesToMap(IndexUpdateManager updateMap, LocalTableState state, long ts) throws IOException {
        Iterable<IndexUpdate> cleanup = this.codec.getIndexDeletes(state);
        if (cleanup != null) {
            for (IndexUpdate d : cleanup) {
                if (!d.isValid()) continue;
                Delete remove = (Delete)d.getUpdate();
                remove.setTimestamp(ts);
                updateMap.addIndexUpdate(d.getTableName(), remove);
            }
        }
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(Delete d) throws IOException {
        IndexUpdateManager updateMap = new IndexUpdateManager();
        NavigableMap<byte[], List<Cell>> families = d.getFamilyCellMap();
        if (families.size() == 0) {
            LocalTableState state = new LocalTableState(this.env, this.localTable, d);
            long now = d.getTimeStamp();
            if (now == Long.MAX_VALUE) {
                now = EnvironmentEdgeManager.currentTimeMillis();
                d.setTimestamp(now);
            }
            this.addDeleteUpdatesToMap(updateMap, state, now);
            byte[] deleteRow = d.getRow();
            for (byte[] family : this.env.getRegion().getTableDesc().getFamiliesKeys()) {
                state.addPendingUpdates(new KeyValue(deleteRow, family, null, now, KeyValue.Type.DeleteFamily));
            }
        } else {
            this.batchMutationAndAddUpdates(updateMap, d);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found index updates for Delete: " + d + "\n" + updateMap);
        }
        return updateMap.toMap();
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<KeyValue> filtered) throws IOException {
        return null;
    }

    public void setIndexCodecForTesting(IndexCodec codec) {
        this.codec = codec;
    }

    @Override
    public boolean isEnabled(Mutation m) throws IOException {
        return this.codec.isEnabled(m);
    }
}

