/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.schema.tuple.BaseTuple;

public abstract class MultiKeyValueComparisonFilter
extends BooleanExpressionFilter {
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    private Boolean matchedColumn;
    protected final IncrementalResultTuple inputTuple = new IncrementalResultTuple();
    protected TreeSet<byte[]> cfSet;

    public MultiKeyValueComparisonFilter() {
    }

    public MultiKeyValueComparisonFilter(Expression expression) {
        super(expression);
        this.init();
    }

    protected abstract Object setColumnKey(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    protected abstract Object newColumnKey(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    protected void init() {
        this.cfSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

            @Override
            public Void visit(KeyValueColumnExpression expression) {
                MultiKeyValueComparisonFilter.this.inputTuple.addColumn(expression.getColumnFamily(), expression.getColumnName());
                return null;
            }
        };
        this.expression.accept(visitor);
        this.expression.reset();
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell keyValue) {
        if (Boolean.TRUE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (Boolean.FALSE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.inputTuple.resolveColumn(KeyValueUtil.ensureKeyValue(keyValue));
        if (code != null) {
            return code;
        }
        this.matchedColumn = this.evaluate(this.inputTuple);
        if (this.matchedColumn == null) {
            if (this.inputTuple.isImmutable()) {
                this.matchedColumn = Boolean.FALSE;
            } else {
                return Filter.ReturnCode.INCLUDE;
            }
        }
        return this.matchedColumn != false ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public boolean filterRow() {
        if (this.matchedColumn == null && !this.inputTuple.isImmutable() && this.expression.requiresFinalEvaluation()) {
            this.inputTuple.setImmutable();
            this.matchedColumn = this.evaluate(this.inputTuple);
        }
        return !Boolean.TRUE.equals(this.matchedColumn);
    }

    @Override
    public void reset() {
        this.matchedColumn = null;
        this.inputTuple.reset();
        super.reset();
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return this.cfSet.contains(name);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    private final class IncrementalResultTuple
    extends BaseTuple {
        private int refCount;
        private final ImmutableBytesWritable keyPtr = new ImmutableBytesWritable(MultiKeyValueComparisonFilter.access$100());
        private final Map<Object, KeyValueRef> foundColumns = new HashMap<Object, KeyValueRef>(5);

        private IncrementalResultTuple() {
        }

        public void reset() {
            this.refCount = 0;
            this.keyPtr.set(UNITIALIZED_KEY_BUFFER);
            for (KeyValueRef ref : this.foundColumns.values()) {
                ref.keyValue = null;
            }
        }

        @Override
        public boolean isImmutable() {
            return this.refCount == this.foundColumns.size();
        }

        public void setImmutable() {
            this.refCount = this.foundColumns.size();
        }

        public Filter.ReturnCode resolveColumn(KeyValue value) {
            this.setKey(value);
            Object ptr = MultiKeyValueComparisonFilter.this.setColumnKey(value.getFamilyArray(), value.getFamilyOffset(), value.getFamilyLength(), value.getQualifierArray(), value.getQualifierOffset(), value.getQualifierLength());
            KeyValueRef ref = this.foundColumns.get(ptr);
            if (ref == null) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (ref.keyValue != null) {
                return Filter.ReturnCode.NEXT_COL;
            }
            ref.keyValue = value;
            ++this.refCount;
            return null;
        }

        public void addColumn(byte[] cf, byte[] cq) {
            Object ptr = MultiKeyValueComparisonFilter.this.newColumnKey(cf, 0, cf.length, cq, 0, cq.length);
            this.foundColumns.put(ptr, new KeyValueRef());
        }

        public void setKey(KeyValue value) {
            this.keyPtr.set(value.getRowArray(), value.getRowOffset(), value.getRowLength());
        }

        @Override
        public void getKey(ImmutableBytesWritable ptr) {
            ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
        }

        @Override
        public KeyValue getValue(byte[] cf, byte[] cq) {
            Object ptr = MultiKeyValueComparisonFilter.this.setColumnKey(cf, 0, cf.length, cq, 0, cq.length);
            KeyValueRef ref = this.foundColumns.get(ptr);
            return ref == null ? null : ref.keyValue;
        }

        public String toString() {
            return this.foundColumns.toString();
        }

        @Override
        public int size() {
            return this.refCount;
        }

        @Override
        public KeyValue getValue(int index) {
            for (KeyValueRef ref : this.foundColumns.values()) {
                if (ref.keyValue == null) continue;
                if (index == 0) {
                    return ref.keyValue;
                }
                --index;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
            KeyValue kv = this.getValue(family, qualifier);
            if (kv == null) {
                return false;
            }
            ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
            return true;
        }
    }

    private static final class KeyValueRef {
        public KeyValue keyValue;

        private KeyValueRef() {
        }

        public String toString() {
            if (this.keyValue != null) {
                return this.keyValue.toString() + " value = " + Bytes.toStringBinary(this.keyValue.getValueArray(), this.keyValue.getValueOffset(), this.keyValue.getValueLength());
            }
            return super.toString();
        }
    }
}

