/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ToNumberParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="TO_NUMBER", nodeClass=ToNumberParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class, PTimestamp.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true, defaultValue="null")})
public class ToNumberFunction
extends ScalarFunction {
    public static final String NAME = "TO_NUMBER";
    private String formatString = null;
    private Format format = null;
    private FunctionArgumentType type;

    public ToNumberFunction() {
    }

    public ToNumberFunction(List<Expression> children, FunctionArgumentType type, String formatString, Format formatter) throws SQLException {
        super(children.subList(0, 1));
        Preconditions.checkNotNull(type);
        this.type = type;
        this.formatString = formatString;
        this.format = formatter;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal decimalValue;
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PDataType type = expression.getDataType();
        if (type.isCoercibleTo(PTimestamp.INSTANCE)) {
            Date date = (Date)type.toObject(ptr, expression.getSortOrder());
            BigDecimal time = new BigDecimal(date.getTime());
            byte[] byteValue = this.getDataType().toBytes(time);
            ptr.set(byteValue);
            return true;
        }
        String stringValue = (String)type.toObject(ptr, expression.getSortOrder());
        if (stringValue == null) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        stringValue = stringValue.trim();
        if (this.format == null) {
            decimalValue = (BigDecimal)this.getDataType().toObject(stringValue);
        } else {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = ((DecimalFormat)this.format).parse(stringValue, parsePosition);
            if (parsePosition.getErrorIndex() > -1) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return true;
            }
            if (number instanceof BigDecimal) {
                decimalValue = (BigDecimal)number;
            } else {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return true;
            }
        }
        byte[] byteValue = this.getDataType().toBytes(decimalValue);
        ptr.set(byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDecimal.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return this.getExpression().isNullable();
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.formatString = WritableUtils.readString(input);
        this.type = WritableUtils.readEnum(input, FunctionArgumentType.class);
        if (this.formatString != null) {
            this.format = this.type.getFormatter(this.formatString);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeString(output, this.formatString);
        WritableUtils.writeEnum(output, this.type);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.formatString == null ? 0 : this.formatString.hashCode());
        result = 31 * result + this.getExpression().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToNumberFunction other = (ToNumberFunction)obj;
        if (this.formatString == null ? other.formatString != null : !this.formatString.equals(other.formatString)) {
            return false;
        }
        return this.getExpression().equals(other.getExpression());
    }
}

