/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTimestamp;

@FunctionParseNode.BuiltInFunction(name="SECOND", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class})})
public class SecondFunction
extends ScalarFunction {
    public static final String NAME = "SECOND";

    public SecondFunction() {
    }

    public SecondFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getChildExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long dateTime = expression.getDataType().getCodec().decodeLong(ptr, expression.getSortOrder());
        int sec = (int)(dateTime / 1000L % 60L);
        PDataType returnType = this.getDataType();
        byte[] byteValue = new byte[returnType.getByteSize().intValue()];
        returnType.getCodec().encodeInt(sec, byteValue, 0);
        ptr.set(byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getChildExpression() {
        return (Expression)this.children.get(0);
    }
}

