/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.util.regex.AbstractBaseSplitter;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.RegexpSplitParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="REGEXP_SPLIT", nodeClass=RegexpSplitParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public abstract class RegexpSplitFunction
extends ScalarFunction {
    public static final String NAME = "REGEXP_SPLIT";
    private static final PVarchar TYPE = PVarchar.INSTANCE;
    private AbstractBaseSplitter initializedSplitter = null;

    public RegexpSplitFunction() {
    }

    public RegexpSplitFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        String pattern;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Expression e = this.getPatternStrExpression();
        if (e.isStateless() && e.getDeterminism() == Determinism.ALWAYS && e.evaluate(null, ptr) && (pattern = (String)TYPE.toObject(ptr, TYPE, e.getSortOrder())) != null) {
            this.initializedSplitter = this.compilePatternSpec(pattern);
        }
    }

    protected abstract AbstractBaseSplitter compilePatternSpec(String var1);

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression e;
        AbstractBaseSplitter splitter = this.initializedSplitter;
        if (splitter == null) {
            e = this.getPatternStrExpression();
            if (!e.evaluate(tuple, ptr)) return false;
            String pattern = (String)TYPE.toObject(ptr, TYPE, e.getSortOrder());
            if (pattern != null) {
                splitter = this.compilePatternSpec(pattern);
            } else {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return true;
            }
        }
        if (!(e = this.getSourceStrExpression()).evaluate(tuple, ptr)) {
            return false;
        }
        TYPE.coerceBytes(ptr, TYPE, e.getSortOrder(), SortOrder.ASC);
        return splitter.split(ptr);
    }

    private Expression getSourceStrExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getPatternStrExpression() {
        return (Expression)this.children.get(1);
    }

    @Override
    public PDataType getDataType() {
        return PVarcharArray.INSTANCE;
    }
}

