/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public abstract class PrefixFunction
extends ScalarFunction {
    public PrefixFunction() {
    }

    public PrefixFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    protected boolean extractNode() {
        return false;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){
            private final List<Expression> extractNodes;
            {
                this.extractNodes = PrefixFunction.this.extractNode() ? Collections.singletonList(PrefixFunction.this) : Collections.emptyList();
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                byte[] lowerRange = KeyRange.UNBOUND;
                byte[] upperRange = KeyRange.UNBOUND;
                boolean lowerInclusive = true;
                PDataType type = this.getColumn().getDataType();
                switch (op) {
                    case EQUAL: {
                        lowerRange = ScalarFunction.evaluateExpression(rhs);
                        upperRange = ByteUtil.nextKey(lowerRange);
                        break;
                    }
                    case GREATER: {
                        lowerRange = ByteUtil.nextKey(ScalarFunction.evaluateExpression(rhs));
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        upperRange = ByteUtil.nextKey(ScalarFunction.evaluateExpression(rhs));
                        lowerInclusive = false;
                        break;
                    }
                    default: {
                        return childPart.getKeyRange(op, rhs);
                    }
                }
                Integer length = this.getColumn().getMaxLength();
                if (type.isFixedWidth() && length != null) {
                    if (lowerRange != KeyRange.UNBOUND) {
                        lowerRange = StringUtil.padChar(lowerRange, length);
                    }
                    if (upperRange != KeyRange.UNBOUND) {
                        upperRange = StringUtil.padChar(upperRange, length);
                    }
                }
                return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, false);
            }
        };
    }
}

