/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;

@FunctionParseNode.BuiltInFunction(name="INVERT", args={@FunctionParseNode.Argument})
public class InvertFunction
extends ScalarFunction {
    public static final String NAME = "INVERT";

    public InvertFunction() throws SQLException {
    }

    public InvertFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChildExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] buf = new byte[ptr.getLength()];
        SortOrder.invert(ptr.get(), ptr.getOffset(), buf, 0, ptr.getLength());
        ptr.set(buf);
        return true;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getChildExpression().getSortOrder() == SortOrder.ASC ? SortOrder.DESC : SortOrder.ASC;
    }

    @Override
    public PDataType getDataType() {
        return this.getChildExpression().getDataType();
    }

    @Override
    public Integer getMaxLength() {
        return this.getChildExpression().getMaxLength();
    }

    @Override
    public boolean isNullable() {
        return this.getChildExpression().isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                KeyRange range = childPart.getKeyRange(op, rhs);
                return range.invert();
            }

            @Override
            public List<Expression> getExtractNodes() {
                return childPart.getExtractNodes();
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }
        };
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    private Expression getChildExpression() {
        return (Expression)this.children.get(0);
    }
}

