/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;

public class FloorDecimalExpression
extends RoundDecimalExpression {
    public FloorDecimalExpression() {
    }

    private FloorDecimalExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(Expression expr, int scale) throws SQLException {
        if (expr.getDataType().isCoercibleTo(PLong.INSTANCE)) {
            return expr;
        }
        LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)scale, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, scaleExpr);
        return new FloorDecimalExpression(expressions);
    }

    public static Expression create(List<Expression> exprs) throws SQLException {
        Expression expr = exprs.get(0);
        if (expr.getDataType().isCoercibleTo(PLong.INSTANCE)) {
            return expr;
        }
        if (exprs.size() == 1) {
            LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)0, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
            exprs = Lists.newArrayList(expr, scaleExpr);
        }
        return new FloorDecimalExpression(exprs);
    }

    public static Expression create(Expression expr) throws SQLException {
        return FloorDecimalExpression.create(expr, 0);
    }

    @Override
    protected RoundingMode getRoundingMode() {
        return RoundingMode.FLOOR;
    }

    @Override
    public String getName() {
        return "FLOOR";
    }

    @Override
    protected KeyRange getInputRangeProducing(BigDecimal result) {
        if (!this.hasEnoughPrecisionToProduce(result)) {
            throw new IllegalArgumentException("Cannot produce input range for decimal " + result + ", not enough precision with scale " + this.getRoundingScale());
        }
        byte[] lowerRange = PDecimal.INSTANCE.toBytes(result);
        byte[] upperRange = PDecimal.INSTANCE.toBytes(this.stepNextInScale(result));
        return KeyRange.getKeyRange(lowerRange, upperRange);
    }
}

