/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueClientAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountServerAggregator;
import org.apache.phoenix.expression.function.DistinctValueWithCountAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;

@FunctionParseNode.BuiltInFunction(name="COLLECTDISTINCT", args={@FunctionParseNode.Argument})
public class DistinctValueAggregateFunction
extends DistinctValueWithCountAggregateFunction {
    public static final String NAME = "COLLECTDISTINCT";

    public DistinctValueAggregateFunction() {
    }

    public DistinctValueAggregateFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        return new DistinctValueWithCountServerAggregator(conf);
    }

    @Override
    public DistinctValueWithCountClientAggregator newClientAggregator() {
        PVarbinary baseType = this.getAggregatorExpression().getDataType().isArrayType() ? PVarbinary.INSTANCE : this.getAggregatorExpression().getDataType();
        PDataType resultType = PDataType.fromTypeId(baseType.getSqlType() + 3000);
        return new DistinctValueClientAggregator(this.getAggregatorExpression().getSortOrder(), baseType, resultType);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public PDataType getDataType() {
        PVarbinary baseType = this.getAggregatorExpression().getDataType().isArrayType() ? PVarbinary.INSTANCE : this.getAggregatorExpression().getDataType();
        return PDataType.fromTypeId(baseType.getSqlType() + 3000);
    }
}

