/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;

public class ArrayElemRefExpression
extends BaseCompoundExpression {
    private int index;

    public ArrayElemRefExpression() {
    }

    public ArrayElemRefExpression(List<Expression> children) {
        super(children);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arrayExpr = (Expression)this.children.get(0);
        return PArrayDataType.positionAtArrayElement(tuple, ptr, this.index, arrayExpr, this.getDataType(), this.getMaxLength());
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return PDataType.fromTypeId(((Expression)this.children.get(0)).getDataType().getSqlType() - 3000);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }
}

