/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortTopNResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.UnionResultIterators;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SQLCloseable;

public class UnionPlan
implements QueryPlan {
    private static final long DEFAULT_ESTIMATED_SIZE = 10240L;
    private final TableRef tableRef;
    private final FilterableStatement statement;
    private final ParameterMetaData paramMetaData;
    private final OrderByCompiler.OrderBy orderBy;
    private final StatementContext context;
    private final Integer limit;
    private final GroupByCompiler.GroupBy groupBy;
    private final RowProjector projector;
    private final boolean isDegenerate;
    private final List<QueryPlan> plans;
    private UnionResultIterators iterators;

    public UnionPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, List<QueryPlan> plans, ParameterMetaData paramMetaData) throws SQLException {
        this.context = context;
        this.statement = statement;
        this.tableRef = table;
        this.projector = projector;
        this.limit = limit;
        this.orderBy = orderBy;
        this.groupBy = groupBy;
        this.plans = plans;
        this.paramMetaData = paramMetaData;
        boolean isDegen = true;
        for (QueryPlan plan : plans) {
            if (plan.getContext().getScanRanges() == ScanRanges.NOTHING) continue;
            isDegen = false;
            break;
        }
        this.isDegenerate = isDegen;
    }

    @Override
    public boolean isDegenerate() {
        return this.isDegenerate;
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.iterators == null) {
            return null;
        }
        return this.iterators.getSplits();
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.iterators == null) {
            return null;
        }
        return this.iterators.getScans();
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public TableRef getTableRef() {
        return this.tableRef;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public RowProjector getProjector() {
        return this.projector;
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(Collections.emptyList());
    }

    @Override
    public final ResultIterator iterator() throws SQLException {
        return this.iterator(Collections.emptyList());
    }

    public final ResultIterator iterator(List<? extends SQLCloseable> dependencies) throws SQLException {
        ResultIterator scanner;
        boolean isOrdered;
        this.iterators = new UnionResultIterators(this.plans);
        boolean bl = isOrdered = !this.orderBy.getOrderByExpressions().isEmpty();
        if (isOrdered) {
            scanner = new MergeSortTopNResultIterator(this.iterators, this.limit, this.orderBy.getOrderByExpressions());
        } else {
            scanner = new ConcatResultIterator(this.iterators);
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        }
        return scanner;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add("UNION ALL OVER " + this.plans.size() + " QUERIES");
        ResultIterator iterator = this.iterator();
        iterator.explain(steps);
        int offset = !this.orderBy.getOrderByExpressions().isEmpty() || this.limit != null ? 1 : 0;
        for (int i = 1; i < steps.size() - offset; ++i) {
            steps.set(i, "    " + (String)steps.get(i));
        }
        return new ExplainPlan(steps);
    }

    @Override
    public long getEstimatedSize() {
        return 10240L;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.paramMetaData;
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return this.groupBy.isEmpty() ? this.orderBy.getOrderByExpressions().isEmpty() : this.groupBy.isOrderPreserving();
    }

    public List<QueryPlan> getPlans() {
        return this.plans;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }
}

