/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.iterate.ChunkedResultIterator;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.MergeSortTopNResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.SerialIterators;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanPlan
extends BaseQueryPlan {
    private static final Logger logger = LoggerFactory.getLogger(ScanPlan.class);
    private List<KeyRange> splits;
    private List<List<Scan>> scans;
    private boolean allowPageFilter;

    public ScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory, boolean allowPageFilter) throws SQLException {
        super(context, statement, table, projector, context.getBindManager().getParameterMetaData(), limit, orderBy, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, parallelIteratorFactory != null ? parallelIteratorFactory : ScanPlan.buildResultIteratorFactory(context, table, orderBy, limit, allowPageFilter));
        this.allowPageFilter = allowPageFilter;
        if (!orderBy.getOrderByExpressions().isEmpty()) {
            int thresholdBytes = context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            ScanRegionObserver.serializeIntoScan(context.getScan(), thresholdBytes, limit == null ? -1 : limit, orderBy.getOrderByExpressions(), projector.getEstimatedRowByteSize());
        }
    }

    private static boolean isSerial(StatementContext context, TableRef tableRef, OrderByCompiler.OrderBy orderBy, Integer limit, boolean allowPageFilter) throws SQLException {
        boolean isSerial;
        long estRegionSize;
        Integer perScanLimit;
        Scan scan = context.getScan();
        boolean isOrdered = !orderBy.getOrderByExpressions().isEmpty();
        Integer n = perScanLimit = !allowPageFilter || isOrdered ? null : limit;
        if (perScanLimit == null || scan.getFilter() != null) {
            return false;
        }
        PTable table = tableRef.getTable();
        GuidePostsInfo gpsInfo = (GuidePostsInfo)table.getTableStats().getGuidePosts().get(SchemaUtil.getEmptyColumnFamily(table));
        long estRowSize = SchemaUtil.estimateRowSize(table);
        if (gpsInfo == null) {
            ConnectionQueryServices services = context.getConnection().getQueryServices();
            HTableDescriptor desc = services.getTableDescriptor(table.getPhysicalName().getBytes());
            int guidepostPerRegion = services.getProps().getInt("phoenix.stats.guidepost.per.region", 0);
            long guidepostWidth = services.getProps().getLong("phoenix.stats.guidepost.width", 314572800L);
            estRegionSize = StatisticsUtil.getGuidePostDepth(guidepostPerRegion, guidepostWidth, desc);
        } else {
            long totByteSize = gpsInfo.getByteCount();
            estRegionSize = totByteSize / (long)(gpsInfo.getGuidePosts().size() + 1);
        }
        boolean bl = isSerial = (long)perScanLimit.intValue() * estRowSize < estRegionSize;
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("With LIMIT=" + perScanLimit + ", estimated row size=" + estRowSize + ", estimated region size=" + estRegionSize + " (" + (gpsInfo == null ? "without " : "with ") + "stats): " + (isSerial ? "SERIAL" : "PARALLEL") + " execution", context.getConnection()));
        }
        return isSerial;
    }

    private static ParallelIteratorFactory buildResultIteratorFactory(StatementContext context, TableRef table, OrderByCompiler.OrderBy orderBy, Integer limit, boolean allowPageFilter) throws SQLException {
        if (ScanPlan.isSerial(context, table, orderBy, limit, allowPageFilter) || ScanUtil.isRoundRobinPossible(orderBy, context)) {
            return ParallelIteratorFactory.NOOP_FACTORY;
        }
        SpoolingResultIterator.SpoolingResultIteratorFactory spoolingResultIteratorFactory = new SpoolingResultIterator.SpoolingResultIteratorFactory(context.getConnection().getQueryServices());
        if (!orderBy.getOrderByExpressions().isEmpty()) {
            return spoolingResultIteratorFactory;
        }
        return new ChunkedResultIterator.ChunkedResultIteratorFactory(spoolingResultIteratorFactory, table);
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    @Override
    protected ResultIterator newIterator(ParallelScanGrouper scanGrouper) throws SQLException {
        ResultIterator scanner;
        Scan scan = this.context.getScan();
        scan.setAttribute("_NonAggregateQuery", QueryConstants.TRUE);
        TableRef tableRef = this.getTableRef();
        PTable table = tableRef.getTable();
        boolean isSalted = table.getBucketNum() != null;
        boolean isOrdered = !this.orderBy.getOrderByExpressions().isEmpty();
        boolean isSerial = ScanPlan.isSerial(this.context, tableRef, this.orderBy, this.limit, this.allowPageFilter);
        Integer perScanLimit = !this.allowPageFilter || isOrdered ? null : this.limit;
        BaseResultIterators iterators = isSerial ? new SerialIterators(this, perScanLimit, this.parallelIteratorFactory, scanGrouper) : new ParallelIterators(this, perScanLimit, this.parallelIteratorFactory, scanGrouper);
        this.splits = iterators.getSplits();
        this.scans = iterators.getScans();
        if (isOrdered) {
            scanner = new MergeSortTopNResultIterator(iterators, this.limit, this.orderBy.getOrderByExpressions());
        } else {
            scanner = (isSalted || table.getIndexType() == PTable.IndexType.LOCAL) && ScanUtil.shouldRowsBeInRowKeyOrder(this.orderBy, this.context) ? new MergeSortRowKeyResultIterator(iterators, isSalted ? 1 : 0, this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) : (this.useRoundRobinIterator() ? new RoundRobinResultIterator(iterators, (QueryPlan)this) : new ConcatResultIterator(iterators));
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            scanner = new SequenceResultIterator(scanner, this.context.getSequenceManager());
        }
        return scanner;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return ScanUtil.isRoundRobinPossible(this.orderBy, this.context);
    }
}

