/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.ClientProcessingPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.BaseGroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.DistinctAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.OrderedAggregatingResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.UngroupedAggregatingResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TupleUtil;

public class ClientAggregatePlan
extends ClientProcessingPlan {
    private final GroupByCompiler.GroupBy groupBy;
    private final Expression having;
    private final Aggregators serverAggregators;
    private final Aggregators clientAggregators;

    public ClientAggregatePlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Expression where, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, Expression having, QueryPlan delegate) {
        super(context, statement, table, projector, limit, where, orderBy, delegate);
        this.groupBy = groupBy;
        this.having = having;
        this.serverAggregators = ServerAggregators.deserialize(context.getScan().getAttribute("_Aggs"), QueryServicesOptions.withDefaults().getConfiguration());
        this.clientAggregators = context.getAggregationManager().getAggregators();
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        AggregatingResultIterator aggResultIterator;
        ResultIterator iterator = this.delegate.iterator(scanGrouper);
        if (this.where != null) {
            iterator = new FilterResultIterator(iterator, this.where);
        }
        if (this.groupBy.isEmpty()) {
            aggResultIterator = new ClientUngroupedAggregatingResultIterator(LookAheadResultIterator.wrap(iterator), this.serverAggregators);
            aggResultIterator = new UngroupedAggregatingResultIterator(LookAheadResultIterator.wrap(aggResultIterator), this.clientAggregators);
        } else {
            if (!this.groupBy.isOrderPreserving()) {
                int thresholdBytes = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
                List<Expression> keyExpressions = this.groupBy.getKeyExpressions();
                ArrayList<OrderByExpression> keyExpressionOrderBy = Lists.newArrayListWithExpectedSize(keyExpressions.size());
                for (Expression keyExpression : keyExpressions) {
                    keyExpressionOrderBy.add(new OrderByExpression(keyExpression, false, true));
                }
                iterator = new OrderedResultIterator(iterator, keyExpressionOrderBy, thresholdBytes, this.limit, this.projector.getEstimatedRowByteSize());
            }
            aggResultIterator = new ClientGroupedAggregatingResultIterator(LookAheadResultIterator.wrap(iterator), this.serverAggregators, this.groupBy.getKeyExpressions());
            aggResultIterator = new GroupedAggregatingResultIterator(LookAheadResultIterator.wrap(aggResultIterator), this.clientAggregators);
        }
        if (this.having != null) {
            aggResultIterator = new FilterAggregatingResultIterator(aggResultIterator, this.having);
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            aggResultIterator = new DistinctAggregatingResultIterator(aggResultIterator, this.getProjector());
        }
        ResultIterator resultScanner = aggResultIterator;
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.limit != null) {
                resultScanner = new LimitingResultIterator(aggResultIterator, this.limit);
            }
        } else {
            int thresholdBytes = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            resultScanner = new OrderedAggregatingResultIterator(aggResultIterator, this.orderBy.getOrderByExpressions(), thresholdBytes, this.limit);
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            resultScanner = new SequenceResultIterator(resultScanner, this.context.getSequenceManager());
        }
        return resultScanner;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList<String> planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        if (this.where != null) {
            planSteps.add("CLIENT FILTER BY " + this.where.toString());
        }
        if (!this.groupBy.isEmpty()) {
            if (!this.groupBy.isOrderPreserving()) {
                planSteps.add("CLIENT SORTED BY " + this.groupBy.getKeyExpressions().toString());
            }
            planSteps.add("CLIENT AGGREGATE INTO DISTINCT ROWS BY " + this.groupBy.getExpressions().toString());
        } else {
            planSteps.add("CLIENT AGGREGATE INTO SINGLE ROW");
        }
        if (this.having != null) {
            planSteps.add("CLIENT AFTER-AGGREGATION FILTER BY " + this.having.toString());
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            planSteps.add("CLIENT DISTINCT ON " + this.projector.toString());
        }
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.limit != null) {
                planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
            }
        } else {
            planSteps.add("CLIENT" + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString());
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            int nSequences = this.context.getSequenceManager().getSequenceCount();
            planSteps.add("CLIENT RESERVE VALUES FROM " + nSequences + " SEQUENCE" + (nSequences == 1 ? "" : "S"));
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    private static class ClientUngroupedAggregatingResultIterator
    extends BaseGroupedAggregatingResultIterator {
        public ClientUngroupedAggregatingResultIterator(PeekingResultIterator iterator, Aggregators aggregators) {
            super(iterator, aggregators);
        }

        @Override
        protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
            ptr.set(QueryConstants.UNGROUPED_AGG_ROW_KEY);
            return ptr;
        }

        @Override
        protected Tuple wrapKeyValueAsResult(KeyValue keyValue) throws SQLException {
            return new MultiKeyValueTuple(Collections.singletonList(keyValue));
        }

        public String toString() {
            return "ClientUngroupedAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + "]";
        }
    }

    private static class ClientGroupedAggregatingResultIterator
    extends BaseGroupedAggregatingResultIterator {
        private final List<Expression> groupByExpressions;

        public ClientGroupedAggregatingResultIterator(PeekingResultIterator iterator, Aggregators aggregators, List<Expression> groupByExpressions) {
            super(iterator, aggregators);
            this.groupByExpressions = groupByExpressions;
        }

        @Override
        protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
            try {
                ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(tuple, this.groupByExpressions);
                ptr.set(key.get(), key.getOffset(), key.getLength());
                return ptr;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }

        @Override
        protected Tuple wrapKeyValueAsResult(KeyValue keyValue) {
            return new MultiKeyValueTuple(Collections.singletonList(keyValue));
        }

        public String toString() {
            return "ClientGroupedAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + ", groupByExpressions=" + this.groupByExpressions + "]";
        }
    }
}

