/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.HashCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TupleUtil;

public class HashJoinRegionScanner
implements RegionScanner {
    private final RegionScanner scanner;
    private final TupleProjector projector;
    private final HashJoinInfo joinInfo;
    private Queue<Tuple> resultQueue;
    private boolean hasMore;
    private long count;
    private long limit;
    private HashCache[] hashCaches;
    private List<Tuple>[] tempTuples;
    private ValueBitSet tempDestBitSet;
    private ValueBitSet[] tempSrcBitSet;

    public HashJoinRegionScanner(RegionScanner scanner, TupleProjector projector, HashJoinInfo joinInfo, ImmutableBytesWritable tenantId, RegionCoprocessorEnvironment env) throws IOException {
        this.scanner = scanner;
        this.projector = projector;
        this.joinInfo = joinInfo;
        this.resultQueue = new LinkedList<Tuple>();
        this.hasMore = true;
        this.count = 0L;
        this.limit = Long.MAX_VALUE;
        for (JoinTableNode.JoinType type : joinInfo.getJoinTypes()) {
            if (type == JoinTableNode.JoinType.Inner || type == JoinTableNode.JoinType.Left || type == JoinTableNode.JoinType.Semi || type == JoinTableNode.JoinType.Anti) continue;
            throw new DoNotRetryIOException("Got join type '" + (Object)((Object)type) + "'. Expect only INNER or LEFT with hash-joins.");
        }
        if (joinInfo.getLimit() != null) {
            this.limit = joinInfo.getLimit().intValue();
        }
        int count = joinInfo.getJoinIds().length;
        this.tempTuples = new List[count];
        this.hashCaches = new HashCache[count];
        this.tempSrcBitSet = new ValueBitSet[count];
        TenantCache cache = GlobalCache.getTenantCache(env, tenantId);
        for (int i = 0; i < count; ++i) {
            ImmutableBytesPtr joinId = joinInfo.getJoinIds()[i];
            if (joinId.getLength() == 0) {
                this.hashCaches[i] = null;
                this.tempSrcBitSet[i] = null;
                this.tempTuples[i] = null;
                continue;
            }
            HashCache hashCache = (HashCache)cache.getServerCache(joinId);
            if (hashCache == null) {
                throw new DoNotRetryIOException("Could not find hash cache for joinId: " + Bytes.toString(joinId.get(), joinId.getOffset(), joinId.getLength()) + ". The cache might have expired and have been removed.");
            }
            this.hashCaches[i] = hashCache;
            this.tempSrcBitSet[i] = ValueBitSet.newInstance(joinInfo.getSchemas()[i]);
        }
        if (this.projector != null) {
            this.tempDestBitSet = ValueBitSet.newInstance(joinInfo.getJoinedSchema());
            this.projector.setValueBitSet(this.tempDestBitSet);
        }
    }

    private void processResults(List<Cell> result, boolean hasBatchLimit) throws IOException {
        if (result.isEmpty()) {
            return;
        }
        BaseTuple tuple = new ResultTuple(Result.create(result));
        if (this.joinInfo.forceProjection()) {
            tuple = this.projector.projectResults(tuple);
        }
        if (hasBatchLimit) {
            throw new UnsupportedOperationException("Cannot support join operations in scans with limit");
        }
        int count = this.joinInfo.getJoinIds().length;
        boolean cont = true;
        for (int i = 0; i < count; ++i) {
            if (!this.joinInfo.earlyEvaluation()[i] || this.hashCaches[i] == null) continue;
            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(tuple, this.joinInfo.getJoinExpressions()[i]);
            this.tempTuples[i] = this.hashCaches[i].get(key);
            JoinTableNode.JoinType type = this.joinInfo.getJoinTypes()[i];
            if ((type != JoinTableNode.JoinType.Inner && type != JoinTableNode.JoinType.Semi || this.tempTuples[i] != null) && (type != JoinTableNode.JoinType.Anti || this.tempTuples[i] == null)) continue;
            cont = false;
            break;
        }
        if (cont) {
            Expression postFilter;
            int i;
            if (this.projector == null) {
                int dup = 1;
                for (i = 0; i < count; ++i) {
                    dup *= this.tempTuples[i] == null ? 1 : this.tempTuples[i].size();
                }
                for (i = 0; i < dup; ++i) {
                    this.resultQueue.offer(tuple);
                }
            } else {
                KeyValueSchema schema = this.joinInfo.getJoinedSchema();
                if (!this.joinInfo.forceProjection()) {
                    tuple = this.projector.projectResults(tuple);
                }
                this.resultQueue.offer(tuple);
                for (i = 0; i < count; ++i) {
                    boolean earlyEvaluation = this.joinInfo.earlyEvaluation()[i];
                    JoinTableNode.JoinType type = this.joinInfo.getJoinTypes()[i];
                    if (earlyEvaluation && (type == JoinTableNode.JoinType.Semi || type == JoinTableNode.JoinType.Anti)) continue;
                    int j = this.resultQueue.size();
                    while (j-- > 0) {
                        Tuple lhs = this.resultQueue.poll();
                        if (!earlyEvaluation) {
                            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(lhs, this.joinInfo.getJoinExpressions()[i]);
                            this.tempTuples[i] = this.hashCaches[i].get(key);
                            if (this.tempTuples[i] == null) {
                                if (type == JoinTableNode.JoinType.Inner || type == JoinTableNode.JoinType.Semi) continue;
                                if (type == JoinTableNode.JoinType.Anti) {
                                    this.resultQueue.offer(lhs);
                                    continue;
                                }
                            }
                        }
                        if (this.tempTuples[i] == null) {
                            Tuple joined = this.tempSrcBitSet[i] == ValueBitSet.EMPTY_VALUE_BITSET ? lhs : TupleProjector.mergeProjectedValue((TupleProjector.ProjectedValueTuple)lhs, schema, this.tempDestBitSet, null, this.joinInfo.getSchemas()[i], this.tempSrcBitSet[i], this.joinInfo.getFieldPositions()[i]);
                            this.resultQueue.offer(joined);
                            continue;
                        }
                        for (Tuple t : this.tempTuples[i]) {
                            Tuple joined = this.tempSrcBitSet[i] == ValueBitSet.EMPTY_VALUE_BITSET ? lhs : TupleProjector.mergeProjectedValue((TupleProjector.ProjectedValueTuple)lhs, schema, this.tempDestBitSet, t, this.joinInfo.getSchemas()[i], this.tempSrcBitSet[i], this.joinInfo.getFieldPositions()[i]);
                            this.resultQueue.offer(joined);
                        }
                    }
                }
            }
            if ((postFilter = this.joinInfo.getPostJoinFilterExpression()) != null) {
                Iterator iter = this.resultQueue.iterator();
                while (iter.hasNext()) {
                    ImmutableBytesWritable tempPtr;
                    block22: {
                        Tuple t = (Tuple)iter.next();
                        postFilter.reset();
                        tempPtr = new ImmutableBytesWritable();
                        try {
                            if (!postFilter.evaluate(t, tempPtr)) {
                                iter.remove();
                            }
                            break block22;
                        }
                        catch (IllegalDataException e) {
                            iter.remove();
                        }
                        continue;
                    }
                    Boolean b = (Boolean)postFilter.getDataType().toObject(tempPtr);
                    if (b.booleanValue()) continue;
                    iter.remove();
                }
            }
        }
    }

    private boolean shouldAdvance() {
        if (!this.resultQueue.isEmpty()) {
            return false;
        }
        return this.hasMore;
    }

    private boolean nextInQueue(List<Cell> results) {
        if (this.resultQueue.isEmpty()) {
            return false;
        }
        Tuple tuple = this.resultQueue.poll();
        for (int i = 0; i < tuple.size(); ++i) {
            results.add(tuple.getValue(i));
        }
        return this.count++ < this.limit && (!this.resultQueue.isEmpty() || this.hasMore);
    }

    @Override
    public long getMvccReadPoint() {
        return this.scanner.getMvccReadPoint();
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.scanner.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() throws IOException {
        return this.scanner.isFilterDone() && this.resultQueue.isEmpty();
    }

    @Override
    public boolean nextRaw(List<Cell> result) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.nextRaw(result);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.nextRaw(result, scannerContext);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean reseek(byte[] row) throws IOException {
        return this.scanner.reseek(row);
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.next(result);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.next(result, scannerContext);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public long getMaxResultSize() {
        return this.scanner.getMaxResultSize();
    }

    @Override
    public int getBatch() {
        return this.scanner.getBatch();
    }
}

