/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class UpsertCompiler {
    private final PhoenixStatement statement;

    private static void setValues(byte[][] values, int[] pkSlotIndex, int[] columnIndexes, PTable table, Map<ImmutableBytesPtr, MutationState.RowMutationState> mutation, PhoenixStatement statement, boolean useServerTimestamp) {
        HashMap<PColumn, byte[]> columnValues = Maps.newHashMapWithExpectedSize(columnIndexes.length);
        byte[][] pkValues = new byte[table.getPKColumns().size()][];
        if (table.getBucketNum() != null) {
            pkValues[0] = new byte[]{0};
        }
        Long rowTimestamp = null;
        MutationState.RowTimestampColInfo rowTsColInfo = new MutationState.RowTimestampColInfo(useServerTimestamp, rowTimestamp);
        for (int i = 0; i < values.length; ++i) {
            byte[] value = values[i];
            PColumn column = table.getColumns().get(columnIndexes[i]);
            if (SchemaUtil.isPKColumn(column)) {
                pkValues[pkSlotIndex[i]] = value;
                if (SchemaUtil.getPKPosition(table, column) != table.getRowTimestampColPos() || useServerTimestamp) continue;
                PColumn rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
                rowTimestamp = PLong.INSTANCE.getCodec().decodeLong(value, 0, rowTimestampCol.getSortOrder());
                if (rowTimestamp < 0L) {
                    throw new IllegalDataException("Value of a column designated as ROW_TIMESTAMP cannot be less than zero");
                }
                rowTsColInfo = new MutationState.RowTimestampColInfo(useServerTimestamp, rowTimestamp);
                continue;
            }
            columnValues.put(column, value);
        }
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        table.newKey(ptr, pkValues);
        mutation.put(ptr, new MutationState.RowMutationState(columnValues, statement.getConnection().getStatementExecutionCounter(), rowTsColInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutationState upsertSelect(PhoenixStatement statement, TableRef tableRef, RowProjector projector, ResultIterator iterator, int[] columnIndexes, int[] pkSlotIndexes, boolean useServerTimestamp) throws SQLException {
        try {
            PhoenixConnection connection = statement.getConnection();
            ConnectionQueryServices services = connection.getQueryServices();
            int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
            boolean isAutoCommit = connection.getAutoCommit();
            byte[][] values = new byte[columnIndexes.length][];
            int rowCount = 0;
            HashMap<ImmutableBytesPtr, MutationState.RowMutationState> mutation = Maps.newHashMapWithExpectedSize(batchSize);
            PTable table = tableRef.getTable();
            PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, statement);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            while (rs.next()) {
                for (int i = 0; i < values.length; ++i) {
                    Integer scale;
                    PColumn column = table.getColumns().get(columnIndexes[i]);
                    byte[] bytes = rs.getBytes(i + 1);
                    ptr.set(bytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : bytes);
                    Object value = rs.getObject(i + 1);
                    int rsPrecision = rs.getMetaData().getPrecision(i + 1);
                    Integer precision = rsPrecision == 0 ? null : Integer.valueOf(rsPrecision);
                    int rsScale = rs.getMetaData().getScale(i + 1);
                    Integer n = scale = rsScale == 0 ? null : Integer.valueOf(rsScale);
                    if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), precision, scale, column.getMaxLength(), column.getScale())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + column.getDataType().toStringLiteral(ptr, null)).build().buildException();
                    }
                    column.getDataType().coerceBytes(ptr, value, column.getDataType(), precision, scale, SortOrder.getDefault(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                    values[i] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                }
                UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, table, mutation, statement, useServerTimestamp);
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state = new MutationState(tableRef, mutation, 0L, maxSize, connection);
                connection.getMutationState().join(state);
                connection.commit();
                mutation.clear();
            }
            MutationState mutationState = new MutationState(tableRef, mutation, rowCount / batchSize * batchSize, maxSize, connection);
            return mutationState;
        }
        finally {
            iterator.close();
        }
    }

    public UpsertCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    private static LiteralParseNode getNodeForRowTimestampColumn(PColumn col) {
        PDataType type = col.getDataType();
        long dummyValue = 0L;
        if (type.isCoercibleTo(PTimestamp.INSTANCE)) {
            return new LiteralParseNode(new Timestamp(dummyValue), PTimestamp.INSTANCE);
        }
        if (type == PLong.INSTANCE || type == PUnsignedLong.INSTANCE) {
            return new LiteralParseNode(dummyValue, PLong.INSTANCE);
        }
        throw new IllegalArgumentException();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutationPlan compile(UpsertStatement upsert) throws SQLException {
        block60: {
            block61: {
                block58: {
                    block59: {
                        block57: {
                            block56: {
                                connection = this.statement.getConnection();
                                services = connection.getQueryServices();
                                maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
                                columnNodes = upsert.getColumns();
                                tableRefToBe = null;
                                table = null;
                                addViewColumnsToBe = Collections.emptySet();
                                overlapViewColumnsToBe = Collections.emptySet();
                                allColumnsToBe = Collections.emptyList();
                                isTenantSpecific = false;
                                isSharedViewIndex = false;
                                tenantIdStr = null;
                                resolver = null;
                                nColumnsToSet = 0;
                                valueNodes = upsert.getValues();
                                tableNode = upsert.getTable();
                                tableName = tableNode.getName().getTableName();
                                schemaName = tableNode.getName().getSchemaName();
                                queryPlanToBe = null;
                                sameTable = false;
                                runOnServer = false;
                                parallelIteratorFactoryToBe = null;
                                retryOnce = connection.getAutoCommit() == false;
                                useServerTimestampToBe = false;
                                block4: while (true) {
                                    try {
                                        while (true) {
                                            resolver = FromCompiler.getResolverForMutation(upsert, connection);
                                            tableRefToBe = resolver.getTables().get(0);
                                            table = tableRefToBe.getTable();
                                            if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
                                                throw new ReadOnlyTableException(schemaName, tableName);
                                            }
                                            isSalted = table.getBucketNum() != null;
                                            isTenantSpecific = table.isMultiTenant() != false && connection.getTenantId() != null;
                                            isSharedViewIndex = table.getViewIndexId() != null;
                                            tenantIdStr = isTenantSpecific != false ? connection.getTenantId().getString() : null;
                                            posOffset = isSalted != false ? 1 : 0;
                                            allColumnsToBe = table.getColumns();
                                            nColumnsToSet = 0;
                                            if (table.getViewType() == PTable.ViewType.UPDATABLE) {
                                                addViewColumnsToBe = Sets.newLinkedHashSetWithExpectedSize(allColumnsToBe.size());
                                                for (PColumn var33_37 : allColumnsToBe) {
                                                    if (var33_37.getViewConstant() == null) continue;
                                                    addViewColumnsToBe.add(var33_37);
                                                }
                                            }
                                            ptr = new ImmutableBytesWritable();
                                            if (columnNodes.isEmpty() || columnNodes.size() == upsert.getTable().getDynamicColumns().size()) {
                                                nColumnsToSet = allColumnsToBe.size() - posOffset;
                                                columnIndexesToBe = new int[nColumnsToSet];
                                                pkSlotIndexesToBe = new int[columnIndexesToBe.length];
                                                targetColumns = Lists.newArrayListWithExpectedSize(columnIndexesToBe.length);
                                                targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
                                                var33_38 = 0;
                                                if (isTenantSpecific) {
                                                    tenantColumn = table.getPKColumns().get(var33_38);
                                                    columnIndexesToBe[var33_38] = tenantColumn.getPosition();
                                                    targetColumns.set(var33_38, tenantColumn);
                                                    ++var33_39;
                                                }
                                                if (isSharedViewIndex) {
                                                    indexIdColumn = table.getPKColumns().get((int)var33_39);
                                                    columnIndexesToBe[var33_39] = indexIdColumn.getPosition();
                                                    targetColumns.set((int)var33_39, indexIdColumn);
                                                    ++var33_40;
                                                }
                                                j = 0;
                                                break block4;
                                            }
                                            var33_42 = columnNodes.size();
                                            nColumnsToSet = var33_42 + addViewColumnsToBe.size() + (isTenantSpecific != false ? 1 : 0) + (isSharedViewIndex != false ? 1 : 0);
                                            columnIndexesToBe = new int[nColumnsToSet];
                                            pkSlotIndexesToBe = new int[columnIndexesToBe.length];
                                            targetColumns = Lists.newArrayListWithExpectedSize(columnIndexesToBe.length);
                                            targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
                                            Arrays.fill(columnIndexesToBe, -1);
                                            Arrays.fill(pkSlotIndexesToBe, -1);
                                            pkColumnsSet = new BitSet(table.getPKColumns().size());
                                            i = 0;
                                            if (isTenantSpecific) {
                                                tenantColumn = table.getPKColumns().get(i + posOffset);
                                                columnIndexesToBe[i] = tenantColumn.getPosition();
                                                pkSlotIndexesToBe[i] = i + posOffset;
                                                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                                                targetColumns.set(i, tenantColumn);
                                                ++i;
                                            }
                                            if (isSharedViewIndex) {
                                                indexIdColumn = table.getPKColumns().get(i + posOffset);
                                                columnIndexesToBe[i] = indexIdColumn.getPosition();
                                                pkSlotIndexesToBe[i] = i + posOffset;
                                                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                                                targetColumns.set(i, (PColumn)indexIdColumn);
                                                ++i;
                                            }
                                            for (ColumnName colName : columnNodes) {
                                                ref = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName());
                                                column = ref.getColumn();
                                                if (IndexUtil.getViewConstantValue(column, ptr)) {
                                                    if (overlapViewColumnsToBe.isEmpty()) {
                                                        overlapViewColumnsToBe = Sets.newHashSetWithExpectedSize(addViewColumnsToBe.size());
                                                    }
                                                    --nColumnsToSet;
                                                    overlapViewColumnsToBe.add(column);
                                                    addViewColumnsToBe.remove(column);
                                                }
                                                columnIndexesToBe[i] = ref.getColumnPosition();
                                                targetColumns.set(i, column);
                                                if (SchemaUtil.isPKColumn(column)) {
                                                    pkSlotIndexesToBe[i] = ref.getPKSlotPosition();
                                                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                                                }
                                                ++i;
                                            }
                                            for (PColumn column : addViewColumnsToBe) {
                                                columnIndexesToBe[i] = column.getPosition();
                                                targetColumns.set(i, column);
                                                if (SchemaUtil.isPKColumn(column)) {
                                                    pkSlotIndexesToBe[i] = SchemaUtil.getPKPosition(table, column);
                                                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                                                }
                                                ++i;
                                            }
                                            v0 = useServerTimestampToBe = table.getRowTimestampColPos() != -1 && UpsertCompiler.isRowTimestampSet(pkSlotIndexesToBe, table) == false;
                                            if (useServerTimestampToBe) {
                                                rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
                                                columnIndexesToBe = Arrays.copyOf(columnIndexesToBe, columnIndexesToBe.length + 1);
                                                pkSlotIndexesToBe = Arrays.copyOf(pkSlotIndexesToBe, pkSlotIndexesToBe.length + 1);
                                                columnIndexesToBe[i] = rowTimestampCol.getPosition();
                                                pkSlotIndexesToBe[i] = table.getRowTimestampColPos();
                                                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                                                targetColumns.add(rowTimestampCol);
                                                if (valueNodes != null && !valueNodes.isEmpty()) {
                                                    valueNodes.add(UpsertCompiler.getNodeForRowTimestampColumn(rowTimestampCol));
                                                }
                                                ++nColumnsToSet;
                                            }
                                            for (i = posOffset; i < table.getPKColumns().size(); ++i) {
                                                pkCol = table.getPKColumns().get(i);
                                                if (pkColumnsSet.get(i) || pkCol.isNullable()) continue;
                                                throw new ConstraintViolationException(table.getName().getString() + "." + pkCol.getName().getString() + " may not be null");
                                            }
                                            break block56;
                                            break;
                                        }
                                    }
                                    catch (MetaDataEntityNotFoundException e) {
                                        if (retryOnce) {
                                            retryOnce = false;
                                            if (new MetaDataClient(connection).updateCache(schemaName, tableName).wasUpdated()) continue;
                                        }
                                        throw e;
                                    }
                                    break;
                                }
                                for (i = posOffset; i < allColumnsToBe.size(); ++i) {
                                    column = (PColumn)allColumnsToBe.get(i);
                                    if (SchemaUtil.isPKColumn(column)) {
                                        pkSlotIndexesToBe[i - posOffset] = j + posOffset;
                                        if (j++ < var33_41) continue;
                                        var33_41 = 0;
                                    }
                                    columnIndexesToBe[i - posOffset + var33_41] = i;
                                    targetColumns.set(i - posOffset + var33_41, column);
                                }
                                if (!addViewColumnsToBe.isEmpty()) {
                                    overlapViewColumnsToBe = addViewColumnsToBe;
                                    addViewColumnsToBe = Collections.emptySet();
                                }
                            }
                            var33_36 = connection.getAutoCommit();
                            if (valueNodes == null) {
                                select = upsert.getSelect();
                                if (!UpsertCompiler.$assertionsDisabled && select == null) {
                                    throw new AssertionError();
                                }
                                select = SubselectRewriter.flatten(select, connection);
                                selectResolver = FromCompiler.getResolverForQuery(select, connection);
                                select = StatementNormalizer.normalize(select, selectResolver);
                                transformedSelect = SubqueryRewriter.transform(select = UpsertCompiler.prependTenantAndViewConstants(table, select, tenantIdStr, addViewColumnsToBe, useServerTimestampToBe), selectResolver, connection);
                                if (transformedSelect != select) {
                                    selectResolver = FromCompiler.getResolverForQuery(transformedSelect, connection);
                                    select = StatementNormalizer.normalize(transformedSelect, selectResolver);
                                }
                                sameTable = select.isJoin() == false && tableRefToBe.equals(selectResolver.getTables().get(0)) != false;
                                tableRefToBe = this.adjustTimestampToMinOfSameTable(tableRefToBe, selectResolver.getTables());
                                if (!(select.isAggregate() || select.isDistinct() || select.getLimit() != null || select.hasSequence())) {
                                    parallelIteratorFactoryToBe = new UpsertingParallelIteratorFactory(connection, tableRefToBe, useServerTimestampToBe);
                                    runOnServer = sameTable != false && var33_36 != false && (table.isImmutableRows() == false || table.getIndexes().isEmpty() != false) && table.getRowTimestampColPos() == -1;
                                }
                                hint = upsert.getHint();
                                if (!upsert.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
                                    hint = HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
                                }
                                select = SelectStatement.create(select, hint);
                                try {
                                    compiler = new QueryCompiler(this.statement, select, selectResolver, targetColumns, parallelIteratorFactoryToBe, new SequenceManager(this.statement), false);
                                    queryPlanToBe = compiler.compile();
                                    if (queryPlanToBe.getTableRef().getTable().getType() == PTableType.PROJECTED || queryPlanToBe.getTableRef().getTable().getType() == PTableType.SUBQUERY) {
                                        parallelIteratorFactoryToBe = null;
                                    }
                                }
                                catch (MetaDataEntityNotFoundException e) {
                                    retryOnce = false;
                                    throw e;
                                }
                                nValuesToSet = queryPlanToBe.getProjector().getColumnCount();
                            } else {
                                nValuesToSet = valueNodes.size() + addViewColumnsToBe.size() + (isTenantSpecific != false ? 1 : 0) + (isSharedViewIndex != false ? 1 : 0);
                            }
                            if (columnNodes.isEmpty() && columnIndexesToBe.length >= nValuesToSet) {
                                nColumnsToSet = nValuesToSet;
                                columnIndexesToBe = Arrays.copyOf(columnIndexesToBe, nValuesToSet);
                                pkSlotIndexesToBe = Arrays.copyOf(pkSlotIndexesToBe, nValuesToSet);
                            }
                            if (nValuesToSet != nColumnsToSet) {
                                if (retryOnce) {
                                    retryOnce = false;
                                    if (new MetaDataClient(connection).updateCache(schemaName, tableName).wasUpdated()) ** continue;
                                }
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UPSERT_COLUMN_NUMBERS_MISMATCH).setMessage("Numbers of columns: " + nColumnsToSet + ". Number of values: " + nValuesToSet).build().buildException();
                            }
                            projectorToBe = null;
                            if (valueNodes == null) {
                                queryPlanToBe = new QueryOptimizer(services).optimize(queryPlanToBe, this.statement, targetColumns, parallelIteratorFactoryToBe);
                                projectorToBe = queryPlanToBe.getProjector();
                                runOnServer &= queryPlanToBe.getTableRef().equals(tableRefToBe);
                            }
                            allColumns = allColumnsToBe;
                            projector = projectorToBe;
                            var33_44 = queryPlanToBe;
                            tableRef = tableRefToBe;
                            addViewColumns = addViewColumnsToBe;
                            overlapViewColumns = overlapViewColumnsToBe;
                            parallelIteratorFactory = parallelIteratorFactoryToBe;
                            columnIndexes = columnIndexesToBe;
                            pkSlotIndexes = pkSlotIndexesToBe;
                            useServerTimestamp = useServerTimestampToBe;
                            if (table.getRowTimestampColPos() == -1 && useServerTimestamp) {
                                throw new IllegalStateException("For a table without row timestamp column, useServerTimestamp cannot be true");
                            }
                            if (valueNodes != null) break block57;
                            UpsertCompiler.throwIfNotUpdatable(tableRef, overlapViewColumnsToBe, targetColumns, projector, sameTable);
                            if (!runOnServer) break block58;
                            allColumnsIndexes = Arrays.copyOf(columnIndexes, columnIndexes.length + nValuesToSet);
                            reverseColumnIndexes = new int[table.getColumns().size()];
                            projectedExpressions = Lists.newArrayListWithExpectedSize(reverseColumnIndexes.length);
                            Arrays.fill(reverseColumnIndexes, -1);
                            for (i = 0; i < nValuesToSet; ++i) {
                                projectedExpressions.add(projector.getColumnProjector(i).getExpression());
                                reverseColumnIndexes[columnIndexes[i]] = i;
                            }
                            offset = table.getBucketNum() == null ? 0 : 1;
                            break block59;
                        }
                        values = new byte[nValuesToSet][];
                        nodeIndex = 0;
                        if (isTenantSpecific) {
                            tenantId = connection.getTenantId();
                            tenantId = ScanUtil.padTenantIdIfNecessary(table.getRowKeySchema(), table.getBucketNum() != null, tenantId);
                            values[nodeIndex++] = connection.getTenantId().getBytes();
                        }
                        if (isSharedViewIndex) {
                            values[nodeIndex++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
                        }
                        break block60;
                    }
                    for (i = 0; i < table.getPKColumns().size() - offset; ++i) {
                        column = table.getPKColumns().get(i + offset);
                        pos = reverseColumnIndexes[column.getPosition()];
                        if (pos == -1) {
                            if (column.getDataType().isFixedWidth()) continue;
                            pos = projectedExpressions.size();
                            literalNull = LiteralExpression.newConstant(null, column.getDataType(), Determinism.ALWAYS);
                            projectedExpressions.add(literalNull);
                            allColumnsIndexes[pos] = column.getPosition();
                        }
                        Collections.swap(projectedExpressions, i, pos);
                        tempPos = allColumnsIndexes[i];
                        allColumnsIndexes[i] = allColumnsIndexes[pos];
                        allColumnsIndexes[pos] = tempPos;
                        reverseColumnIndexes[tempPos] = reverseColumnIndexes[i];
                        reverseColumnIndexes[i] = i;
                    }
                    for (i = 0; i < table.getPKColumns().size(); ++i) {
                        column = table.getPKColumns().get(i);
                        source = (Expression)projectedExpressions.get(i);
                        if (source != null && source.equals(new ColumnRef(tableRef, column.getPosition()).newColumnExpression())) continue;
                        runOnServer = false;
                        break;
                    }
                    if (runOnServer) break block61;
                }
                return new MutationPlan(){

                    @Override
                    public PhoenixConnection getConnection() {
                        return connection;
                    }

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return var33_44.getContext().getBindManager().getParameterMetaData();
                    }

                    @Override
                    public StatementContext getContext() {
                        return var33_44.getContext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MutationState execute() throws SQLException {
                        ResultIterator iterator = var33_44.iterator();
                        if (parallelIteratorFactory == null) {
                            return UpsertCompiler.upsertSelect(UpsertCompiler.this.statement, tableRef, projector, iterator, columnIndexes, pkSlotIndexes, useServerTimestamp);
                        }
                        try {
                            Tuple tuple;
                            parallelIteratorFactory.setRowProjector(projector);
                            parallelIteratorFactory.setColumnIndexes(columnIndexes);
                            parallelIteratorFactory.setPkSlotIndexes(pkSlotIndexes);
                            long totalRowCount = 0L;
                            while ((tuple = iterator.next()) != null) {
                                Cell kv = tuple.getValue(0);
                                totalRowCount += PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                            }
                            MutationState mutationState = new MutationState((long)maxSize, UpsertCompiler.this.statement.getConnection(), totalRowCount);
                            return mutationState;
                        }
                        finally {
                            iterator.close();
                        }
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        List<String> queryPlanSteps = var33_44.getExplainPlan().getPlanSteps();
                        ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                        planSteps.add("UPSERT SELECT");
                        planSteps.addAll(queryPlanSteps);
                        return new ExplainPlan(planSteps);
                    }
                };
            }
            projectedColumns = Lists.newArrayListWithExpectedSize(projectedExpressions.size());
            i = 0;
            while (true) {
                if (i >= projectedExpressions.size()) {
                    projectedTable = PTableImpl.makePTable(table, projectedColumns);
                    select = SelectStatement.create(SelectStatement.COUNT_ONE, upsert.getHint());
                    aggProjector = ProjectionCompiler.compile(var33_44.getContext(), select, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                    context = var33_44.getContext();
                    scan = context.getScan();
                    scan.setAttribute("_UpsertSelectTable", UngroupedAggregateRegionObserver.serialize(projectedTable));
                    scan.setAttribute("_UpsertSelectExprs", UngroupedAggregateRegionObserver.serialize(projectedExpressions));
                    aggPlan = new AggregatePlan(context, (FilterableStatement)select, tableRef, aggProjector, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
                    return new MutationPlan(){

                        @Override
                        public PhoenixConnection getConnection() {
                            return connection;
                        }

                        @Override
                        public ParameterMetaData getParameterMetaData() {
                            return var33_44.getContext().getBindManager().getParameterMetaData();
                        }

                        @Override
                        public StatementContext getContext() {
                            return var33_44.getContext();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public MutationState execute() throws SQLException {
                            ImmutableBytesWritable ptr = context.getTempPtr();
                            tableRef.getTable().getIndexMaintainers(ptr, context.getConnection());
                            try (ServerCacheClient.ServerCache cache = null;){
                                MutationState mutationState;
                                if (ptr.getLength() > 0) {
                                    IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(connection, tableRef);
                                    cache = client.addIndexMetadataCache(context.getScanRanges(), ptr);
                                    byte[] uuidValue = cache.getId();
                                    scan.setAttribute("IdxUUID", uuidValue);
                                }
                                ResultIterator iterator = aggPlan.iterator();
                                try {
                                    Tuple row = iterator.next();
                                    final long mutationCount = (Long)aggProjector.getColumnProjector(0).getValue(row, PLong.INSTANCE, ptr);
                                    mutationState = new MutationState(maxSize, connection){

                                        @Override
                                        public long getUpdateCount() {
                                            return mutationCount;
                                        }
                                    };
                                }
                                catch (Throwable throwable) {
                                    iterator.close();
                                    throw throwable;
                                }
                                iterator.close();
                                return mutationState;
                            }
                        }

                        @Override
                        public ExplainPlan getExplainPlan() throws SQLException {
                            List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                            ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                            planSteps.add("UPSERT ROWS");
                            planSteps.addAll(queryPlanSteps);
                            return new ExplainPlan(planSteps);
                        }
                    };
                }
                column = (PColumn)allColumns.get(allColumnsIndexes[i]);
                projectedColumns.add(column.getPosition() == i ? column : new PColumnImpl(column, i));
                ++i;
            }
        }
        nodeIndexOffset = nodeIndex;
        context = new StatementContext(this.statement, resolver, new Scan(), new SequenceManager(this.statement));
        expressionBuilder = new UpsertValuesCompiler(context);
        constantExpressions = Lists.newArrayListWithExpectedSize(valueNodes.size());
        var47_80 = valueNodes.iterator();
        while (true) {
            if (!var47_80.hasNext()) {
                return new MutationPlan(){

                    @Override
                    public PhoenixConnection getConnection() {
                        return connection;
                    }

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return context.getBindManager().getParameterMetaData();
                    }

                    @Override
                    public StatementContext getContext() {
                        return context;
                    }

                    @Override
                    public MutationState execute() throws SQLException {
                        ImmutableBytesWritable ptr = context.getTempPtr();
                        SequenceManager sequenceManager = context.getSequenceManager();
                        int nodeIndex = nodeIndexOffset;
                        Tuple tuple = sequenceManager.getSequenceCount() == 0 ? null : sequenceManager.newSequenceTuple(null);
                        for (Expression constantExpression : constantExpressions) {
                            PColumn column = (PColumn)allColumns.get(columnIndexes[nodeIndex]);
                            constantExpression.evaluate(tuple, ptr);
                            Object value = null;
                            if (constantExpression.getDataType() != null) {
                                value = constantExpression.getDataType().toObject(ptr, constantExpression.getSortOrder(), constantExpression.getMaxLength(), constantExpression.getScale());
                                if (!constantExpression.getDataType().isCoercibleTo(column.getDataType(), value)) {
                                    throw TypeMismatchException.newException(constantExpression.getDataType(), column.getDataType(), "expression: " + constantExpression.toString() + " in column " + column);
                                }
                                if (!column.getDataType().isSizeCompatible(ptr, value, constantExpression.getDataType(), constantExpression.getMaxLength(), constantExpression.getScale(), column.getMaxLength(), column.getScale())) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                                }
                            }
                            column.getDataType().coerceBytes(ptr, value, constantExpression.getDataType(), constantExpression.getMaxLength(), constantExpression.getScale(), constantExpression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                            if (overlapViewColumns.contains(column) && Bytes.compareTo(ptr.get(), ptr.getOffset(), ptr.getLength(), column.getViewConstant(), 0, column.getViewConstant().length - 1) != 0) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                            }
                            values[nodeIndex] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                            ++nodeIndex;
                        }
                        for (PColumn column : addViewColumns) {
                            if (IndexUtil.getViewConstantValue(column, ptr)) {
                                values[nodeIndex++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                                continue;
                            }
                            throw new IllegalStateException();
                        }
                        HashMap<ImmutableBytesPtr, MutationState.RowMutationState> mutation = Maps.newHashMapWithExpectedSize(1);
                        UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, tableRef.getTable(), mutation, UpsertCompiler.this.statement, useServerTimestamp);
                        return new MutationState(tableRef, mutation, 0L, maxSize, connection);
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(2);
                        if (context.getSequenceManager().getSequenceCount() > 0) {
                            planSteps.add("CLIENT RESERVE " + context.getSequenceManager().getSequenceCount() + " SEQUENCES");
                        }
                        planSteps.add("PUT SINGLE ROW");
                        return new ExplainPlan(planSteps);
                    }
                };
            }
            valueNode = var47_80.next();
            if (!valueNode.isStateless()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VALUE_IN_UPSERT_NOT_CONSTANT).build().buildException();
            }
            column = (PColumn)allColumns.get(columnIndexes[nodeIndex]);
            expressionBuilder.setColumn(column);
            expression = valueNode.accept(expressionBuilder);
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(column.getDataType())) {
                throw TypeMismatchException.newException(expression.getDataType(), column.getDataType(), "expression: " + expression.toString() + " in column " + column);
            }
            constantExpressions.add(expression);
            ++nodeIndex;
        }
    }

    private static boolean isRowTimestampSet(int[] pkSlotIndexes, PTable table) {
        Preconditions.checkArgument(table.getRowTimestampColPos() != -1, "Call this method only for tables with row timestamp column");
        int rowTimestampColPKSlot = table.getRowTimestampColPos();
        for (int pkSlot : pkSlotIndexes) {
            if (pkSlot != rowTimestampColPKSlot) continue;
            return true;
        }
        return false;
    }

    private TableRef adjustTimestampToMinOfSameTable(TableRef upsertRef, List<TableRef> selectRefs) {
        long minTimestamp = Long.MAX_VALUE;
        for (TableRef selectRef : selectRefs) {
            if (!selectRef.equals(upsertRef)) continue;
            minTimestamp = Math.min(minTimestamp, selectRef.getTimeStamp());
        }
        if (minTimestamp != Long.MAX_VALUE) {
            return new TableRef(upsertRef, minTimestamp);
        }
        return upsertRef;
    }

    private static SelectStatement prependTenantAndViewConstants(PTable table, SelectStatement select, String tenantId, Set<PColumn> addViewColumns, boolean useServerTimestamp) {
        if (!(table.isMultiTenant() && tenantId != null || table.getViewIndexId() != null || !addViewColumns.isEmpty() || useServerTimestamp)) {
            return select;
        }
        ArrayList<AliasedNode> selectNodes = Lists.newArrayListWithCapacity(select.getSelect().size() + 1 + addViewColumns.size());
        if (table.isMultiTenant() && tenantId != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(tenantId)));
        }
        if (table.getViewIndexId() != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(table.getViewIndexId())));
        }
        selectNodes.addAll(select.getSelect());
        for (PColumn column : addViewColumns) {
            byte[] byteValue = column.getViewConstant();
            Object value = column.getDataType().toObject(byteValue, 0, byteValue.length - 1);
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(value)));
        }
        if (useServerTimestamp) {
            PColumn rowTimestampCol = table.getPKColumns().get(table.getRowTimestampColPos());
            selectNodes.add(new AliasedNode(null, UpsertCompiler.getNodeForRowTimestampColumn(rowTimestampCol)));
        }
        return SelectStatement.create(select, selectNodes);
    }

    private static void throwIfNotUpdatable(TableRef tableRef, Set<PColumn> overlapViewColumns, List<PColumn> targetColumns, RowProjector projector, boolean sameTable) throws SQLException {
        PTable table = tableRef.getTable();
        if (table.getViewType() == PTable.ViewType.UPDATABLE && !overlapViewColumns.isEmpty()) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            for (int i = 0; i < targetColumns.size(); ++i) {
                PColumn targetColumn = targetColumns.get(i);
                if (!overlapViewColumns.contains(targetColumn)) continue;
                Expression source = projector.getColumnProjector(i).getExpression();
                if (source.isStateless()) {
                    source.evaluate(null, ptr);
                    if (Bytes.compareTo(ptr.get(), ptr.getOffset(), ptr.getLength(), targetColumn.getViewConstant(), 0, targetColumn.getViewConstant().length - 1) == 0) continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(targetColumn.getName().getString()).build().buildException();
            }
        }
    }

    private static final class UpsertValuesCompiler
    extends ExpressionCompiler {
        private PColumn column;

        private UpsertValuesCompiler(StatementContext context) {
            super(context);
        }

        public void setColumn(PColumn column) {
            this.column = column;
        }

        @Override
        public Expression visit(BindParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                this.context.getBindManager().addParamMetaData(node, this.column);
                Object value = this.context.getBindManager().getBindValue(node);
                return LiteralExpression.newConstant(value, this.column.getDataType(), this.column.getSortOrder(), Determinism.ALWAYS);
            }
            return super.visit(node);
        }

        @Override
        public Expression visit(LiteralParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                return LiteralExpression.newConstant(node.getValue(), this.column.getDataType(), this.column.getSortOrder(), Determinism.ALWAYS);
            }
            return super.visit(node);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            return this.context.getSequenceManager().newSequenceReference(node);
        }
    }

    private static class UpsertingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;
        private int[] columnIndexes;
        private int[] pkSlotIndexes;
        private final TableRef tableRef;
        private final boolean useSeverTimestamp;

        private UpsertingParallelIteratorFactory(PhoenixConnection connection, TableRef tableRef, boolean useServerTimestamp) {
            super(connection);
            this.tableRef = tableRef;
            this.useSeverTimestamp = useServerTimestamp;
        }

        @Override
        protected MutationState mutate(StatementContext context, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            if (context.getSequenceManager().getSequenceCount() > 0) {
                throw new IllegalStateException("Cannot pipeline upsert when sequence is referenced");
            }
            PhoenixStatement statement = new PhoenixStatement(connection);
            return UpsertCompiler.upsertSelect(statement, this.tableRef, this.projector.cloneIfNecessary(), iterator, this.columnIndexes, this.pkSlotIndexes, this.useSeverTimestamp);
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public void setPkSlotIndexes(int[] pkSlotIndexes) {
            this.pkSlotIndexes = pkSlotIndexes;
        }
    }
}

