/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.SchemaUtil;

public class SequenceValueExpression
extends BaseTerminalExpression {
    private final SequenceKey key;
    final SequenceValueParseNode.Op op;
    private final int index;

    public SequenceValueExpression(SequenceKey key, SequenceValueParseNode.Op op, int index) {
        this.key = key;
        this.op = op;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        byte[] valueBuffer = new byte[PLong.INSTANCE.getByteSize().intValue()];
        PLong.INSTANCE.getCodec().encodeLong(tuple.getSequenceValue(this.index), valueBuffer, 0);
        ptr.set(valueBuffer);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.PER_ROW;
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    public String toString() {
        return this.op.getName() + " VALUE FOR " + SchemaUtil.getTableName(this.key.getSchemaName(), this.key.getSequenceName());
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

