/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PInteger;

public class OrderByCompiler {
    public static OrderBy compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy, Integer limit, RowProjector rowProjector, TupleProjector tupleProjector, boolean isInRowKeyOrder) throws SQLException {
        List<OrderByNode> orderByNodes = statement.getOrderBy();
        if (orderByNodes.isEmpty()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        ExpressionCompiler compiler = new ExpressionCompiler(context, groupBy);
        OrderPreservingTracker tracker = new OrderPreservingTracker(context, groupBy, OrderPreservingTracker.Ordering.ORDERED, orderByNodes.size(), tupleProjector);
        LinkedHashSet<OrderByExpression> orderByExpressions = Sets.newLinkedHashSetWithExpectedSize(orderByNodes.size());
        for (OrderByNode node : orderByNodes) {
            ParseNode parseNode = node.getNode();
            Expression expression = null;
            if (parseNode instanceof LiteralParseNode && ((LiteralParseNode)parseNode).getType() == PInteger.INSTANCE) {
                Integer index = (Integer)((LiteralParseNode)parseNode).getValue();
                int size = rowProjector.getColumnProjectors().size();
                if (index > size || index <= 0) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_INDEX_OUT_OF_BOUND).build().buildException();
                }
                expression = rowProjector.getColumnProjector(index - 1).getExpression();
            } else {
                expression = node.getNode().accept(compiler);
                if (!expression.isStateless() && !compiler.isAggregate() && (statement.isAggregate() || statement.isDistinct())) {
                    if (statement.isDistinct()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.ORDER_BY_NOT_IN_SELECT_DISTINCT).setMessage(expression.toString()).build().buildException();
                    }
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
                }
            }
            if (!expression.isStateless()) {
                boolean isAscending = node.isAscending();
                boolean isNullsLast = node.isNullsLast();
                tracker.track(expression, isAscending ? SortOrder.ASC : SortOrder.DESC, isNullsLast);
                if (expression.getSortOrder() == SortOrder.DESC) {
                    isAscending = !isAscending;
                    isNullsLast = !isNullsLast;
                }
                OrderByExpression orderByExpression = new OrderByExpression(expression, isNullsLast, isAscending);
                orderByExpressions.add(orderByExpression);
            }
            compiler.reset();
        }
        if (orderByExpressions.isEmpty()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        if (isInRowKeyOrder && tracker.isOrderPreserving()) {
            if (tracker.isReverse()) {
                if (context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.useReverseScan", true) && !context.getScanRanges().useSkipScanFilter() && context.getCurrentTable().getTable().getType() != PTableType.PROJECTED && context.getCurrentTable().getTable().getType() != PTableType.SUBQUERY) {
                    return OrderBy.REV_ROW_KEY_ORDER_BY;
                }
            } else {
                return OrderBy.FWD_ROW_KEY_ORDER_BY;
            }
        }
        return new OrderBy(Lists.newArrayList(orderByExpressions.iterator()));
    }

    private OrderByCompiler() {
    }

    public static class OrderBy {
        public static final OrderBy EMPTY_ORDER_BY = new OrderBy(Collections.emptyList());
        public static final OrderBy FWD_ROW_KEY_ORDER_BY = new OrderBy(Collections.emptyList());
        public static final OrderBy REV_ROW_KEY_ORDER_BY = new OrderBy(Collections.emptyList());
        private final List<OrderByExpression> orderByExpressions;

        private OrderBy(List<OrderByExpression> orderByExpressions) {
            this.orderByExpressions = ImmutableList.copyOf(orderByExpressions);
        }

        public List<OrderByExpression> getOrderByExpressions() {
            return this.orderByExpressions;
        }
    }
}

