/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DMLStatement;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SingleTableStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.AmbiguousTableException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnFamilyImpl;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromCompiler {
    private static final Logger logger = LoggerFactory.getLogger(FromCompiler.class);
    public static final ColumnResolver EMPTY_TABLE_RESOLVER = new ColumnResolver(){

        @Override
        public List<TableRef> getTables() {
            return Collections.emptyList();
        }

        @Override
        public List<PFunction> getFunctions() {
            return Collections.emptyList();
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PFunction resolveFunction(String functionName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasUDFs() {
            return false;
        }
    };

    public static ColumnResolver getResolverForCreation(CreateTableStatement statement, PhoenixConnection connection) throws SQLException {
        TableName baseTable = statement.getBaseTableName();
        if (baseTable == null) {
            return EMPTY_TABLE_RESOLVER;
        }
        NamedTableNode tableNode = NamedTableNode.create(null, baseTable, Collections.emptyList());
        try {
            SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableNode, true);
            return visitor;
        }
        catch (TableNotFoundException e) {
            if (connection.getTenantId() == null && statement.getTableType() == PTableType.VIEW) {
                ConnectionQueryServices services = connection.getQueryServices();
                byte[] fullTableName = SchemaUtil.getTableNameAsBytes(baseTable.getSchemaName(), baseTable.getTableName());
                HTableInterface htable = null;
                try {
                    htable = services.getTable(fullTableName);
                }
                catch (UnsupportedOperationException ignore) {
                    throw e;
                }
                finally {
                    if (htable != null) {
                        Closeables.closeQuietly(htable);
                    }
                }
                tableNode = NamedTableNode.create(null, baseTable, statement.getColumnDefs());
                return new SingleTableColumnResolver(connection, tableNode, e.getTimeStamp(), new HashMap<String, UDFParseNode>(1));
            }
            throw e;
        }
    }

    public static ColumnResolver getResolverForQuery(SelectStatement statement, PhoenixConnection connection) throws SQLException {
        TableNode fromNode = statement.getFrom();
        if (fromNode == null) {
            return EMPTY_TABLE_RESOLVER;
        }
        if (fromNode instanceof NamedTableNode) {
            return new SingleTableColumnResolver(connection, (NamedTableNode)fromNode, true, 1, statement.getUdfParseNodes());
        }
        MultiTableColumnResolver visitor = new MultiTableColumnResolver(connection, 1, statement.getUdfParseNodes());
        fromNode.accept(visitor);
        return visitor;
    }

    public static ColumnResolver getResolver(NamedTableNode tableNode, PhoenixConnection connection) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableNode, true);
        return visitor;
    }

    public static ColumnResolver getResolver(NamedTableNode tableNode, PhoenixConnection connection, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableNode, true, 0, udfParseNodes);
        return visitor;
    }

    public static ColumnResolver getResolver(SingleTableStatement statement, PhoenixConnection connection) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, statement.getTable(), true);
        return visitor;
    }

    public static ColumnResolver getResolver(SingleTableStatement statement, PhoenixConnection connection, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, statement.getTable(), true, 0, udfParseNodes);
        return visitor;
    }

    public static ColumnResolver getResolverForCompiledDerivedTable(PhoenixConnection connection, TableRef tableRef, RowProjector projector) throws SQLException {
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        PTable table = tableRef.getTable();
        for (PColumn column : table.getColumns()) {
            Expression sourceExpression = projector.getColumnProjector(column.getPosition()).getExpression();
            PColumnImpl projectedColumn = new PColumnImpl(column.getName(), column.getFamilyName(), sourceExpression.getDataType(), sourceExpression.getMaxLength(), sourceExpression.getScale(), sourceExpression.isNullable(), column.getPosition(), sourceExpression.getSortOrder(), column.getArraySize(), column.getViewConstant(), column.isViewReferenced(), column.getExpressionStr(), column.isRowTimestamp());
            projectedColumns.add(projectedColumn);
        }
        PTableImpl t = PTableImpl.makePTable(table, projectedColumns);
        return new SingleTableColumnResolver(connection, new TableRef(tableRef.getTableAlias(), t, tableRef.getLowerBoundTimeStamp(), tableRef.hasDynamicCols()));
    }

    public static ColumnResolver getResolver(TableRef tableRef) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(tableRef);
        return visitor;
    }

    public static ColumnResolver getResolver(PhoenixConnection connection, TableRef tableRef, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableRef, udfParseNodes);
        return visitor;
    }

    public static ColumnResolver getResolverForMutation(DMLStatement statement, PhoenixConnection connection) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, statement.getTable(), false, 0, statement.getUdfParseNodes());
        return visitor;
    }

    public static ColumnResolver getResolverForProjectedTable(PTable projectedTable, PhoenixConnection connection, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
        return new ProjectedTableColumnResolver(projectedTable, connection, udfParseNodes);
    }

    private static class ProjectedTableColumnResolver
    extends MultiTableColumnResolver {
        private final boolean isLocalIndex;
        private final List<TableRef> theTableRefs;
        private final Map<ColumnRef, Integer> columnRefMap;

        private ProjectedTableColumnResolver(PTable projectedTable, PhoenixConnection conn, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            super(conn, 0, udfParseNodes);
            int i;
            Preconditions.checkArgument(projectedTable.getType() == PTableType.PROJECTED);
            this.isLocalIndex = projectedTable.getIndexType() == PTable.IndexType.LOCAL;
            this.columnRefMap = new HashMap<ColumnRef, Integer>();
            long ts = Long.MAX_VALUE;
            int n = i = projectedTable.getBucketNum() == null ? 0 : 1;
            while (i < projectedTable.getColumns().size()) {
                PColumn column = projectedTable.getColumns().get(i);
                ColumnRef colRef = ((ProjectedColumn)column).getSourceColumnRef();
                TableRef tableRef = colRef.getTableRef();
                if (!this.tables.contains(tableRef)) {
                    String alias = tableRef.getTableAlias();
                    if (alias != null) {
                        this.tableMap.put(alias, tableRef);
                    }
                    String name = tableRef.getTable().getName().getString();
                    if (alias == null || !alias.equals(name)) {
                        this.tableMap.put(name, tableRef);
                    }
                    this.tables.add(tableRef);
                    if (tableRef.getLowerBoundTimeStamp() < ts) {
                        ts = tableRef.getLowerBoundTimeStamp();
                    }
                }
                this.columnRefMap.put(new ColumnRef(tableRef, colRef.getColumnPosition()), column.getPosition());
                ++i;
            }
            this.theTableRefs = ImmutableList.of(new TableRef(ParseNodeFactory.createTempAlias(), projectedTable, ts, false));
        }

        @Override
        public List<TableRef> getTables() {
            return this.theTableRefs;
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            ColumnRef colRef;
            try {
                colRef = super.resolveColumn(schemaName, tableName, colName);
            }
            catch (ColumnNotFoundException e) {
                TableRef tableRef;
                TableRef tableRef2 = tableRef = this.isLocalIndex ? super.getTables().get(0) : super.resolveTable(schemaName, tableName);
                if (tableRef.getTable().getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        TableRef parentTableRef = super.resolveTable(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getParentTableName().getString());
                        colRef = new ColumnRef(parentTableRef, IndexUtil.getDataColumnFamilyName(colName), IndexUtil.getDataColumnName(colName));
                    }
                    catch (TableNotFoundException te) {
                        throw e;
                    }
                }
                throw e;
            }
            Integer position = this.columnRefMap.get(colRef);
            if (position == null) {
                throw new ColumnNotFoundException(colName);
            }
            return new ColumnRef(this.theTableRefs.get(0), position);
        }
    }

    private static class MultiTableColumnResolver
    extends BaseColumnResolver
    implements TableNodeVisitor<Void> {
        protected final ListMultimap<String, TableRef> tableMap = ArrayListMultimap.create();
        protected final List<TableRef> tables = Lists.newArrayList();

        private MultiTableColumnResolver(PhoenixConnection connection, int tsAddition) {
            super(connection, tsAddition);
        }

        private MultiTableColumnResolver(PhoenixConnection connection, int tsAddition, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            super(connection, tsAddition, false, udfParseNodes);
        }

        @Override
        public List<TableRef> getTables() {
            return this.tables;
        }

        @Override
        public Void visit(BindTableNode boundTableNode) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public Void visit(JoinTableNode joinNode) throws SQLException {
            joinNode.getLHS().accept(this);
            joinNode.getRHS().accept(this);
            return null;
        }

        @Override
        public Void visit(NamedTableNode tableNode) throws SQLException {
            String alias = tableNode.getAlias();
            TableRef tableRef = this.createTableRef(tableNode, true);
            PTable theTable = tableRef.getTable();
            if (alias != null) {
                this.tableMap.put(alias, tableRef);
            }
            String name = theTable.getName().getString();
            if (alias == null || !alias.equals(name)) {
                this.tableMap.put(name, tableRef);
            }
            this.tables.add(tableRef);
            return null;
        }

        @Override
        public Void visit(DerivedTableNode subselectNode) throws SQLException {
            List<AliasedNode> selectNodes = subselectNode.getSelect().getSelect();
            ArrayList<PColumn> columns = new ArrayList<PColumn>();
            int position = 0;
            for (AliasedNode aliasedNode : selectNodes) {
                String alias = aliasedNode.getAlias();
                if (alias == null) {
                    ParseNode node = aliasedNode.getNode();
                    if (node instanceof WildcardParseNode || node instanceof TableWildcardParseNode || node instanceof FamilyWildcardParseNode) {
                        throw new SQLFeatureNotSupportedException("Wildcard in subqueries not supported.");
                    }
                    alias = SchemaUtil.normalizeIdentifier(node.getAlias());
                }
                if (alias == null) {
                    alias = String.valueOf(position);
                }
                PColumnImpl column = new PColumnImpl(PNameFactory.newName(alias), PNameFactory.newName("0"), null, 0, 0, true, position++, SortOrder.ASC, null, null, false, null, false);
                columns.add(column);
            }
            PTableImpl t = PTableImpl.makePTable(null, PName.EMPTY_NAME, PName.EMPTY_NAME, PTableType.SUBQUERY, null, 0L, 0L, null, null, columns, null, null, Collections.emptyList(), false, Collections.emptyList(), null, null, false, false, false, null, null, null);
            String alias = subselectNode.getAlias();
            TableRef tableRef = new TableRef(alias, t, 0L, false);
            this.tableMap.put(alias, tableRef);
            this.tables.add(tableRef);
            return null;
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            List<TableRef> tableRefs = this.tableMap.get(fullTableName);
            if (tableRefs.size() == 0) {
                throw new TableNotFoundException(fullTableName);
            }
            if (tableRefs.size() > 1) {
                throw new AmbiguousTableException(tableName);
            }
            return tableRefs.get(0);
        }

        private ColumnFamilyRef resolveColumnFamily(String tableName, String cfName) throws SQLException {
            if (tableName == null) {
                ColumnFamilyRef theColumnFamilyRef = null;
                for (TableRef tableRef : this.tables) {
                    try {
                        PColumnFamily columnFamily = tableRef.getTable().getColumnFamily(cfName);
                        if (theColumnFamilyRef != null) {
                            throw new TableNotFoundException(cfName);
                        }
                        theColumnFamilyRef = new ColumnFamilyRef(tableRef, columnFamily);
                    }
                    catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {}
                }
                if (theColumnFamilyRef != null) {
                    return theColumnFamilyRef;
                }
                throw new TableNotFoundException(cfName);
            }
            TableRef tableRef = this.resolveTable(null, tableName);
            PColumnFamily columnFamily = tableRef.getTable().getColumnFamily(cfName);
            return new ColumnFamilyRef(tableRef, columnFamily);
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            if (tableName == null) {
                int theColumnPosition = -1;
                TableRef theTableRef = null;
                for (TableRef tableRef : this.tables) {
                    try {
                        PColumn column = tableRef.getTable().getColumn(colName);
                        if (theTableRef != null) {
                            throw new AmbiguousColumnException(colName);
                        }
                        theTableRef = tableRef;
                        theColumnPosition = column.getPosition();
                    }
                    catch (ColumnNotFoundException columnNotFoundException) {}
                }
                if (theTableRef != null) {
                    return new ColumnRef(theTableRef, theColumnPosition);
                }
                throw new ColumnNotFoundException(colName);
            }
            try {
                TableRef tableRef = this.resolveTable(schemaName, tableName);
                PColumn column = tableRef.getTable().getColumn(colName);
                return new ColumnRef(tableRef, column.getPosition());
            }
            catch (TableNotFoundException e) {
                ColumnFamilyRef cfRef = this.resolveColumnFamily(schemaName, tableName);
                PColumn column = cfRef.getFamily().getColumn(colName);
                return new ColumnRef(cfRef.getTableRef(), column.getPosition());
            }
        }

        private static class ColumnFamilyRef {
            private final TableRef tableRef;
            private final PColumnFamily family;

            ColumnFamilyRef(TableRef tableRef, PColumnFamily family) {
                this.tableRef = tableRef;
                this.family = family;
            }

            public TableRef getTableRef() {
                return this.tableRef;
            }

            public PColumnFamily getFamily() {
                return this.family;
            }
        }
    }

    private static abstract class BaseColumnResolver
    implements ColumnResolver {
        protected final PhoenixConnection connection;
        protected final MetaDataClient client;
        private final int tsAddition;
        protected final Map<String, PFunction> functionMap;
        protected List<PFunction> functions;

        private BaseColumnResolver(PhoenixConnection connection, int tsAddition) {
            this.connection = connection;
            this.client = connection == null ? null : new MetaDataClient(connection);
            this.tsAddition = tsAddition;
            this.functionMap = new HashMap<String, PFunction>(1);
            this.functions = Collections.emptyList();
        }

        private BaseColumnResolver(PhoenixConnection connection, int tsAddition, boolean updateCacheImmediately, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            this.connection = connection;
            this.client = connection == null ? null : new MetaDataClient(connection);
            this.tsAddition = tsAddition;
            this.functionMap = new HashMap<String, PFunction>(1);
            if (udfParseNodes.isEmpty()) {
                this.functions = Collections.emptyList();
            } else {
                this.functions = this.createFunctionRef(new ArrayList<String>(udfParseNodes.keySet()), updateCacheImmediately);
                for (PFunction function : this.functions) {
                    this.functionMap.put(function.getFunctionName(), function);
                }
            }
        }

        protected TableRef createTableRef(NamedTableNode tableNode, boolean updateCacheImmediately) throws SQLException {
            MetaDataProtocol.MetaDataMutationResult result;
            String tableName = tableNode.getName().getTableName();
            String schemaName = tableNode.getName().getSchemaName();
            long timeStamp = -1L;
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            PName tenantId = this.connection.getTenantId();
            PTable theTable = null;
            if (updateCacheImmediately || this.connection.getAutoCommit()) {
                result = this.client.updateCache(schemaName, tableName);
                timeStamp = result.getMutationTime();
                theTable = result.getTable();
                if (theTable == null) {
                    throw new TableNotFoundException(schemaName, tableName, timeStamp);
                }
            } else {
                block11: {
                    try {
                        theTable = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
                    }
                    catch (TableNotFoundException e1) {
                        if (tenantId == null) break block11;
                        try {
                            theTable = this.connection.getMetaDataCache().getTable(new PTableKey(null, fullTableName));
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (theTable == null && (result = this.client.updateCache(schemaName, tableName)).wasUpdated()) {
                    timeStamp = result.getMutationTime();
                    theTable = result.getTable();
                }
                if (theTable == null) {
                    throw new TableNotFoundException(schemaName, tableName, timeStamp);
                }
            }
            List<ColumnDef> dynamicColumns = tableNode.getDynamicColumns();
            theTable = this.addDynamicColumns(dynamicColumns, theTable);
            if (timeStamp != -1L) {
                timeStamp += (long)this.tsAddition;
            }
            TableRef tableRef = new TableRef(tableNode.getAlias(), theTable, timeStamp, !dynamicColumns.isEmpty());
            if (logger.isDebugEnabled() && timeStamp != -1L) {
                logger.debug(LogUtil.addCustomAnnotations("Re-resolved stale table " + fullTableName + " with seqNum " + tableRef.getTable().getSequenceNumber() + " at timestamp " + tableRef.getTable().getTimeStamp() + " with " + tableRef.getTable().getColumns().size() + " columns: " + tableRef.getTable().getColumns(), this.connection));
            }
            return tableRef;
        }

        @Override
        public List<PFunction> getFunctions() {
            return this.functions;
        }

        private List<PFunction> createFunctionRef(List<String> functionNames, boolean updateCacheImmediately) throws SQLException {
            long timeStamp = -1L;
            int numFunctions = functionNames.size();
            List<PFunction> functionsFound = new ArrayList<PFunction>(functionNames.size());
            if (updateCacheImmediately || this.connection.getAutoCommit()) {
                this.getFunctionFromCache(functionNames, functionsFound, true);
                if (functionNames.isEmpty()) {
                    return functionsFound;
                }
                MetaDataProtocol.MetaDataMutationResult result = this.client.updateCache(functionNames);
                timeStamp = result.getMutationTime();
                functionsFound = result.getFunctions();
                if (functionNames.size() != functionsFound.size()) {
                    throw new FunctionNotFoundException("Some of the functions in " + functionNames.toString() + " are not found");
                }
            } else {
                this.getFunctionFromCache(functionNames, functionsFound, false);
                MetaDataProtocol.MetaDataMutationResult result = null;
                if (!functionNames.isEmpty()) {
                    result = this.client.updateCache(functionNames);
                }
                if (result != null) {
                    if (!result.getFunctions().isEmpty()) {
                        functionsFound.addAll(result.getFunctions());
                    }
                    if (result.wasUpdated()) {
                        timeStamp = result.getMutationTime();
                    }
                }
                if (functionsFound.size() != numFunctions) {
                    throw new FunctionNotFoundException("Some of the functions in " + functionNames.toString() + " are not found", timeStamp);
                }
            }
            if (timeStamp != -1L) {
                timeStamp += (long)this.tsAddition;
            }
            if (logger.isDebugEnabled() && timeStamp != -1L) {
                logger.debug(LogUtil.addCustomAnnotations("Re-resolved stale function " + functionNames.toString() + "at timestamp " + timeStamp, this.connection));
            }
            return functionsFound;
        }

        private void getFunctionFromCache(List<String> functionNames, List<PFunction> functionsFound, boolean getOnlyTemporyFunctions) {
            Iterator<String> iterator = functionNames.iterator();
            while (iterator.hasNext()) {
                PFunction function;
                block6: {
                    function = null;
                    String functionName = iterator.next();
                    try {
                        function = this.connection.getMetaDataCache().getFunction(new PTableKey(this.connection.getTenantId(), functionName));
                    }
                    catch (FunctionNotFoundException e1) {
                        if (this.connection.getTenantId() == null) break block6;
                        try {
                            function = this.connection.getMetaDataCache().getFunction(new PTableKey(null, functionName));
                        }
                        catch (FunctionNotFoundException functionNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (function == null) continue;
                if (getOnlyTemporyFunctions) {
                    if (!function.isTemporaryFunction()) continue;
                    functionsFound.add(function);
                    iterator.remove();
                    continue;
                }
                functionsFound.add(function);
                iterator.remove();
            }
        }

        protected PTable addDynamicColumns(List<ColumnDef> dynColumns, PTable theTable) throws SQLException {
            if (!dynColumns.isEmpty()) {
                ArrayList<PColumn> allcolumns = new ArrayList<PColumn>();
                List<PColumn> existingColumns = theTable.getColumns();
                allcolumns.addAll(theTable.getBucketNum() == null ? existingColumns : existingColumns.subList(1, existingColumns.size()));
                int position = existingColumns.size();
                PName defaultFamilyName = PNameFactory.newName(SchemaUtil.getEmptyColumnFamily(theTable));
                for (ColumnDef dynColumn : dynColumns) {
                    PName familyName = defaultFamilyName;
                    PName name = PNameFactory.newName(dynColumn.getColumnDefName().getColumnName());
                    String family = dynColumn.getColumnDefName().getFamilyName();
                    if (family != null) {
                        theTable.getColumnFamily(family);
                        familyName = PNameFactory.newName(family);
                    }
                    allcolumns.add(new PColumnImpl(name, familyName, dynColumn.getDataType(), dynColumn.getMaxLength(), dynColumn.getScale(), dynColumn.isNull(), position, dynColumn.getSortOrder(), dynColumn.getArraySize(), null, false, dynColumn.getExpression(), false));
                    ++position;
                }
                theTable = PTableImpl.makePTable(theTable, allcolumns);
            }
            return theTable;
        }

        @Override
        public PFunction resolveFunction(String functionName) throws SQLException {
            PFunction function = this.functionMap.get(functionName);
            if (function == null) {
                throw new FunctionNotFoundException(functionName);
            }
            return function;
        }

        @Override
        public boolean hasUDFs() {
            return !this.functions.isEmpty();
        }
    }

    private static class SingleTableColumnResolver
    extends BaseColumnResolver {
        private final List<TableRef> tableRefs;
        private final String alias;

        public SingleTableColumnResolver(PhoenixConnection connection, NamedTableNode table, long timeStamp, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            super(connection, 0, false, udfParseNodes);
            ArrayList<PColumnFamily> families = Lists.newArrayListWithExpectedSize(table.getDynamicColumns().size());
            for (ColumnDef def : table.getDynamicColumns()) {
                if (def.getColumnDefName().getFamilyName() == null) continue;
                families.add(new PColumnFamilyImpl(PNameFactory.newName(def.getColumnDefName().getFamilyName()), Collections.emptyList()));
            }
            Long scn = connection.getSCN();
            PTable theTable = new PTableImpl(connection.getTenantId(), table.getName().getSchemaName(), table.getName().getTableName(), scn == null ? Long.MAX_VALUE : scn, families);
            theTable = this.addDynamicColumns(table.getDynamicColumns(), theTable);
            this.alias = null;
            this.tableRefs = ImmutableList.of(new TableRef(this.alias, theTable, timeStamp, !table.getDynamicColumns().isEmpty()));
        }

        public SingleTableColumnResolver(PhoenixConnection connection, NamedTableNode tableNode, boolean updateCacheImmediately) throws SQLException {
            this(connection, tableNode, updateCacheImmediately, 0, new HashMap<String, UDFParseNode>(1));
        }

        public SingleTableColumnResolver(PhoenixConnection connection, NamedTableNode tableNode, boolean updateCacheImmediately, int tsAddition, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            super(connection, tsAddition, updateCacheImmediately, udfParseNodes);
            this.alias = tableNode.getAlias();
            TableRef tableRef = this.createTableRef(tableNode, updateCacheImmediately);
            this.tableRefs = ImmutableList.of(tableRef);
        }

        public SingleTableColumnResolver(PhoenixConnection connection, TableRef tableRef) {
            super(connection, 0);
            this.alias = tableRef.getTableAlias();
            this.tableRefs = ImmutableList.of(tableRef);
        }

        public SingleTableColumnResolver(PhoenixConnection connection, TableRef tableRef, Map<String, UDFParseNode> udfParseNodes) throws SQLException {
            super(connection, 0, false, udfParseNodes);
            this.alias = tableRef.getTableAlias();
            this.tableRefs = ImmutableList.of(tableRef);
        }

        public SingleTableColumnResolver(TableRef tableRef) throws SQLException {
            super(null, 0);
            this.alias = tableRef.getTableAlias();
            this.tableRefs = ImmutableList.of(tableRef);
        }

        @Override
        public List<TableRef> getTables() {
            return this.tableRefs;
        }

        @Override
        public List<PFunction> getFunctions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            TableRef tableRef = this.tableRefs.get(0);
            if (schemaName != null || tableName != null) {
                String resolvedTableName = tableRef.getTable().getTableName().getString();
                String resolvedSchemaName = tableRef.getTable().getSchemaName().getString();
                if (!(schemaName == null || tableName == null || schemaName.equals(resolvedSchemaName) && tableName.equals(resolvedTableName) || schemaName.equals(this.alias))) {
                    throw new TableNotFoundException(schemaName, tableName);
                }
            }
            return tableRef;
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            TableRef tableRef = this.tableRefs.get(0);
            boolean resolveCF = false;
            if (schemaName != null || tableName != null) {
                String resolvedTableName = tableRef.getTable().getTableName().getString();
                String resolvedSchemaName = tableRef.getTable().getSchemaName().getString();
                if (schemaName != null && tableName != null) {
                    if (!(schemaName.equals(resolvedSchemaName) && tableName.equals(resolvedTableName) || (resolveCF = schemaName.equals(this.alias)))) {
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName);
                    }
                } else if (!(tableName == null || tableName.equals(this.alias) || tableName.equals(resolvedTableName) && resolvedSchemaName.equals(""))) {
                    resolveCF = true;
                }
            }
            PColumn column = resolveCF ? tableRef.getTable().getColumnFamily(tableName).getColumn(colName) : tableRef.getTable().getColumn(colName);
            return new ColumnRef(tableRef, column.getPosition());
        }
    }
}

