/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;

@InterfaceStability.Unstable
public class RMAuthenticationFilterInitializer
extends FilterInitializer {
    String configPrefix = "hadoop.http.authentication.";
    String signatureSecretFileProperty = "signature.secret.file";
    String kerberosPrincipalProperty = "kerberos.principal";
    String cookiePath = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> createFilterConfig(Configuration conf) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", this.cookiePath);
        for (Map.Entry<String, String> entry : conf) {
            String name;
            String value;
            String propName = entry.getKey();
            if (propName.startsWith(this.configPrefix)) {
                value = conf.get(propName);
                name = propName.substring(this.configPrefix.length());
                filterConfig.put(name, value);
                continue;
            }
            if (!propName.startsWith("hadoop.proxyuser")) continue;
            value = conf.get(propName);
            name = propName.substring("hadoop.".length());
            filterConfig.put(name, value);
        }
        String signatureSecretFile = (String)filterConfig.get(this.signatureSecretFileProperty);
        if (signatureSecretFile != null) {
            InputStreamReader reader = null;
            try {
                StringBuilder secret = new StringBuilder();
                reader = new InputStreamReader((InputStream)new FileInputStream(signatureSecretFile), "UTF-8");
                int c = ((Reader)reader).read();
                while (c > -1) {
                    secret.append((char)c);
                    c = ((Reader)reader).read();
                }
                filterConfig.put("signature.secret", secret.toString());
                IOUtils.closeQuietly(reader);
            }
            catch (IOException ex) {
                if (UserGroupInformation.isSecurityEnabled()) {
                    throw new RuntimeException("Could not read HTTP signature secret file: " + signatureSecretFile);
                }
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get(this.kerberosPrincipalProperty);
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal(principal, bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        filterConfig.put("delegation-token.token-kind", RMDelegationTokenIdentifier.KIND_NAME.toString());
        return filterConfig;
    }

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        container.addFilter("RMAuthenticationFilter", RMAuthenticationFilter.class.getName(), filterConfig);
    }
}

