/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AHSClient;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.ApplicationIdNotProvidedException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnClientImpl
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    protected ApplicationClientProtocol rmClient;
    protected long submitPollIntervalMillis;
    private long asyncApiPollIntervalMillis;
    private long asyncApiPollTimeoutMillis;
    private AHSClient historyClient;
    private boolean historyServiceEnabled;
    protected TimelineClient timelineClient;
    @VisibleForTesting
    Text timelineService;
    @VisibleForTesting
    String timelineDTRenewer;
    protected boolean timelineServiceEnabled;
    private static final String ROOT = "root";

    public YarnClientImpl() {
        super(YarnClientImpl.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.asyncApiPollIntervalMillis = conf.getLong("yarn.client.application-client-protocol.poll-interval-ms", 200L);
        this.asyncApiPollTimeoutMillis = conf.getLong("yarn.client.application-client-protocol.poll-timeout-ms", -1L);
        this.submitPollIntervalMillis = this.asyncApiPollIntervalMillis;
        if (conf.get("yarn.client.app-submission.poll-interval") != null) {
            this.submitPollIntervalMillis = conf.getLong("yarn.client.app-submission.poll-interval", 200L);
        }
        if (conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.historyServiceEnabled = true;
            this.historyClient = AHSClient.createAHSClient();
            this.historyClient.init(conf);
        }
        if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
            this.timelineServiceEnabled = true;
            this.timelineClient = TimelineClient.createTimelineClient();
            this.timelineClient.init(conf);
            this.timelineDTRenewer = YarnClientImpl.getTimelineDelegationTokenRenewer(conf);
            this.timelineService = TimelineUtils.buildTimelineTokenService(conf);
        }
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        try {
            this.rmClient = ClientRMProxy.createRMProxy(this.getConfig(), ApplicationClientProtocol.class);
            if (this.historyServiceEnabled) {
                this.historyClient.start();
            }
            if (this.timelineServiceEnabled) {
                this.timelineClient.start();
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy(this.rmClient);
        }
        if (this.historyServiceEnabled) {
            this.historyClient.stop();
        }
        if (this.timelineServiceEnabled) {
            this.timelineClient.stop();
        }
        super.serviceStop();
    }

    private GetNewApplicationResponse getNewApplication() throws YarnException, IOException {
        GetNewApplicationRequest request = Records.newRecord(GetNewApplicationRequest.class);
        return this.rmClient.getNewApplication(request);
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = Records.newRecord(ApplicationSubmissionContext.class);
        GetNewApplicationResponse newApp = this.getNewApplication();
        ApplicationId appId = newApp.getApplicationId();
        context.setApplicationId(appId);
        return new YarnClientApplication(newApp, context);
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        ApplicationId applicationId = appContext.getApplicationId();
        if (applicationId == null) {
            throw new ApplicationIdNotProvidedException("ApplicationId is not provided in ApplicationSubmissionContext");
        }
        SubmitApplicationRequest request = Records.newRecord(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        if (this.isSecurityEnabled() && this.timelineServiceEnabled) {
            this.addTimelineDelegationToken(appContext.getAMContainerSpec());
        }
        this.rmClient.submitApplication(request);
        int pollCount = 0;
        long startTime = System.currentTimeMillis();
        block4: while (true) {
            try {
                while (true) {
                    YarnApplicationState state;
                    if (!(state = this.getApplicationReport(applicationId).getYarnApplicationState()).equals((Object)YarnApplicationState.NEW) && !state.equals((Object)YarnApplicationState.NEW_SAVING)) {
                        LOG.info("Submitted application " + applicationId);
                        break block4;
                    }
                    long elapsedMillis = System.currentTimeMillis() - startTime;
                    if (this.enforceAsyncAPITimeout() && elapsedMillis >= this.asyncApiPollTimeoutMillis) {
                        throw new YarnException("Timed out while waiting for application " + applicationId + " to be submitted successfully");
                    }
                    if (++pollCount % 10 == 0) {
                        LOG.info("Application submission is not finished, submitted application " + applicationId + " is still in " + (Object)((Object)state));
                    }
                    try {
                        Thread.sleep(this.submitPollIntervalMillis);
                        continue block4;
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Interrupted while waiting for application " + applicationId + " to be successfully submitted.");
                        continue;
                    }
                    break;
                }
            }
            catch (ApplicationNotFoundException ex) {
                LOG.info("Re-submit application " + applicationId + "with the " + "same ApplicationSubmissionContext");
                this.rmClient.submitApplication(request);
                continue;
            }
            break;
        }
        return applicationId;
    }

    private void addTimelineDelegationToken(ContainerLaunchContext clc) throws YarnException, IOException {
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        ByteBuffer tokens = clc.getTokens();
        if (tokens != null) {
            dibb.reset(tokens);
            credentials.readTokenStorageStream(dibb);
            tokens.rewind();
        }
        for (Token<? extends TokenIdentifier> token : credentials.getAllTokens()) {
            if (!token.getKind().equals(TimelineDelegationTokenIdentifier.KIND_NAME)) continue;
            return;
        }
        Token<TimelineDelegationTokenIdentifier> timelineDelegationToken = this.getTimelineDelegationToken();
        if (timelineDelegationToken == null) {
            return;
        }
        credentials.addToken(this.timelineService, timelineDelegationToken);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add timline delegation token into credentials: " + timelineDelegationToken);
        }
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream(dob);
        tokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        clc.setTokens(tokens);
    }

    @VisibleForTesting
    Token<TimelineDelegationTokenIdentifier> getTimelineDelegationToken() throws IOException, YarnException {
        return this.timelineClient.getDelegationToken(this.timelineDTRenewer);
    }

    private static String getTimelineDelegationTokenRenewer(Configuration conf) throws IOException, YarnException {
        String rmPrincipal = conf.get("yarn.resourcemanager.principal");
        String renewer = null;
        if (rmPrincipal != null && rmPrincipal.length() > 0) {
            String rmHost = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
            renewer = SecurityUtil.getServerPrincipal(rmPrincipal, rmHost);
        }
        return renewer;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        KillApplicationRequest request = Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        try {
            int pollCount = 0;
            long startTime = System.currentTimeMillis();
            while (true) {
                KillApplicationResponse response;
                if ((response = this.rmClient.forceKillApplication(request)).getIsKillCompleted()) {
                    LOG.info("Killed application " + applicationId);
                    break;
                }
                long elapsedMillis = System.currentTimeMillis() - startTime;
                if (this.enforceAsyncAPITimeout() && elapsedMillis >= this.asyncApiPollTimeoutMillis) {
                    throw new YarnException("Timed out while waiting for application " + applicationId + " to be killed.");
                }
                if (++pollCount % 10 == 0) {
                    LOG.info("Waiting for application " + applicationId + " to be killed.");
                }
                Thread.sleep(this.asyncApiPollIntervalMillis);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for application " + applicationId + " to be killed.");
        }
    }

    @VisibleForTesting
    boolean enforceAsyncAPITimeout() {
        return this.asyncApiPollTimeoutMillis >= 0L;
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportResponse response = null;
        try {
            GetApplicationReportRequest request = Records.newRecord(GetApplicationReportRequest.class);
            request.setApplicationId(appId);
            response = this.rmClient.getApplicationReport(request);
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (e.getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationReport(appId);
        }
        return response.getApplicationReport();
    }

    @Override
    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        org.apache.hadoop.yarn.api.records.Token token = this.getApplicationReport(appId).getAMRMToken();
        Token amrmToken = null;
        if (token != null) {
            amrmToken = ConverterUtils.convertFromYarn(token, (Text)null);
        }
        return amrmToken;
    }

    @Override
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.getApplications(null, null);
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        return this.getApplications(applicationTypes, null);
    }

    @Override
    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.getApplications(null, applicationStates);
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance(applicationTypes, applicationStates);
        GetApplicationsResponse response = this.rmClient.getApplications(request);
        return response.getApplicationList();
    }

    @Override
    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        GetClusterMetricsRequest request = Records.newRecord(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.rmClient.getClusterMetrics(request);
        return response.getClusterMetrics();
    }

    @Override
    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        EnumSet<NodeState> statesSet = states.length == 0 ? EnumSet.allOf(NodeState.class) : EnumSet.noneOf(NodeState.class);
        for (NodeState state : states) {
            statesSet.add(state);
        }
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(statesSet);
        GetClusterNodesResponse response = this.rmClient.getClusterNodes(request);
        return response.getNodeReports();
    }

    @Override
    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        GetDelegationTokenRequest rmDTRequest = Records.newRecord(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.rmClient.getDelegationToken(rmDTRequest);
        return response.getRMDelegationToken();
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = Records.newRecord(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    @Override
    public QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        Records.newRecord(GetQueueInfoRequest.class);
        return this.rmClient.getQueueInfo(request).getQueueInfo();
    }

    @Override
    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        GetQueueUserAclsInfoRequest request = Records.newRecord(GetQueueUserAclsInfoRequest.class);
        return this.rmClient.getQueueUserAcls(request).getUserAclsInfoList();
    }

    @Override
    public List<QueueInfo> getAllQueues() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return queues;
    }

    @Override
    public List<QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo rootQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return queues;
    }

    @Override
    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        QueueInfo parentQueue = this.rmClient.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return queues;
    }

    private void getChildQueues(QueueInfo parent, List<QueueInfo> queues, boolean recursive) {
        List<QueueInfo> childQueues = parent.getChildQueues();
        for (QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setRMClient(ApplicationClientProtocol rmClient) {
        this.rmClient = rmClient;
    }

    @Override
    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        try {
            GetApplicationAttemptReportRequest request = Records.newRecord(GetApplicationAttemptReportRequest.class);
            request.setApplicationAttemptId(appAttemptId);
            GetApplicationAttemptReportResponse response = this.rmClient.getApplicationAttemptReport(request);
            return response.getApplicationAttemptReport();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (e.getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationAttemptReport(appAttemptId);
        }
    }

    @Override
    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        try {
            GetApplicationAttemptsRequest request = Records.newRecord(GetApplicationAttemptsRequest.class);
            request.setApplicationId(appId);
            GetApplicationAttemptsResponse response = this.rmClient.getApplicationAttempts(request);
            return response.getApplicationAttemptList();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (e.getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getApplicationAttempts(appId);
        }
    }

    @Override
    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        try {
            GetContainerReportRequest request = Records.newRecord(GetContainerReportRequest.class);
            request.setContainerId(containerId);
            GetContainerReportResponse response = this.rmClient.getContainerReport(request);
            return response.getContainerReport();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (e.getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getContainerReport(containerId);
        }
    }

    @Override
    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        try {
            GetContainersRequest request = Records.newRecord(GetContainersRequest.class);
            request.setApplicationAttemptId(applicationAttemptId);
            GetContainersResponse response = this.rmClient.getContainers(request);
            return response.getContainerList();
        }
        catch (YarnException e) {
            if (!this.historyServiceEnabled) {
                throw e;
            }
            if (e.getClass() != ApplicationNotFoundException.class) {
                throw e;
            }
            return this.historyClient.getContainers(applicationAttemptId);
        }
    }

    @Override
    public void moveApplicationAcrossQueues(ApplicationId appId, String queue) throws YarnException, IOException {
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance(appId, queue);
        this.rmClient.moveApplicationAcrossQueues(request);
    }

    @Override
    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        return this.rmClient.submitReservation(request);
    }

    @Override
    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        return this.rmClient.updateReservation(request);
    }

    @Override
    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        return this.rmClient.deleteReservation(request);
    }

    @Override
    public Map<NodeId, Set<String>> getNodeToLabels() throws YarnException, IOException {
        return this.rmClient.getNodeToLabels(GetNodesToLabelsRequest.newInstance()).getNodeToLabels();
    }

    @Override
    public Set<String> getClusterNodeLabels() throws YarnException, IOException {
        return this.rmClient.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance()).getNodeLabels();
    }
}

