/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.htrace.HTraceConfiguration;
import org.htrace.SpanReceiver;
import org.htrace.Trace;

@InterfaceAudience.Private
public class SpanReceiverHost
implements TraceAdminProtocol {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hadoop.trace.spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(SpanReceiverHost.class);
    private final TreeMap<Long, SpanReceiver> receivers = new TreeMap();
    private Configuration config;
    private boolean closed = false;
    private long highestId = 1L;
    private static List<SpanReceiverInfo.ConfigurationPair> EMPTY = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanReceiverHost getInstance(Configuration conf) {
        if (SingletonHolder.INSTANCE.host != null) {
            return SingletonHolder.INSTANCE.host;
        }
        Object object = SingletonHolder.INSTANCE.lock;
        synchronized (object) {
            if (SingletonHolder.INSTANCE.host != null) {
                return SingletonHolder.INSTANCE.host;
            }
            SpanReceiverHost host = new SpanReceiverHost();
            host.loadSpanReceivers(conf);
            SingletonHolder.INSTANCE.host = host;
            ShutdownHookManager.get().addShutdownHook(new Runnable(){

                @Override
                public void run() {
                    SingletonHolder.INSTANCE.host.closeReceivers();
                }
            }, 0);
            return SingletonHolder.INSTANCE.host;
        }
    }

    public synchronized void loadSpanReceivers(Configuration conf) {
        this.config = new Configuration(conf);
        String[] receiverNames = this.config.getTrimmedStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        for (String className : receiverNames) {
            className = className.trim();
            try {
                SpanReceiver rcvr = this.loadInstance(className, EMPTY);
                Trace.addReceiver((SpanReceiver)rcvr);
                this.receivers.put(this.highestId++, rcvr);
                LOG.info("SpanReceiver " + className + " was loaded successfully.");
            }
            catch (IOException e) {
                LOG.error("Failed to load SpanReceiver", e);
            }
        }
    }

    private synchronized SpanReceiver loadInstance(String className, List<SpanReceiverInfo.ConfigurationPair> extraConfig) throws IOException {
        SpanReceiver impl;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(className);
            Object o = ReflectionUtils.newInstance(implClass, this.config);
            impl = (SpanReceiver)o;
            impl.configure(SpanReceiverHost.wrapHadoopConf(this.config, extraConfig));
        }
        catch (ClassCastException e) {
            throw new IOException("Class " + className + " does not implement SpanReceiver.");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class " + className + " cannot be found.");
        }
        catch (SecurityException e) {
            throw new IOException("Got SecurityException while loading SpanReceiver " + className);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Got IllegalArgumentException while loading SpanReceiver " + className, e);
        }
        catch (RuntimeException e) {
            throw new IOException("Got RuntimeException while loading SpanReceiver " + className, e);
        }
        return impl;
    }

    private static HTraceConfiguration wrapHadoopConf(final Configuration conf, List<SpanReceiverInfo.ConfigurationPair> extraConfig) {
        final HashMap<String, String> extraMap = new HashMap<String, String>();
        for (SpanReceiverInfo.ConfigurationPair pair : extraConfig) {
            extraMap.put(pair.getKey(), pair.getValue());
        }
        return new HTraceConfiguration(){
            public static final String HTRACE_CONF_PREFIX = "hadoop.";

            public String get(String key) {
                if (extraMap.containsKey(key)) {
                    return (String)extraMap.get(key);
                }
                return conf.get(HTRACE_CONF_PREFIX + key);
            }

            public String get(String key, String defaultValue) {
                if (extraMap.containsKey(key)) {
                    return (String)extraMap.get(key);
                }
                return conf.get(HTRACE_CONF_PREFIX + key, defaultValue);
            }
        };
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers.values()) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close SpanReceiver correctly: " + e.getMessage(), e);
            }
        }
        this.receivers.clear();
    }

    @Override
    public synchronized SpanReceiverInfo[] listSpanReceivers() throws IOException {
        SpanReceiverInfo[] info = new SpanReceiverInfo[this.receivers.size()];
        int i = 0;
        for (Map.Entry<Long, SpanReceiver> entry : this.receivers.entrySet()) {
            info[i] = new SpanReceiverInfo(entry.getKey(), entry.getValue().getClass().getName());
            ++i;
        }
        return info;
    }

    @Override
    public synchronized long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        StringBuilder configStringBuilder = new StringBuilder();
        String prefix = "";
        for (SpanReceiverInfo.ConfigurationPair pair : info.configPairs) {
            configStringBuilder.append(prefix).append(pair.getKey()).append(" = ").append(pair.getValue());
            prefix = ", ";
        }
        SpanReceiver rcvr = null;
        try {
            rcvr = this.loadInstance(info.getClassName(), info.configPairs);
        }
        catch (IOException e) {
            LOG.info("Failed to add SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.info("Failed to add SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString(), e);
            throw e;
        }
        Trace.addReceiver((SpanReceiver)rcvr);
        long newId = this.highestId++;
        this.receivers.put(newId, rcvr);
        LOG.info("Successfully added SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString());
        return newId;
    }

    @Override
    public synchronized void removeSpanReceiver(long spanReceiverId) throws IOException {
        SpanReceiver rcvr = this.receivers.remove(spanReceiverId);
        if (rcvr == null) {
            throw new IOException("There is no span receiver with id " + spanReceiverId);
        }
        Trace.removeReceiver((SpanReceiver)rcvr);
        rcvr.close();
        LOG.info("Successfully removed SpanReceiver " + spanReceiverId + " with class " + rcvr.getClass().getName());
    }

    private static enum SingletonHolder {
        INSTANCE;

        Object lock = new Object();
        SpanReceiverHost host = null;
    }
}

