/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl.zk;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.impl.zk.CuratorService;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RegistryOperationsService
extends CuratorService
implements RegistryOperations {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryOperationsService.class);
    private final RegistryUtils.ServiceRecordMarshal serviceRecordMarshal = new RegistryUtils.ServiceRecordMarshal();

    public RegistryOperationsService(String name) {
        this(name, null);
    }

    public RegistryOperationsService() {
        this("RegistryOperationsService");
    }

    public RegistryOperationsService(String name, RegistryBindingSource bindingSource) {
        super(name, bindingSource);
    }

    public List<ACL> getClientAcls() {
        return this.getRegistrySecurity().getClientACLs();
    }

    protected void validatePath(String path) throws InvalidPathnameException {
    }

    @Override
    public boolean mknode(String path, boolean createParents) throws IOException {
        this.validatePath(path);
        return this.zkMkPath(path, CreateMode.PERSISTENT, createParents, this.getClientAcls());
    }

    @Override
    public void bind(String path, ServiceRecord record, int flags) throws IOException {
        Preconditions.checkArgument(record != null, "null record");
        this.validatePath(path);
        RegistryTypeUtils.validateServiceRecord(path, record);
        LOG.info("Bound at {} : {}", (Object)path, (Object)record);
        CreateMode mode = CreateMode.PERSISTENT;
        byte[] bytes = this.serviceRecordMarshal.toBytes(record);
        this.zkSet(path, mode, bytes, this.getClientAcls(), (flags & 1) != 0);
    }

    @Override
    public ServiceRecord resolve(String path) throws IOException {
        byte[] bytes = this.zkRead(path);
        ServiceRecord record = (ServiceRecord)this.serviceRecordMarshal.fromBytes(path, bytes, "JSONServiceRecord");
        RegistryTypeUtils.validateServiceRecord(path, record);
        return record;
    }

    @Override
    public boolean exists(String path) throws IOException {
        this.validatePath(path);
        return this.zkPathExists(path);
    }

    @Override
    public RegistryPathStatus stat(String path) throws IOException {
        this.validatePath(path);
        Stat stat = this.zkStat(path);
        String name = RegistryPathUtils.lastPathEntry(path);
        RegistryPathStatus status = new RegistryPathStatus(name, stat.getCtime(), stat.getDataLength(), stat.getNumChildren());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stat {} => {}", (Object)path, (Object)status);
        }
        return status;
    }

    @Override
    public List<String> list(String path) throws IOException {
        this.validatePath(path);
        return this.zkList(path);
    }

    @Override
    public void delete(String path, boolean recursive) throws IOException {
        this.validatePath(path);
        this.zkDelete(path, recursive, null);
    }
}

