/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class JsonSerDeser<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerDeser.class);
    private static final String UTF_8 = "UTF-8";
    public static final String E_NO_DATA = "No data at path";
    public static final String E_DATA_TOO_SHORT = "Data at path too short";
    public static final String E_MISSING_MARKER_STRING = "Missing marker string: ";
    private final Class<T> classType;
    private final ObjectMapper mapper;

    public JsonSerDeser(Class<T> classType) {
        Preconditions.checkArgument(classType != null, "null classType");
        this.classType = classType;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String getName() {
        return this.classType.getSimpleName();
    }

    public synchronized T fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        try {
            return (T)this.mapper.readValue(json, this.classType);
        }
        catch (IOException e) {
            LOG.error("Exception while parsing json : " + e + "\n" + json, e);
            throw e;
        }
    }

    public synchronized T fromFile(File jsonFile) throws IOException, JsonParseException, JsonMappingException {
        try {
            return (T)this.mapper.readValue(jsonFile, this.classType);
        }
        catch (IOException e) {
            LOG.error("Exception while parsing json file {}: {}", jsonFile, (Object)e);
            throw e;
        }
    }

    public synchronized T fromResource(String resource) throws IOException, JsonParseException, JsonMappingException {
        Object object;
        InputStream resStream = null;
        try {
            resStream = this.getClass().getResourceAsStream(resource);
            if (resStream == null) {
                throw new FileNotFoundException(resource);
            }
            object = this.mapper.readValue(resStream, this.classType);
        }
        catch (IOException e) {
            try {
                LOG.error("Exception while parsing json resource {}: {}", (Object)resource, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(resStream);
                throw throwable;
            }
        }
        IOUtils.closeStream(resStream);
        return (T)object;
    }

    public T fromInstance(T instance) throws IOException {
        return this.fromJson(this.toJson(instance));
    }

    public T load(FileSystem fs, Path path) throws IOException, JsonParseException, JsonMappingException {
        FileStatus status = fs.getFileStatus(path);
        long len = status.getLen();
        byte[] b = new byte[(int)len];
        FSDataInputStream dataInputStream = fs.open(path);
        int count = dataInputStream.read(b);
        if ((long)count != len) {
            throw new EOFException(path.toString() + ": read finished prematurely");
        }
        return this.fromBytes(path.toString(), b);
    }

    public void save(FileSystem fs, Path path, T instance, boolean overwrite) throws IOException {
        FSDataOutputStream dataOutputStream = fs.create(path, overwrite);
        this.writeJsonAsBytes(instance, dataOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJsonAsBytes(T instance, DataOutputStream dataOutputStream) throws IOException {
        try {
            byte[] b = this.toBytes(instance);
            dataOutputStream.write(b);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public byte[] toBytes(T instance) throws IOException {
        String json = this.toJson(instance);
        return json.getBytes(UTF_8);
    }

    public T fromBytes(String path, byte[] bytes) throws IOException, InvalidRecordException {
        return this.fromBytes(path, bytes, "");
    }

    public T fromBytes(String path, byte[] bytes, String marker) throws IOException, NoRecordException, InvalidRecordException {
        int len = bytes.length;
        if (len == 0) {
            throw new NoRecordException(path, E_NO_DATA);
        }
        if (StringUtils.isNotEmpty(marker) && len < marker.length()) {
            throw new NoRecordException(path, E_DATA_TOO_SHORT);
        }
        String json = new String(bytes, 0, len, UTF_8);
        if (StringUtils.isNotEmpty(marker) && !json.contains(marker)) {
            throw new NoRecordException(path, E_MISSING_MARKER_STRING + marker);
        }
        try {
            return this.fromJson(json);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRecordException(path, e.toString(), e);
        }
    }

    public synchronized String toJson(T instance) throws IOException, JsonGenerationException, JsonMappingException {
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        return this.mapper.writeValueAsString(instance);
    }

    public String toString(T instance) {
        Preconditions.checkArgument(instance != null, "Null instance argument");
        try {
            return this.toJson(instance);
        }
        catch (IOException e) {
            return "Failed to convert to a string: " + e;
        }
    }
}

