/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class MRClientService
extends AbstractService
implements ClientService {
    static final Log LOG = LogFactory.getLog(MRClientService.class);
    private MRClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private AppContext appContext;

    public MRClientService(AppContext appContext) {
        super(MRClientService.class.getName());
        this.appContext = appContext;
        this.protocolHandler = new MRClientProtocolHandler();
    }

    @Override
    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create(conf);
        InetSocketAddress address = new InetSocketAddress(0);
        this.server = rpc.getServer(MRClientProtocol.class, this.protocolHandler, address, conf, this.appContext.getClientToAMTokenSecretManager(), conf.getInt("yarn.app.mapreduce.am.job.client.thread-count", 1), "yarn.app.mapreduce.am.job.client.port-range");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new MRAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.createSocketAddrForHost(this.appContext.getNMHostname(), this.server.getListenerAddress().getPort());
        LOG.info("Instantiated MRClientService at " + this.bindAddress);
        try {
            this.webApp = WebApps.$for("mapreduce", AppContext.class, this.appContext, "ws").withHttpPolicy(conf, HttpConfig.Policy.HTTP_ONLY).start(new AMWebApp());
        }
        catch (Exception e) {
            LOG.error("Webapps failed to start. Ignoring for now:", e);
        }
        super.serviceStart();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.serviceStop();
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public int getHttpPort() {
        return this.webApp.port();
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    class MRClientProtocolHandler
    implements MRClientProtocol {
        private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        private final Object getTaskReportsLock = new Object();

        MRClientProtocolHandler() {
        }

        @Override
        public InetSocketAddress getConnectAddress() {
            return MRClientService.this.getBindAddress();
        }

        private Job verifyAndGetJob(JobId jobID, JobACL accessType) throws IOException {
            UserGroupInformation ugi;
            Job job = MRClientService.this.appContext.getJob(jobID);
            if (!job.checkAccess(ugi = UserGroupInformation.getCurrentUser(), accessType)) {
                throw new AccessControlException("User " + ugi.getShortUserName() + " cannot perform operation " + accessType.name() + " on " + jobID);
            }
            return job;
        }

        private Task verifyAndGetTask(TaskId taskID, JobACL accessType) throws IOException {
            Task task = this.verifyAndGetJob(taskID.getJobId(), accessType).getTask(taskID);
            if (task == null) {
                throw new IOException("Unknown Task " + taskID);
            }
            return task;
        }

        private TaskAttempt verifyAndGetAttempt(TaskAttemptId attemptID, JobACL accessType) throws IOException {
            TaskAttempt attempt = this.verifyAndGetTask(attemptID.getTaskId(), accessType).getAttempt(attemptID);
            if (attempt == null) {
                throw new IOException("Unknown TaskAttempt " + attemptID);
            }
            return attempt;
        }

        @Override
        public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB);
            GetCountersResponse response = this.recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(TypeConverter.toYarn(job.getAllCounters()));
            return response;
        }

        @Override
        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB);
            GetJobReportResponse response = this.recordFactory.newRecordInstance(GetJobReportResponse.class);
            if (job != null) {
                response.setJobReport(job.getReport());
            } else {
                response.setJobReport(null);
            }
            return response;
        }

        @Override
        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetTaskAttemptReportResponse response = this.recordFactory.newRecordInstance(GetTaskAttemptReportResponse.class);
            response.setTaskAttemptReport(this.verifyAndGetAttempt(taskAttemptId, JobACL.VIEW_JOB).getReport());
            return response;
        }

        @Override
        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws IOException {
            TaskId taskId = request.getTaskId();
            GetTaskReportResponse response = this.recordFactory.newRecordInstance(GetTaskReportResponse.class);
            response.setTaskReport(this.verifyAndGetTask(taskId, JobACL.VIEW_JOB).getReport());
            return response;
        }

        @Override
        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            int fromEventId = request.getFromEventId();
            int maxEvents = request.getMaxEvents();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB);
            GetTaskAttemptCompletionEventsResponse response = this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsResponse.class);
            response.addAllCompletionEvents(Arrays.asList(job.getTaskAttemptCompletionEvents(fromEventId, maxEvents)));
            return response;
        }

        @Override
        public KillJobResponse killJob(KillJobRequest request) throws IOException {
            JobId jobId = request.getJobId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill job " + jobId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info(message);
            this.verifyAndGetJob(jobId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle(new JobDiagnosticsUpdateEvent(jobId, message));
            MRClientService.this.appContext.getEventHandler().handle(new JobEvent(jobId, JobEventType.JOB_KILL));
            KillJobResponse response = this.recordFactory.newRecordInstance(KillJobResponse.class);
            return response;
        }

        @Override
        public KillTaskResponse killTask(KillTaskRequest request) throws IOException {
            TaskId taskId = request.getTaskId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill task " + taskId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info(message);
            this.verifyAndGetTask(taskId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle(new TaskEvent(taskId, TaskEventType.T_KILL));
            KillTaskResponse response = this.recordFactory.newRecordInstance(KillTaskResponse.class);
            return response;
        }

        @Override
        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill task attempt " + taskAttemptId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info(message);
            this.verifyAndGetAttempt(taskAttemptId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle(new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle(new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_KILL));
            KillTaskAttemptResponse response = this.recordFactory.newRecordInstance(KillTaskAttemptResponse.class);
            return response;
        }

        @Override
        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetDiagnosticsResponse response = this.recordFactory.newRecordInstance(GetDiagnosticsResponse.class);
            response.addAllDiagnostics(this.verifyAndGetAttempt(taskAttemptId, JobACL.VIEW_JOB).getDiagnostics());
            return response;
        }

        @Override
        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Fail task attempt " + taskAttemptId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info(message);
            this.verifyAndGetAttempt(taskAttemptId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle(new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle(new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_FAILMSG));
            FailTaskAttemptResponse response = this.recordFactory.newRecordInstance(FailTaskAttemptResponse.class);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            TaskType taskType = request.getTaskType();
            GetTaskReportsResponse response = this.recordFactory.newRecordInstance(GetTaskReportsResponse.class);
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB);
            Collection<Task> tasks = job.getTasks(taskType).values();
            LOG.info("Getting task report for " + (Object)((Object)taskType) + "   " + jobId + ". Report-size will be " + tasks.size());
            Object object = this.getTaskReportsLock;
            synchronized (object) {
                for (Task task : tasks) {
                    response.addTaskReport(task.getReport());
                }
            }
            return response;
        }

        @Override
        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to issue delegation token");
        }

        @Override
        public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to renew delegation token");
        }

        @Override
        public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to cancel delegation token");
        }
    }
}

