/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PartialOutputCommitter;
import org.apache.hadoop.mapreduce.task.annotation.Checkpointable;

@Checkpointable
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class PartialFileOutputCommitter
extends FileOutputCommitter
implements PartialOutputCommitter {
    private static final Log LOG = LogFactory.getLog(PartialFileOutputCommitter.class);

    public PartialFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    public PartialFileOutputCommitter(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
    }

    @Override
    public Path getCommittedTaskPath(int appAttemptId, TaskAttemptContext context) {
        return new Path(this.getJobAttemptPath(appAttemptId), String.valueOf(context.getTaskAttemptID()));
    }

    @VisibleForTesting
    FileSystem fsFor(Path p, Configuration conf) throws IOException {
        return p.getFileSystem(conf);
    }

    @Override
    public void cleanUpPartialOutputForTask(TaskAttemptContext context) throws IOException {
        if (!this.getClass().isAnnotationPresent(Checkpointable.class)) {
            throw new IllegalStateException("Invoking cleanUpPartialOutputForTask() from non @Preemptable class");
        }
        FileSystem fs = this.fsFor(this.getTaskAttemptPath(context), context.getConfiguration());
        LOG.info("cleanUpPartialOutputForTask: removing everything belonging to " + context.getTaskAttemptID().getTaskID() + " in: " + this.getCommittedTaskPath(context).getParent());
        TaskAttemptID taid = context.getTaskAttemptID();
        TaskID tid = taid.getTaskID();
        Path pCommit = this.getCommittedTaskPath(context).getParent();
        for (int i = 0; i < taid.getId(); ++i) {
            TaskAttemptID oldId = new TaskAttemptID(tid, i);
            Path pTask = new Path(pCommit, oldId.toString());
            if (!fs.exists(pTask) || fs.delete(pTask, true)) continue;
            throw new IOException("Failed to delete " + pTask);
        }
    }
}

