/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;

@InterfaceAudience.Private
public class AuthenticationTokenSelector
implements TokenSelector<AuthenticationTokenIdentifier> {
    private static Log LOG = LogFactory.getLog(AuthenticationTokenSelector.class);

    @Override
    public Token<AuthenticationTokenIdentifier> selectToken(Text serviceName, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (serviceName != null) {
            for (Token<? extends TokenIdentifier> ident : tokens) {
                if (!serviceName.equals(ident.getService()) || !AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE.equals(ident.getKind())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning token " + ident);
                }
                return ident;
            }
        }
        LOG.debug("No matching token found");
        return null;
    }
}

