/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;

@InterfaceAudience.Private
public class ReplicationWALReaderManager {
    private static final Log LOG = LogFactory.getLog(ReplicationWALReaderManager.class);
    private final FileSystem fs;
    private final Configuration conf;
    private long position = 0L;
    private WAL.Reader reader;
    private Path lastPath;

    public ReplicationWALReaderManager(FileSystem fs, Configuration conf) {
        this.fs = fs;
        this.conf = conf;
    }

    public WAL.Reader openReader(Path path) throws IOException {
        if (this.reader == null || !this.lastPath.equals(path)) {
            this.closeReader();
            this.reader = WALFactory.createReader(this.fs, path, this.conf);
            this.lastPath = path;
        } else {
            try {
                this.reader.reset();
            }
            catch (NullPointerException npe) {
                throw new IOException("NPE resetting reader, likely HDFS-4380", npe);
            }
        }
        return this.reader;
    }

    public WAL.Entry readNextAndSetPosition() throws IOException {
        WAL.Entry entry = this.reader.next();
        this.position = this.reader.getPosition();
        if (entry != null) {
            entry.setCompressionContext(null);
        }
        return entry;
    }

    public void seek() throws IOException {
        if (this.position != 0L) {
            this.reader.seek(this.position);
        }
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    void finishCurrentFile() {
        this.position = 0L;
        try {
            this.closeReader();
        }
        catch (IOException e) {
            LOG.warn("Unable to close reader", e);
        }
    }
}

