/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationQueuesZKImpl
extends ReplicationStateZKBase
implements ReplicationQueues {
    private String myQueuesZnode;
    private static final String RS_LOCK_ZNODE = "lock";
    private static final Log LOG = LogFactory.getLog(ReplicationQueuesZKImpl.class);

    public ReplicationQueuesZKImpl(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        super(zk, conf, abortable);
    }

    @Override
    public void init(String serverName) throws ReplicationException {
        this.myQueuesZnode = ZKUtil.joinZNode(this.queuesZNode, serverName);
        try {
            ZKUtil.createWithParents(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not initialize replication queues.", e);
        }
    }

    @Override
    public void removeQueue(String queueId) {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, ZKUtil.joinZNode(this.myQueuesZnode, queueId));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to delete queue (queueId=" + queueId + ")", e);
        }
    }

    @Override
    public void addLog(String queueId, String filename) throws ReplicationException {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        znode = ZKUtil.joinZNode(znode, filename);
        try {
            ZKUtil.createWithParents(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not add log because znode could not be created. queueId=" + queueId + ", filename=" + filename);
        }
    }

    @Override
    public void removeLog(String queueId, String filename) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.deleteNode(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to remove wal from queue (queueId=" + queueId + ", filename=" + filename + ")", e);
        }
    }

    @Override
    public void setLogPosition(String queueId, String filename, long position) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.setData(this.zookeeper, znode, ZKUtil.positionToByteArray(position));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to write replication wal position (filename=" + filename + ", position=" + position + ")", e);
        }
    }

    @Override
    public long getLogPosition(String queueId, String filename) throws ReplicationException {
        String clusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        String znode = ZKUtil.joinZNode(clusterZnode, filename);
        byte[] bytes = null;
        try {
            bytes = ZKUtil.getData(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Internal Error: could not get position in log for queueId=" + queueId + ", filename=" + filename, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 0L;
        }
        try {
            return ZKUtil.parseWALPositionFrom(bytes);
        }
        catch (DeserializationException de) {
            LOG.warn("Failed to parse WALPosition for queueId=" + queueId + " and wal=" + filename + "znode content, continuing.");
            return 0L;
        }
    }

    @Override
    public boolean isThisOurZnode(String znode) {
        return ZKUtil.joinZNode(this.queuesZNode, znode).equals(this.myQueuesZnode);
    }

    @Override
    public SortedMap<String, SortedSet<String>> claimQueues(String regionserverZnode) {
        SortedMap<Object, Object> newQueues = new TreeMap();
        if (this.conf.getBoolean("hbase.zookeeper.useMulti", true)) {
            LOG.info("Atomically moving " + regionserverZnode + "'s wals to my queue");
            newQueues = this.copyQueuesFromRSUsingMulti(regionserverZnode);
        } else {
            LOG.info("Moving " + regionserverZnode + "'s wals to my queue");
            if (!this.lockOtherRS(regionserverZnode)) {
                return newQueues;
            }
            newQueues = this.copyQueuesFromRS(regionserverZnode);
            this.deleteAnotherRSQueues(regionserverZnode);
        }
        return newQueues;
    }

    @Override
    public void removeAllQueues() {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.SessionExpiredException) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + this.myQueuesZnode, e);
        }
    }

    @Override
    public List<String> getLogsInQueue(String queueId) {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of wals for queueId=" + queueId, e);
        }
        return result;
    }

    @Override
    public List<String> getAllQueues() {
        List<String> listOfQueues = null;
        try {
            listOfQueues = ZKUtil.listChildrenNoWatch(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get a list of queues for region server: " + this.myQueuesZnode, e);
        }
        return listOfQueues;
    }

    private boolean lockOtherRS(String znode) {
        try {
            String parent = ZKUtil.joinZNode(this.queuesZNode, znode);
            if (parent.equals(this.myQueuesZnode)) {
                LOG.warn("Won't lock because this is us, we're dead!");
                return false;
            }
            String p = ZKUtil.joinZNode(parent, RS_LOCK_ZNODE);
            ZKUtil.createAndWatch(this.zookeeper, p, ReplicationQueuesZKImpl.lockToByteArray(this.myQueuesZnode));
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NodeExistsException) {
                LOG.info("Won't transfer the queue, another RS took care of it because of: " + e.getMessage());
            } else {
                LOG.info("Failed lock other rs", e);
            }
            return false;
        }
        return true;
    }

    private void deleteAnotherRSQueues(String regionserverZnode) {
        String fullpath = ZKUtil.joinZNode(this.queuesZNode, regionserverZnode);
        try {
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, fullpath);
            for (String cluster : clusters) {
                if (cluster.equals(RS_LOCK_ZNODE)) continue;
                String fullClusterPath = ZKUtil.joinZNode(fullpath, cluster);
                ZKUtil.deleteNodeRecursively(this.zookeeper, fullClusterPath);
            }
            ZKUtil.deleteNodeRecursively(this.zookeeper, fullpath);
        }
        catch (KeeperException e) {
            if ((e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NotEmptyException) && e.getPath().equals(fullpath)) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + regionserverZnode, e);
        }
    }

    private SortedMap<String, SortedSet<String>> copyQueuesFromRSUsingMulti(String znode) {
        TreeMap<String, SortedSet<String>> queues = new TreeMap<String, SortedSet<String>>();
        String deadRSZnodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
        List<String> peerIdsToProcess = null;
        ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
        try {
            peerIdsToProcess = ZKUtil.listChildrenNoWatch(this.zookeeper, deadRSZnodePath);
            if (peerIdsToProcess == null) {
                return queues;
            }
            for (String peerId : peerIdsToProcess) {
                ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(peerId);
                if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                    LOG.warn("Peer " + peerId + " didn't exist, skipping the replay");
                    continue;
                }
                String newPeerId = peerId + "-" + znode;
                String newPeerZnode = ZKUtil.joinZNode(this.myQueuesZnode, newPeerId);
                String oldClusterZnode = ZKUtil.joinZNode(deadRSZnodePath, peerId);
                List<String> wals = ZKUtil.listChildrenNoWatch(this.zookeeper, oldClusterZnode);
                if (wals == null || wals.size() == 0) {
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
                    continue;
                }
                TreeSet<String> logQueue = new TreeSet<String>();
                queues.put(newPeerId, logQueue);
                ZKUtil.ZKUtilOp op = ZKUtil.ZKUtilOp.createAndFailSilent(newPeerZnode, HConstants.EMPTY_BYTE_ARRAY);
                listOfOps.add(op);
                for (String wal : wals) {
                    String oldWalZnode = ZKUtil.joinZNode(oldClusterZnode, wal);
                    byte[] logOffset = ZKUtil.getData(this.zookeeper, oldWalZnode);
                    LOG.debug("Creating " + wal + " with data " + Bytes.toString(logOffset));
                    String newLogZnode = ZKUtil.joinZNode(newPeerZnode, wal);
                    listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(newLogZnode, logOffset));
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldWalZnode));
                    logQueue.add(wal);
                }
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
            }
            listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(deadRSZnodePath));
            LOG.debug(" The multi list size is: " + listOfOps.size());
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
            LOG.info("Atomically moved the dead regionserver logs. ");
        }
        catch (KeeperException e) {
            LOG.warn("Got exception in copyQueuesFromRSUsingMulti: ", e);
            queues.clear();
        }
        catch (InterruptedException e) {
            LOG.warn("Got exception in copyQueuesFromRSUsingMulti: ", e);
            queues.clear();
            Thread.currentThread().interrupt();
        }
        return queues;
    }

    private SortedMap<String, SortedSet<String>> copyQueuesFromRS(String znode) {
        TreeMap<String, SortedSet<String>> queues = new TreeMap<String, SortedSet<String>>();
        try {
            String nodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, nodePath);
            if (clusters == null || clusters.size() <= 1) {
                return queues;
            }
            clusters.remove(RS_LOCK_ZNODE);
            for (String cluster : clusters) {
                ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(cluster);
                if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                    LOG.warn("Peer " + cluster + " didn't exist, skipping the replay");
                    continue;
                }
                String newCluster = cluster + "-" + znode;
                String newClusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, newCluster);
                String clusterPath = ZKUtil.joinZNode(nodePath, cluster);
                List<String> wals = ZKUtil.listChildrenNoWatch(this.zookeeper, clusterPath);
                if (wals == null || wals.size() == 0) continue;
                ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, newClusterZnode, HConstants.EMPTY_BYTE_ARRAY);
                TreeSet<String> logQueue = new TreeSet<String>();
                queues.put(newCluster, logQueue);
                for (String wal : wals) {
                    String z = ZKUtil.joinZNode(clusterPath, wal);
                    byte[] positionBytes = ZKUtil.getData(this.zookeeper, z);
                    long position = 0L;
                    try {
                        position = ZKUtil.parseWALPositionFrom(positionBytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn("Failed parse of wal position from the following znode: " + z + ", Exception: " + e);
                    }
                    LOG.debug("Creating " + wal + " with data " + position);
                    String child = ZKUtil.joinZNode(newClusterZnode, wal);
                    ZKUtil.createAndWatch(this.zookeeper, child, positionBytes);
                    logQueue.add(wal);
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Copy queues from rs", e);
        }
        catch (InterruptedException e) {
            LOG.warn(e);
            Thread.currentThread().interrupt();
        }
        return queues;
    }

    static byte[] lockToByteArray(String lockOwner) {
        byte[] bytes = ZooKeeperProtos.ReplicationLock.newBuilder().setLockOwner(lockOwner).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }
}

