/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class SecureWALCellCodec
extends WALCellCodec {
    private Encryptor encryptor;
    private Decryptor decryptor;

    public SecureWALCellCodec(Configuration conf, CompressionContext compression) {
        super(conf, compression);
    }

    public SecureWALCellCodec(Configuration conf, Encryptor encryptor) {
        super(conf, null);
        this.encryptor = encryptor;
    }

    public SecureWALCellCodec(Configuration conf, Decryptor decryptor) {
        super(conf, null);
        this.decryptor = decryptor;
    }

    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new EncryptedKvDecoder(is, this.decryptor);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new EncryptedKvEncoder(os, this.encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Encryptor encryptor) {
        return new SecureWALCellCodec(conf, encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Decryptor decryptor) {
        return new SecureWALCellCodec(conf, decryptor);
    }

    static class EncryptedKvEncoder
    extends KeyValueCodec.KeyValueEncoder {
        private Encryptor encryptor;
        private final ThreadLocal<byte[]> iv = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                byte[] iv = new byte[EncryptedKvEncoder.this.encryptor.getIvLength()];
                new SecureRandom().nextBytes(iv);
                return iv;
            }
        };

        protected byte[] nextIv() {
            byte[] b = this.iv.get();
            byte[] ret = new byte[b.length];
            System.arraycopy(b, 0, ret, 0, b.length);
            return ret;
        }

        protected void incrementIv(int v) {
            Encryption.incrementIv(this.iv.get(), 1 + v / this.encryptor.getBlockSize());
        }

        public EncryptedKvEncoder(OutputStream os) {
            super(os);
        }

        public EncryptedKvEncoder(OutputStream os, Encryptor encryptor) {
            super(os);
            this.encryptor = encryptor;
        }

        @Override
        public void write(Cell cell) throws IOException {
            if (this.encryptor == null) {
                super.write(cell);
                return;
            }
            byte[] iv = this.nextIv();
            this.encryptor.setIv(iv);
            this.encryptor.reset();
            StreamUtils.writeRawVInt32(this.out, iv.length);
            this.out.write(iv);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream cout = this.encryptor.createEncryptionStream(baos);
            int tlen = cell.getTagsLength();
            StreamUtils.writeRawVInt32(cout, KeyValueUtil.keyLength(cell));
            StreamUtils.writeRawVInt32(cout, cell.getValueLength());
            StreamUtils.writeRawVInt32(cout, tlen);
            StreamUtils.writeRawVInt32(cout, cell.getRowLength());
            cout.write(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
            StreamUtils.writeRawVInt32(cout, cell.getFamilyLength());
            cout.write(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            StreamUtils.writeRawVInt32(cout, cell.getQualifierLength());
            cout.write(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            StreamUtils.writeLong(cout, cell.getTimestamp());
            cout.write(cell.getTypeByte());
            cout.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            if (tlen > 0) {
                cout.write(cell.getTagsArray(), cell.getTagsOffset(), tlen);
            }
            cout.close();
            StreamUtils.writeRawVInt32(this.out, baos.size());
            baos.writeTo(this.out);
            this.incrementIv(baos.size());
        }
    }

    static class EncryptedKvDecoder
    extends KeyValueCodec.KeyValueDecoder {
        private Decryptor decryptor;
        private byte[] iv;

        public EncryptedKvDecoder(InputStream in) {
            super(in);
        }

        public EncryptedKvDecoder(InputStream in, Decryptor decryptor) {
            super(in);
            this.decryptor = decryptor;
            if (decryptor != null) {
                this.iv = new byte[decryptor.getIvLength()];
            }
        }

        @Override
        protected Cell parseCell() throws IOException {
            if (this.decryptor == null) {
                return super.parseCell();
            }
            int ivLength = 0;
            try {
                ivLength = StreamUtils.readRawVarint32(this.in);
            }
            catch (EOFException e) {
                return null;
            }
            if (ivLength != this.iv.length) {
                throw new IOException("Incorrect IV length: expected=" + this.iv.length + " have=" + ivLength);
            }
            IOUtils.readFully(this.in, this.iv);
            int codedLength = StreamUtils.readRawVarint32(this.in);
            byte[] codedBytes = new byte[codedLength];
            IOUtils.readFully(this.in, codedBytes);
            this.decryptor.setIv(this.iv);
            this.decryptor.reset();
            InputStream cin = this.decryptor.createDecryptionStream(new ByteArrayInputStream(codedBytes));
            int keylength = StreamUtils.readRawVarint32(cin);
            int vlength = StreamUtils.readRawVarint32(cin);
            int tagsLength = StreamUtils.readRawVarint32(cin);
            int length = 0;
            length = tagsLength == 0 ? 8 + keylength + vlength : 10 + keylength + vlength + tagsLength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt(backingArray, pos, keylength);
            pos = Bytes.putInt(backingArray, pos, vlength);
            int elemLen = StreamUtils.readRawVarint32(cin);
            pos = Bytes.putShort(backingArray, pos, (short)elemLen);
            IOUtils.readFully(cin, backingArray, pos, elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32(cin);
            pos = Bytes.putByte(backingArray, pos, (byte)elemLen);
            IOUtils.readFully(cin, backingArray, pos, elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32(cin);
            IOUtils.readFully(cin, backingArray, pos, elemLen);
            IOUtils.readFully(cin, backingArray, pos += elemLen, length - pos);
            return new KeyValue(backingArray, 0, length);
        }
    }
}

