/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ConfigUtil;

@InterfaceAudience.Private
public class OpenRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(OpenRegionHandler.class);
    protected final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final HTableDescriptor htd;
    private OpenRegionCoordination coordination;
    private OpenRegionCoordination.OpenRegionDetails ord;
    private final boolean useZKForAssignment;

    public OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, HTableDescriptor htd, OpenRegionCoordination coordination, OpenRegionCoordination.OpenRegionDetails ord) {
        this(server, rsServices, regionInfo, htd, EventType.M_RS_OPEN_REGION, coordination, ord);
    }

    protected OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, HTableDescriptor htd, EventType eventType, OpenRegionCoordination coordination, OpenRegionCoordination.OpenRegionDetails ord) {
        super(server, eventType);
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.htd = htd;
        this.coordination = coordination;
        this.ord = ord;
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(server.getConfiguration());
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        HRegion region;
        String regionName;
        boolean openSuccessful;
        block61: {
            boolean transitionedToOpening;
            block59: {
                block60: {
                    block57: {
                        block58: {
                            block55: {
                                block56: {
                                    block53: {
                                        block54: {
                                            String encodedName;
                                            block51: {
                                                block52: {
                                                    block49: {
                                                        block50: {
                                                            block47: {
                                                                block48: {
                                                                    openSuccessful = false;
                                                                    transitionedToOpening = false;
                                                                    regionName = this.regionInfo.getRegionNameAsString();
                                                                    region = null;
                                                                    try {
                                                                        if (!this.server.isStopped() && !this.rsServices.isStopping()) break block47;
                                                                        if (openSuccessful) break block48;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (!openSuccessful) {
                                                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                                                        }
                                                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                                        if (openSuccessful) {
                                                                            if (current == null) {
                                                                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                                            } else if (Boolean.FALSE.equals(current)) {
                                                                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                                                                this.cleanupFailedOpen(region);
                                                                            }
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                                                }
                                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                                if (openSuccessful) {
                                                                    if (current == null) {
                                                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                                    } else if (Boolean.FALSE.equals(current)) {
                                                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                                                        this.cleanupFailedOpen(region);
                                                                    }
                                                                }
                                                                return;
                                                            }
                                                            encodedName = this.regionInfo.getEncodedName();
                                                            if (this.rsServices.getFromOnlineRegions(encodedName) == null) break block49;
                                                            LOG.error("Region " + encodedName + " was already online when we started processing the opening. " + "Marking this new attempt as failed");
                                                            if (openSuccessful) break block50;
                                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                                        }
                                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                        if (openSuccessful) {
                                                            if (current == null) {
                                                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                            } else if (Boolean.FALSE.equals(current)) {
                                                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                                                this.cleanupFailedOpen(region);
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    if (this.isRegionStillOpening()) break block51;
                                                    LOG.error("Region " + encodedName + " opening cancelled");
                                                    if (openSuccessful) break block52;
                                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                                }
                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                if (openSuccessful) {
                                                    if (current == null) {
                                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                                    } else if (Boolean.FALSE.equals(current)) {
                                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                                        this.cleanupFailedOpen(region);
                                                    }
                                                }
                                                return;
                                            }
                                            if (!this.useZKForAssignment || this.coordination.transitionFromOfflineToOpening(this.regionInfo, this.ord)) break block53;
                                            LOG.warn("Region was hijacked? Opening cancelled for encodedName=" + encodedName);
                                            if (openSuccessful) break block54;
                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                        }
                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                        if (openSuccessful) {
                                            if (current == null) {
                                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                            } else if (Boolean.FALSE.equals(current)) {
                                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                                this.cleanupFailedOpen(region);
                                            }
                                        }
                                        return;
                                    }
                                    transitionedToOpening = true;
                                    region = this.openRegion();
                                    if (region != null) break block55;
                                    if (openSuccessful) break block56;
                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                                }
                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                if (openSuccessful) {
                                    if (current == null) {
                                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                                    } else if (Boolean.FALSE.equals(current)) {
                                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                        this.cleanupFailedOpen(region);
                                    }
                                }
                                return;
                            }
                            boolean failed = true;
                            if (this.isRegionStillOpening() && (!this.useZKForAssignment || this.coordination.tickleOpening(this.ord, this.regionInfo, this.rsServices, "post_region_open")) && this.updateMeta(region)) {
                                failed = false;
                            }
                            if (!failed && !this.server.isStopped() && !this.rsServices.isStopping()) break block57;
                            if (openSuccessful) break block58;
                            this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                        }
                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                        if (openSuccessful) {
                            if (current == null) {
                                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                            } else if (Boolean.FALSE.equals(current)) {
                                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                                this.cleanupFailedOpen(region);
                            }
                        }
                        return;
                    }
                    if (this.isRegionStillOpening() && (!this.useZKForAssignment || this.coordination.transitionToOpened(region, this.ord))) break block59;
                    if (openSuccessful) break block60;
                    this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
                }
                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                if (openSuccessful) {
                    if (current == null) {
                        LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
                    } else if (Boolean.FALSE.equals(current)) {
                        LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                        this.cleanupFailedOpen(region);
                    }
                }
                return;
            }
            this.rsServices.addToOnlineRegions(region);
            openSuccessful = true;
            LOG.debug("Opened " + regionName + " on " + this.server.getServerName());
            if (openSuccessful) break block61;
            this.doCleanUpOnFailedOpen(region, transitionedToOpening, this.ord);
        }
        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        if (openSuccessful) {
            if (current == null) {
                LOG.error("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName);
            } else if (Boolean.FALSE.equals(current)) {
                LOG.error("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened. Closing it now");
                this.cleanupFailedOpen(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanUpOnFailedOpen(HRegion region, boolean transitionedToOpening, OpenRegionCoordination.OpenRegionDetails ord) throws IOException {
        block9: {
            block8: {
                block7: {
                    if (!transitionedToOpening) break block8;
                    try {
                        if (region != null) {
                            this.cleanupFailedOpen(region);
                        }
                        if (this.useZKForAssignment) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!this.useZKForAssignment) {
                            this.rsServices.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, this.regionInfo);
                        } else {
                            this.coordination.tryTransitionFromOpeningToFailedOpen(this.regionInfo, ord);
                        }
                        throw throwable;
                    }
                    this.rsServices.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, this.regionInfo);
                    break block9;
                }
                this.coordination.tryTransitionFromOpeningToFailedOpen(this.regionInfo, ord);
                break block9;
            }
            if (!this.useZKForAssignment) {
                this.rsServices.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, this.regionInfo);
            } else {
                this.coordination.tryTransitionFromOfflineToFailedOpen(this.rsServices, this.regionInfo, ord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMeta(HRegion r) {
        long now;
        if (this.server.isStopped() || this.rsServices.isStopping()) {
            return false;
        }
        AtomicBoolean signaller = new AtomicBoolean(false);
        PostOpenDeployTasksThread t = new PostOpenDeployTasksThread(r, this.server, this.rsServices, signaller);
        t.start();
        long lastUpdate = now = System.currentTimeMillis();
        boolean tickleOpening = true;
        while (!signaller.get() && t.isAlive() && !this.server.isStopped() && !this.rsServices.isStopping() && this.isRegionStillOpening()) {
            long elapsed = now - lastUpdate;
            if (elapsed > 120000L) {
                lastUpdate = now;
                if (this.useZKForAssignment) {
                    tickleOpening = this.coordination.tickleOpening(this.ord, this.regionInfo, this.rsServices, "post_open_deploy");
                }
            }
            AtomicBoolean atomicBoolean = signaller;
            synchronized (atomicBoolean) {
                try {
                    if (!signaller.get()) {
                        signaller.wait(10000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        if (t.isAlive()) {
            if (!signaller.get()) {
                LOG.debug("Interrupting thread " + t);
                t.interrupt();
            }
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted joining " + r.getRegionInfo().getRegionNameAsString(), ie);
                Thread.currentThread().interrupt();
            }
        }
        return !Thread.interrupted() && t.getException() == null && tickleOpening;
    }

    HRegion openRegion() {
        HRegion region;
        block2: {
            region = null;
            try {
                region = HRegion.openHRegion(this.regionInfo, this.htd, this.rsServices.getWAL(this.regionInfo), this.server.getConfiguration(), this.rsServices, new CancelableProgressable(){

                    @Override
                    public boolean progress() {
                        if (OpenRegionHandler.this.useZKForAssignment) {
                            return OpenRegionHandler.this.coordination.tickleOpening(OpenRegionHandler.this.ord, OpenRegionHandler.this.regionInfo, OpenRegionHandler.this.rsServices, "open_region_progress");
                        }
                        if (!OpenRegionHandler.this.isRegionStillOpening()) {
                            LOG.warn("Open region aborted since it isn't opening any more");
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (Throwable t) {
                RegionServerAccounting rsAccounting;
                LOG.error("Failed open of region=" + this.regionInfo.getRegionNameAsString() + ", starting to roll back the global memstore size.", t);
                if (this.rsServices == null || (rsAccounting = this.rsServices.getRegionServerAccounting()) == null) break block2;
                rsAccounting.rollbackRegionReplayEditsSize(this.regionInfo.getRegionName());
            }
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupFailedOpen(HRegion region) throws IOException {
        if (region != null) {
            byte[] encodedName = this.regionInfo.getEncodedNameAsBytes();
            try {
                this.rsServices.getRegionsInTransitionInRS().put(encodedName, Boolean.FALSE);
                this.rsServices.removeFromOnlineRegions(region, null);
                region.close();
            }
            finally {
                this.rsServices.getRegionsInTransitionInRS().remove(encodedName);
            }
        }
    }

    private static boolean isRegionStillOpening(HRegionInfo regionInfo, RegionServerServices rsServices) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        Boolean action = (Boolean)rsServices.getRegionsInTransitionInRS().get(encodedName);
        return Boolean.TRUE.equals(action);
    }

    private boolean isRegionStillOpening() {
        return OpenRegionHandler.isRegionStillOpening(this.regionInfo, this.rsServices);
    }

    static class PostOpenDeployTasksThread
    extends Thread {
        private Throwable exception = null;
        private final Server server;
        private final RegionServerServices services;
        private final HRegion region;
        private final AtomicBoolean signaller;

        PostOpenDeployTasksThread(HRegion region, Server server, RegionServerServices services, AtomicBoolean signaller) {
            super("PostOpenDeployTasks:" + region.getRegionInfo().getEncodedName());
            this.setDaemon(true);
            this.server = server;
            this.services = services;
            this.region = region;
            this.signaller = signaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.services.postOpenDeployTasks(this.region);
            }
            catch (Throwable e) {
                String msg = "Exception running postOpenDeployTasks; region=" + this.region.getRegionInfo().getEncodedName();
                this.exception = e;
                if (e instanceof IOException && OpenRegionHandler.isRegionStillOpening(this.region.getRegionInfo(), this.services)) {
                    this.server.abort(msg, e);
                }
                LOG.warn(msg, e);
            }
            this.signaller.set(true);
            AtomicBoolean atomicBoolean = this.signaller;
            synchronized (atomicBoolean) {
                this.signaller.notify();
            }
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

