/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;

@InterfaceAudience.Private
public class CompactionConfiguration {
    static final Log LOG = LogFactory.getLog(CompactionConfiguration.class);
    public static final String HBASE_HSTORE_COMPACTION_RATIO_KEY = "hbase.hstore.compaction.ratio";
    public static final String HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY = "hbase.hstore.compaction.ratio.offpeak";
    public static final String HBASE_HSTORE_COMPACTION_MIN_KEY = "hbase.hstore.compaction.min";
    public static final String HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY = "hbase.hstore.compaction.min.size";
    public static final String HBASE_HSTORE_COMPACTION_MAX_KEY = "hbase.hstore.compaction.max";
    public static final String HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY = "hbase.hstore.compaction.max.size";
    public static final String HBASE_HSTORE_OFFPEAK_END_HOUR = "hbase.offpeak.end.hour";
    public static final String HBASE_HSTORE_OFFPEAK_START_HOUR = "hbase.offpeak.start.hour";
    public static final String HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT = "hbase.hstore.min.locality.to.skip.major.compact";
    Configuration conf;
    StoreConfigInformation storeConfigInfo;
    private final double offPeakCompactionRatio;
    private final long maxCompactSize;
    private final long minCompactSize;
    private final int minFilesToCompact;
    private final int maxFilesToCompact;
    private final double compactionRatio;
    private final long throttlePoint;
    private final long majorCompactionPeriod;
    private final float majorCompactionJitter;
    private final float minLocalityToForceCompact;

    CompactionConfiguration(Configuration conf, StoreConfigInformation storeConfigInfo) {
        this.conf = conf;
        this.storeConfigInfo = storeConfigInfo;
        this.maxCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY, Long.MAX_VALUE);
        this.minCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY, storeConfigInfo.getMemstoreFlushSize());
        this.minFilesToCompact = Math.max(2, conf.getInt(HBASE_HSTORE_COMPACTION_MIN_KEY, conf.getInt("hbase.hstore.compactionThreshold", 3)));
        this.maxFilesToCompact = conf.getInt(HBASE_HSTORE_COMPACTION_MAX_KEY, 10);
        this.compactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_KEY, 1.2f);
        this.offPeakCompactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY, 5.0f);
        this.throttlePoint = conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.maxFilesToCompact) * storeConfigInfo.getMemstoreFlushSize());
        this.majorCompactionPeriod = conf.getLong("hbase.hregion.majorcompaction", 604800000L);
        this.majorCompactionJitter = conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.5f);
        this.minLocalityToForceCompact = conf.getFloat(HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT, 0.0f);
        LOG.info(this);
    }

    public String toString() {
        return String.format("size [%d, %d); files [%d, %d); ratio %f; off-peak ratio %f; throttle point %d; major period %d, major jitter %f, min locality to compact %f", this.minCompactSize, this.maxCompactSize, this.minFilesToCompact, this.maxFilesToCompact, this.compactionRatio, this.offPeakCompactionRatio, this.throttlePoint, this.majorCompactionPeriod, Float.valueOf(this.majorCompactionJitter), Float.valueOf(this.minLocalityToForceCompact));
    }

    public long getMinCompactSize() {
        return this.minCompactSize;
    }

    public long getMaxCompactSize() {
        return this.maxCompactSize;
    }

    public int getMinFilesToCompact() {
        return this.minFilesToCompact;
    }

    public int getMaxFilesToCompact() {
        return this.maxFilesToCompact;
    }

    public double getCompactionRatio() {
        return this.compactionRatio;
    }

    public double getCompactionRatioOffPeak() {
        return this.offPeakCompactionRatio;
    }

    public long getThrottlePoint() {
        return this.throttlePoint;
    }

    public long getMajorCompactionPeriod() {
        return this.majorCompactionPeriod;
    }

    public float getMajorCompactionJitter() {
        return this.majorCompactionJitter;
    }

    public float getMinLocalityToForceCompact() {
        return this.minLocalityToForceCompact;
    }
}

