/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALSplitter;

@InterfaceAudience.Private
public class SplitLogWorker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SplitLogWorker.class);
    Thread worker;
    private SplitLogWorkerCoordination coordination;
    private Configuration conf;
    private RegionServerServices server;

    public SplitLogWorker(Server hserver, Configuration conf, RegionServerServices server, TaskExecutor splitTaskExecutor) {
        this.server = server;
        this.conf = conf;
        this.coordination = ((BaseCoordinatedStateManager)hserver.getCoordinatedStateManager()).getSplitLogWorkerCoordination();
        this.server = server;
        this.coordination.init(server, conf, splitTaskExecutor, this);
    }

    public SplitLogWorker(Server hserver, final Configuration conf, final RegionServerServices server, final LastSequenceId sequenceIdChecker, final WALFactory factory) {
        this(server, conf, server, new TaskExecutor(){

            @Override
            public TaskExecutor.Status exec(String filename, ZooKeeperProtos.SplitLogTask.RecoveryMode mode, CancelableProgressable p) {
                FileSystem fs;
                Path rootdir;
                try {
                    rootdir = FSUtils.getRootDir(conf);
                    fs = rootdir.getFileSystem(conf);
                }
                catch (IOException e) {
                    LOG.warn("could not find root dir or fs", e);
                    return TaskExecutor.Status.RESIGNED;
                }
                try {
                    if (!WALSplitter.splitLogFile(rootdir, fs.getFileStatus(new Path(rootdir, filename)), fs, conf, p, sequenceIdChecker, server.getCoordinatedStateManager(), mode, factory)) {
                        return TaskExecutor.Status.PREEMPTED;
                    }
                }
                catch (InterruptedIOException iioe) {
                    LOG.warn("log splitting of " + filename + " interrupted, resigning", iioe);
                    return TaskExecutor.Status.RESIGNED;
                }
                catch (IOException e) {
                    Throwable cause = e.getCause();
                    if (e instanceof RetriesExhaustedException && (cause instanceof NotServingRegionException || cause instanceof ConnectException || cause instanceof SocketTimeoutException)) {
                        LOG.warn("log replaying of " + filename + " can't connect to the target regionserver, " + "resigning", e);
                        return TaskExecutor.Status.RESIGNED;
                    }
                    if (cause instanceof InterruptedException) {
                        LOG.warn("log splitting of " + filename + " interrupted, resigning", e);
                        return TaskExecutor.Status.RESIGNED;
                    }
                    LOG.warn("log splitting of " + filename + " failed, returning error", e);
                    return TaskExecutor.Status.ERR;
                }
                return TaskExecutor.Status.DONE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info("SplitLogWorker " + this.server.getServerName() + " starting");
            this.coordination.registerListener();
            boolean res = false;
            while (!res && !this.coordination.isStop()) {
                res = this.coordination.isReady();
            }
            if (!this.coordination.isStop()) {
                this.coordination.taskLoop();
            }
        }
        catch (Throwable t) {
            if (ExceptionUtil.isInterrupt(t)) {
                LOG.info("SplitLogWorker interrupted. Exiting. " + (this.coordination.isStop() ? "" : " (ERROR: exitWorker is not set, exiting anyway)"));
            } else {
                LOG.error("unexpected error ", t);
            }
        }
        finally {
            this.coordination.removeListener();
            LOG.info("SplitLogWorker " + this.server.getServerName() + " exiting");
        }
    }

    public void stopTask() {
        LOG.info("Sending interrupt to stop the worker thread");
        this.worker.interrupt();
    }

    public void start() {
        this.worker = new Thread(null, this, "SplitLogWorker-" + this.server.getServerName().toShortString());
        this.worker.start();
    }

    public void stop() {
        this.coordination.stopProcessingTasks();
        this.stopTask();
    }

    @VisibleForTesting
    public int getTaskReadySeq() {
        return this.coordination.getTaskReadySeq();
    }

    public static interface TaskExecutor {
        public Status exec(String var1, ZooKeeperProtos.SplitLogTask.RecoveryMode var2, CancelableProgressable var3);

        public static enum Status {
            DONE,
            ERR,
            RESIGNED,
            PREEMPTED;

        }
    }
}

