/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaUtil
extends QuotaTableUtil {
    private static final Log LOG = LogFactory.getLog(QuotaUtil.class);
    public static final String QUOTA_CONF_KEY = "hbase.quota.enabled";
    private static final boolean QUOTA_ENABLED_DEFAULT = false;
    public static final HTableDescriptor QUOTA_TABLE_DESC = new HTableDescriptor(QUOTA_TABLE_NAME);

    public static boolean isQuotaEnabled(Configuration conf) {
        return conf.getBoolean(QUOTA_CONF_KEY, false);
    }

    public static void addTableQuota(Connection connection, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getTableRowKey(table), data);
    }

    public static void deleteTableQuota(Connection connection, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getTableRowKey(table));
    }

    public static void addNamespaceQuota(Connection connection, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getNamespaceRowKey(namespace), data);
    }

    public static void deleteNamespaceQuota(Connection connection, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getNamespaceRowKey(namespace));
    }

    public static void addUserQuota(Connection connection, String user, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), data);
    }

    public static void addUserQuota(Connection connection, String user, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserTable(table), data);
    }

    public static void addUserQuota(Connection connection, String user, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserNamespace(namespace), data);
    }

    public static void deleteUserQuota(Connection connection, String user) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user));
    }

    public static void deleteUserQuota(Connection connection, String user, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserTable(table));
    }

    public static void deleteUserQuota(Connection connection, String user, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(connection, QuotaUtil.getUserRowKey(user), QuotaUtil.getSettingsQualifierForUserNamespace(namespace));
    }

    private static void addQuotas(Connection connection, byte[] rowKey, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(connection, rowKey, QUOTA_QUALIFIER_SETTINGS, data);
    }

    private static void addQuotas(Connection connection, byte[] rowKey, byte[] qualifier, QuotaProtos.Quotas data) throws IOException {
        Put put = new Put(rowKey);
        put.addColumn(QUOTA_FAMILY_INFO, qualifier, QuotaUtil.quotasToData(data));
        QuotaUtil.doPut(connection, put);
    }

    private static void deleteQuotas(Connection connection, byte[] rowKey) throws IOException {
        QuotaUtil.deleteQuotas(connection, rowKey, null);
    }

    private static void deleteQuotas(Connection connection, byte[] rowKey, byte[] qualifier) throws IOException {
        Delete delete = new Delete(rowKey);
        if (qualifier != null) {
            delete.addColumns(QUOTA_FAMILY_INFO, qualifier);
        }
        QuotaUtil.doDelete(connection, delete);
    }

    public static Map<String, UserQuotaState> fetchUserQuotas(Connection connection, List<Get> gets) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet(connection, gets);
        HashMap<String, UserQuotaState> userQuotas = new HashMap<String, UserQuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] key = gets.get(i).getRow();
            assert (QuotaUtil.isUserRowKey(key));
            String user = QuotaUtil.getUserFromRowKey(key);
            final UserQuotaState quotaInfo = new UserQuotaState(nowTs);
            userQuotas.put(user, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals(key, results[i].getRow()));
            try {
                QuotaUtil.parseUserResult(user, results[i], new QuotaTableUtil.UserQuotasVisitor(){

                    @Override
                    public void visitUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(namespace, quotas);
                    }

                    @Override
                    public void visitUserQuotas(String userName, TableName table, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(table, quotas);
                    }

                    @Override
                    public void visitUserQuotas(String userName, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(quotas);
                    }
                });
                continue;
            }
            catch (IOException e) {
                LOG.error("Unable to parse user '" + user + "' quotas", e);
                userQuotas.remove(user);
            }
        }
        return userQuotas;
    }

    public static Map<TableName, QuotaState> fetchTableQuotas(Connection connection, List<Get> gets) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("table", connection, gets, new KeyFromRow<TableName>(){

            @Override
            public TableName getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isTableRowKey(row));
                return QuotaTableUtil.getTableFromRowKey(row);
            }
        });
    }

    public static Map<String, QuotaState> fetchNamespaceQuotas(Connection connection, List<Get> gets) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("namespace", connection, gets, new KeyFromRow<String>(){

            @Override
            public String getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isNamespaceRowKey(row));
                return QuotaTableUtil.getNamespaceFromRowKey(row);
            }
        });
    }

    public static <K> Map<K, QuotaState> fetchGlobalQuotas(String type, Connection connection, List<Get> gets, KeyFromRow<K> kfr) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet(connection, gets);
        HashMap<K, QuotaState> globalQuotas = new HashMap<K, QuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] row = gets.get(i).getRow();
            K key = kfr.getKeyFromRow(row);
            QuotaState quotaInfo = new QuotaState(nowTs);
            globalQuotas.put(key, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals(row, results[i].getRow()));
            byte[] data = results[i].getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
            if (data == null) continue;
            try {
                QuotaProtos.Quotas quotas = QuotaUtil.quotasFromData(data);
                quotaInfo.setQuotas(quotas);
                continue;
            }
            catch (IOException e) {
                LOG.error("Unable to parse " + type + " '" + key + "' quotas", e);
                globalQuotas.remove(key);
            }
        }
        return globalQuotas;
    }

    private static void doPut(Connection connection, Put put) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            table.put(put);
        }
    }

    private static void doDelete(Connection connection, Delete delete) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            table.delete(delete);
        }
    }

    public static long calculateMutationSize(Mutation mutation) {
        long size = 0L;
        for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                size += (long)KeyValueUtil.length(cell);
            }
        }
        return size;
    }

    public static long calculateResultSize(Result result) {
        long size = 0L;
        for (Cell cell : result.rawCells()) {
            size += (long)KeyValueUtil.length(cell);
        }
        return size;
    }

    public static long calculateResultSize(List<Result> results) {
        long size = 0L;
        for (Result result : results) {
            for (Cell cell : result.rawCells()) {
                size += (long)KeyValueUtil.length(cell);
            }
        }
        return size;
    }

    static {
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_INFO).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_USAGE).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
    }

    private static interface KeyFromRow<T> {
        public T getKeyFromRow(byte[] var1);
    }
}

