/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureWALFile
implements Comparable<ProcedureWALFile> {
    private static final Log LOG = LogFactory.getLog(ProcedureWALFile.class);
    private ProcedureProtos.ProcedureWALHeader header;
    private FSDataInputStream stream;
    private FileStatus logStatus;
    private FileSystem fs;
    private Path logFile;
    private long startPos;

    public ProcedureWALFile(FileSystem fs, FileStatus logStatus) {
        this.fs = fs;
        this.logStatus = logStatus;
        this.logFile = logStatus.getPath();
    }

    public ProcedureWALFile(FileSystem fs, Path logFile, ProcedureProtos.ProcedureWALHeader header, long startPos) {
        this.fs = fs;
        this.logFile = logFile;
        this.header = header;
        this.startPos = startPos;
    }

    public void open() throws IOException {
        if (this.stream == null) {
            this.stream = this.fs.open(this.logFile);
        }
        if (this.header == null) {
            this.header = ProcedureWALFormat.readHeader(this.stream);
            this.startPos = this.stream.getPos();
        } else {
            this.stream.seek(this.startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcedureProtos.ProcedureWALTrailer readTrailer() throws IOException {
        try {
            ProcedureProtos.ProcedureWALTrailer procedureWALTrailer = ProcedureWALFormat.readTrailer(this.stream, this.startPos, this.logStatus.getLen());
            return procedureWALTrailer;
        }
        finally {
            this.stream.seek(this.startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTracker(ProcedureStoreTracker tracker) throws IOException {
        ProcedureProtos.ProcedureWALTrailer trailer = this.readTrailer();
        try {
            this.stream.seek(trailer.getTrackerPos());
            tracker.readFrom(this.stream);
        }
        finally {
            this.stream.seek(this.startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.stream == null) {
            return;
        }
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOG.warn("unable to close the wal file: " + this.logFile, e);
        }
        finally {
            this.stream = null;
        }
    }

    public FSDataInputStream getStream() {
        return this.stream;
    }

    public ProcedureProtos.ProcedureWALHeader getHeader() {
        return this.header;
    }

    public boolean isCompacted() {
        return this.header.getType() == 1;
    }

    public long getLogId() {
        return this.header.getLogId();
    }

    public long getSize() {
        return this.logStatus.getLen();
    }

    public void removeFile() throws IOException {
        this.close();
        this.fs.delete(this.logFile, false);
    }

    @Override
    public int compareTo(ProcedureWALFile other) {
        long diff = this.header.getLogId() - other.header.getLogId();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcedureWALFile)) {
            return false;
        }
        return this.compareTo((ProcedureWALFile)o) == 0;
    }

    public int hashCode() {
        return this.logFile.hashCode();
    }

    public String toString() {
        return this.logFile.toString();
    }
}

