/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class TimeToLiveLogCleaner
extends BaseLogCleanerDelegate {
    static final Log LOG = LogFactory.getLog(TimeToLiveLogCleaner.class.getName());
    private long ttl;
    private boolean stopped = false;

    @Override
    public boolean isLogDeletable(FileStatus fStat) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        long time = fStat.getModificationTime();
        long life = currentTime - time;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Log life:" + life + ", ttl:" + this.ttl + ", current:" + currentTime + ", from: " + time);
        }
        if (life < 0L) {
            LOG.warn("Found a log (" + fStat.getPath() + ") newer than current time (" + currentTime + " < " + time + "), probably a clock skew");
            return false;
        }
        return life > this.ttl;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.ttl = conf.getLong("hbase.master.logcleaner.ttl", 600000L);
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

