/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.SecureBulkLoadClient;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(LoadIncrementalHFiles.class);
    private Admin hbAdmin;
    public static final String NAME = "completebulkload";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    private static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    private int maxFilesPerRegionPerFamily;
    private boolean assignSeqIds;
    private FileSystem fs;
    private FsDelegationToken fsDelegationToken;
    private String bulkToken;
    private UserProvider userProvider;

    private LoadIncrementalHFiles() {
    }

    public LoadIncrementalHFiles(Configuration conf) throws Exception {
        super(conf);
        this.initialize();
    }

    private void initialize() throws Exception {
        if (this.hbAdmin == null) {
            this.setConf(HBaseConfiguration.create(this.getConf()));
            Configuration conf = this.getConf();
            conf.setFloat("hfile.block.cache.size", 0.0f);
            this.hbAdmin = new HBaseAdmin(conf);
            this.userProvider = UserProvider.instantiate(conf);
            this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
            this.assignSeqIds = conf.getBoolean(ASSIGN_SEQ_IDS, true);
            this.maxFilesPerRegionPerFamily = conf.getInt(MAX_FILES_PER_REGION_PER_FAMILY, 32);
        }
    }

    private void usage() {
        System.err.println("usage: completebulkload /path/to/hfileoutputformat-output tablename\n -Dcreate.table=no - can be used to avoid creation of table by this tool\n  Note: if you set this to 'no', then the target table must already exist in HBase\n\n");
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor) throws IOException {
        if (!fs.exists(bulkDir)) {
            throw new FileNotFoundException("Bulkload dir " + bulkDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(bulkDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + bulkDir);
        }
        for (FileStatus familyStat : familyDirStatuses) {
            FileStatus[] hfileStatuses;
            if (!familyStat.isDirectory()) {
                LOG.warn("Skipping non-directory " + familyStat.getPath());
                continue;
            }
            Path familyDir = familyStat.getPath();
            byte[] familyName = familyDir.getName().getBytes();
            TFamily family = visitor.bulkFamily(familyName);
            for (FileStatus hfileStatus : hfileStatuses = fs.listStatus(familyDir)) {
                block11: {
                    if (!fs.isFile(hfileStatus.getPath())) {
                        LOG.warn("Skipping non-file " + hfileStatus);
                        continue;
                    }
                    Path hfile = hfileStatus.getPath();
                    String fileName = hfile.getName();
                    if (fileName.startsWith("_")) continue;
                    if (StoreFileInfo.isReference(fileName)) {
                        LOG.warn("Skipping reference " + fileName);
                        continue;
                    }
                    if (HFileLink.isHFileLink(fileName)) {
                        LOG.warn("Skipping HFileLink " + fileName);
                        continue;
                    }
                    try {
                        if (!HFile.isHFileFormat(fs, hfile)) {
                            LOG.warn("the file " + hfile + " doesn't seems to be an hfile. skipping");
                        }
                        break block11;
                    }
                    catch (FileNotFoundException e) {
                        LOG.warn("the file " + hfile + " was removed");
                    }
                    continue;
                }
                visitor.bulkHFile(family, hfileStatus);
            }
        }
    }

    private void discoverLoadQueue(final Deque<LoadQueueItem> ret, Path hfofDir) throws IOException {
        this.fs = hfofDir.getFileSystem(this.getConf());
        LoadIncrementalHFiles.visitBulkHFiles(this.fs, hfofDir, new BulkHFileVisitor<byte[]>(){

            @Override
            public byte[] bulkFamily(byte[] familyName) {
                return familyName;
            }

            @Override
            public void bulkHFile(byte[] family, FileStatus hfile) throws IOException {
                long length = hfile.getLen();
                if (length > LoadIncrementalHFiles.this.getConf().getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                    LOG.warn("Trying to bulk load hfile " + hfile.getPath() + " with size: " + length + " bytes can be problematic as it may lead to oversplitting.");
                }
                ret.add(new LoadQueueItem(family, hfile.getPath()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Path hfofDir, HTable table) throws TableNotFoundException, IOException {
        try (Admin admin = null;){
            try {
                admin = table.getConnection().getAdmin();
            }
            catch (NeedUnmanagedConnectionException ex) {
                admin = new HBaseAdmin(table.getConfiguration());
            }
            this.doBulkLoad(hfofDir, admin, table, table.getRegionLocator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator) throws TableNotFoundException, IOException {
        LinkedList<LoadQueueItem> queue;
        ThreadPoolExecutor pool;
        block22: {
            int count;
            block20: {
                block21: {
                    if (!admin.isTableAvailable(regionLocator.getName())) {
                        throw new TableNotFoundException("Table " + table.getName() + "is not currently available.");
                    }
                    int nrThreads = this.getConf().getInt("hbase.loadincremental.threads.max", Runtime.getRuntime().availableProcessors());
                    ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
                    builder.setNameFormat("LoadIncrementalHFiles-%1$d");
                    pool = new ThreadPoolExecutor(nrThreads, nrThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), builder.build());
                    pool.allowCoreThreadTimeOut(true);
                    queue = new LinkedList<LoadQueueItem>();
                    this.discoverLoadQueue(queue, hfofDir);
                    Collection<HColumnDescriptor> families = table.getTableDescriptor().getFamilies();
                    ArrayList<String> familyNames = new ArrayList<String>(families.size());
                    for (HColumnDescriptor family : families) {
                        familyNames.add(family.getNameAsString());
                    }
                    ArrayList<String> unmatchedFamilies = new ArrayList<String>();
                    for (LoadQueueItem lqi : queue) {
                        String familyNameInHFile = Bytes.toString(lqi.family);
                        if (familyNames.contains(familyNameInHFile)) continue;
                        unmatchedFamilies.add(familyNameInHFile);
                    }
                    if (unmatchedFamilies.size() > 0) {
                        String msg = "Unmatched family names found: unmatched family names in HFiles to be bulkloaded: " + unmatchedFamilies + "; valid family names of table " + table.getName() + " are: " + familyNames;
                        LOG.error(msg);
                        throw new IOException(msg);
                    }
                    count = 0;
                    if (!queue.isEmpty()) break block20;
                    LOG.warn("Bulk load operation did not find any files to load in directory " + hfofDir.toUri() + ".  Does it contain files in " + "subdirectories that correspond to column family names?");
                    this.fsDelegationToken.releaseDelegationToken();
                    if (this.bulkToken == null) break block21;
                    new SecureBulkLoadClient(table).cleanupBulkLoad(this.bulkToken);
                }
                pool.shutdown();
                if (queue != null && !queue.isEmpty()) {
                    StringBuilder err = new StringBuilder();
                    err.append("-------------------------------------------------\n");
                    err.append("Bulk load aborted with some files not yet loaded:\n");
                    err.append("-------------------------------------------------\n");
                    for (LoadQueueItem q : queue) {
                        err.append("  ").append(q.hfilePath).append('\n');
                    }
                    LOG.error(err);
                }
                return;
            }
            try {
                this.fsDelegationToken.acquireDelegationToken(this.fs);
                if (this.isSecureBulkLoadEndpointAvailable()) {
                    this.bulkToken = new SecureBulkLoadClient(table).prepareBulkLoad(table.getName());
                }
                while (!queue.isEmpty()) {
                    int maxRetries;
                    Pair<byte[][], byte[][]> startEndKeys = regionLocator.getStartEndKeys();
                    if (count != 0) {
                        LOG.info("Split occured while grouping HFiles, retry attempt " + count + " with " + queue.size() + " files remaining to group or split");
                    }
                    if ((maxRetries = this.getConf().getInt("hbase.bulkload.retries.number", 10)) != 0 && count >= maxRetries) {
                        throw new IOException("Retry attempted " + count + " times without completing, bailing out");
                    }
                    ++count;
                    Multimap<ByteBuffer, LoadQueueItem> regionGroups = this.groupOrSplitPhase(table, pool, queue, startEndKeys);
                    if (!this.checkHFilesCountPerRegionPerFamily(regionGroups)) {
                        throw new IOException("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to one family of one region");
                    }
                    this.bulkLoadPhase(table, admin.getConnection(), pool, queue, regionGroups);
                }
                this.fsDelegationToken.releaseDelegationToken();
                if (this.bulkToken == null) break block22;
            }
            catch (Throwable throwable) {
                this.fsDelegationToken.releaseDelegationToken();
                if (this.bulkToken != null) {
                    new SecureBulkLoadClient(table).cleanupBulkLoad(this.bulkToken);
                }
                pool.shutdown();
                if (queue != null && !queue.isEmpty()) {
                    StringBuilder err = new StringBuilder();
                    err.append("-------------------------------------------------\n");
                    err.append("Bulk load aborted with some files not yet loaded:\n");
                    err.append("-------------------------------------------------\n");
                    for (LoadQueueItem q : queue) {
                        err.append("  ").append(q.hfilePath).append('\n');
                    }
                    LOG.error(err);
                }
                throw throwable;
            }
            new SecureBulkLoadClient(table).cleanupBulkLoad(this.bulkToken);
        }
        pool.shutdown();
        if (queue != null && !queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (LoadQueueItem q : queue) {
                err.append("  ").append(q.hfilePath).append('\n');
            }
            LOG.error(err);
        }
        if (queue != null && !queue.isEmpty()) {
            throw new RuntimeException("Bulk load aborted with some files not yet loaded.Please check log for more details.");
        }
    }

    protected void bulkLoadPhase(final Table table, final Connection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups) throws IOException {
        HashSet<Future<List<LoadQueueItem>>> loadingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        for (Map.Entry<ByteBuffer, Collection<LoadQueueItem>> entry : regionGroups.asMap().entrySet()) {
            final byte[] first = entry.getKey().array();
            final Collection<LoadQueueItem> lqis = entry.getValue();
            Callable<List<LoadQueueItem>> call = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> toRetry = LoadIncrementalHFiles.this.tryAtomicRegionLoad(conn, table.getName(), first, (Collection<LoadQueueItem>)lqis);
                    return toRetry;
                }
            };
            loadingFutures.add(pool.submit(call));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error("Unexpected execution exception during bulk load", e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during bulk load", e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, LoadQueueItem> regionGroups) {
        for (Map.Entry<ByteBuffer, Collection<LoadQueueItem>> e : regionGroups.asMap().entrySet()) {
            Collection<LoadQueueItem> lqis = e.getValue();
            HashMap<byte[], MutableInt> filesMap = new HashMap<byte[], MutableInt>();
            for (LoadQueueItem lqi : lqis) {
                MutableInt count = (MutableInt)filesMap.get(lqi.family);
                if (count == null) {
                    count = new MutableInt();
                    filesMap.put(lqi.family, count);
                }
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary(lqi.family) + " of region with start key " + Bytes.toStringBinary(e.getKey()));
                return false;
            }
        }
        return true;
    }

    private Multimap<ByteBuffer, LoadQueueItem> groupOrSplitPhase(final Table table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap<ByteBuffer, LoadQueueItem> regionGroups = Multimaps.synchronizedMultimap(rgs);
        HashSet<Future<List<LoadQueueItem>>> splittingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<List<LoadQueueItem>> callable = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> splits = LoadIncrementalHFiles.this.groupOrSplit(regionGroups, item, table, startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                List splits = (List)future.get();
                if (splits == null) continue;
                queue.addAll(splits);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error("IOException during splitting", e1);
                    throw (IOException)t;
                }
                LOG.error("Unexpected execution exception during splitting", e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during splitting", e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return regionGroups;
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected List<LoadQueueItem> splitStoreFile(LoadQueueItem item, Table table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.hfilePath;
        Path tmpDir = new Path(item.hfilePath.getParent(), "_tmp");
        LOG.info("HFile at " + hfilePath + " no longer fits inside a single " + "region. Splitting...");
        String uniqueName = this.getUniqueName();
        HColumnDescriptor familyDesc = table.getTableDescriptor().getFamily(item.family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf("-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf("-rwxrwxrwx"));
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(item.family, botOut));
        lqis.add(new LoadQueueItem(item.family, topOut));
        LOG.info("Successfully split into new HFiles " + botOut + " and " + topOut);
        return lqis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, Table table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        int indexForCallable;
        byte[] last;
        byte[] first;
        Path hfilePath = item.hfilePath;
        try (HFile.Reader hfr = HFile.createReader(this.fs, hfilePath, new CacheConfig(this.getConf()), this.getConf());){
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        LOG.info("Trying to load hfile=" + hfilePath + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last));
        if (first == null || last == null) {
            assert (first == null && last == null);
            LOG.info("hfile " + hfilePath + " has no entries, skipping");
            return null;
        }
        if (Bytes.compareTo(first, last) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(first) + " > " + Bytes.toStringBinary(last));
        }
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), first, Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        if ((indexForCallable = idx) < 0) {
            throw new IOException("The first region info for table " + table.getName() + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable == startEndKeys.getFirst().length - 1 && !Bytes.equals(startEndKeys.getSecond()[indexForCallable], HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + table.getName() + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable + 1 < startEndKeys.getFirst().length && Bytes.compareTo(startEndKeys.getSecond()[indexForCallable], startEndKeys.getFirst()[indexForCallable + 1]) != 0) {
            throw new IOException("The endkey of one region for table " + table.getName() + " is not equal to the startkey of the next region in hbase:meta." + "Please use hbck tool to fix it first.");
        }
        boolean bl = lastKeyInRange = Bytes.compareTo(last, startEndKeys.getSecond()[idx]) < 0 || Bytes.equals(startEndKeys.getSecond()[idx], HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, startEndKeys.getFirst()[indexForCallable], startEndKeys.getSecond()[indexForCallable]);
            return lqis;
        }
        regionGroups.put(ByteBuffer.wrap(startEndKeys.getFirst()[idx]), item);
        return null;
    }

    @Deprecated
    protected List<LoadQueueItem> tryAtomicRegionLoad(HConnection conn, byte[] tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        return this.tryAtomicRegionLoad((Connection)conn, TableName.valueOf(tableName), first, lqis);
    }

    protected List<LoadQueueItem> tryAtomicRegionLoad(final Connection conn, TableName tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        final ArrayList<Pair<byte[], String>> famPaths = new ArrayList<Pair<byte[], String>>(lqis.size());
        for (LoadQueueItem lqi : lqis) {
            famPaths.add(Pair.newPair(lqi.family, lqi.hfilePath.toString()));
        }
        RegionServerCallable<Boolean> svrCallable = new RegionServerCallable<Boolean>(conn, tableName, first){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(int callTimeout) throws Exception {
                SecureBulkLoadClient secureClient = null;
                boolean success = false;
                try {
                    LOG.debug("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary(this.getRow()) + " with hfile group " + famPaths);
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    if (!LoadIncrementalHFiles.this.isSecureBulkLoadEndpointAvailable()) {
                        success = ProtobufUtil.bulkLoadHFile(this.getStub(), famPaths, regionName, LoadIncrementalHFiles.this.assignSeqIds);
                    } else {
                        try (Table table = conn.getTable(this.getTableName());){
                            secureClient = new SecureBulkLoadClient(table);
                            success = secureClient.bulkLoadHFiles(famPaths, LoadIncrementalHFiles.this.fsDelegationToken.getUserToken(), LoadIncrementalHFiles.this.bulkToken, this.getLocation().getRegionInfo().getStartKey());
                        }
                    }
                    Boolean bl = success;
                    return bl;
                }
                finally {
                    if (secureClient != null && !success) {
                        FileSystem targetFs = FileSystem.get(LoadIncrementalHFiles.this.getConf());
                        if (FSHDFSUtils.isSameHdfs(LoadIncrementalHFiles.this.getConf(), LoadIncrementalHFiles.this.fs, targetFs)) {
                            for (Pair el : famPaths) {
                                Path hfileStagingPath = null;
                                Path hfileOrigPath = new Path((String)el.getSecond());
                                try {
                                    hfileStagingPath = new Path(secureClient.getStagingPath(LoadIncrementalHFiles.this.bulkToken, (byte[])el.getFirst()), hfileOrigPath.getName());
                                    if (targetFs.rename(hfileStagingPath, hfileOrigPath)) {
                                        LOG.debug("Moved back file " + hfileOrigPath + " from " + hfileStagingPath);
                                        continue;
                                    }
                                    if (!targetFs.exists(hfileStagingPath)) continue;
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath);
                                }
                                catch (Exception ex) {
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath, ex);
                                }
                            }
                        }
                    }
                }
            }
        };
        try {
            ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
            Configuration conf = this.getConf();
            boolean success = RpcRetryingCallerFactory.instantiate(conf, null).newCaller().callWithRetries(svrCallable, Integer.MAX_VALUE);
            if (!success) {
                LOG.warn("Attempt to bulk load region containing " + Bytes.toStringBinary(first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried.");
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error("Encountered unrecoverable error from region server, additional details: " + svrCallable.getExceptionMessageAdditionalDetail(), e);
            throw e;
        }
    }

    private boolean isSecureBulkLoadEndpointAvailable() {
        String classes = this.getConf().get("hbase.coprocessor.region.classes", "");
        return classes.contains("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
    }

    static void splitStoreFile(Configuration conf, Path inFile, HColumnDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, HColumnDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HalfStoreFileReader halfReader = null;
        StoreFile.Writer halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, cacheConf, reference, conf);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompression();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).build();
            halfWriter = new StoreFile.WriterBuilder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
            HFileScanner scanner = halfReader.getScanner(false, false, false);
            scanner.seekTo();
            do {
                KeyValue kv = KeyValueUtil.ensureKeyValue(scanner.getKeyValue());
                halfWriter.append(kv);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfWriter != null) {
                halfWriter.close();
            }
            if (halfReader != null) {
                halfReader.close(cacheConf.shouldEvictOnClose());
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        return !HFile.isReservedFileInfoKey(key);
    }

    private boolean doesTableExist(TableName tableName) throws Exception {
        return this.hbAdmin.tableExists(tableName);
    }

    public static byte[][] inferBoundaries(TreeMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][0]);
    }

    private void createTable(TableName tableName, String dirPath) throws Exception {
        Path hfofDir = new Path(dirPath);
        final FileSystem fs = hfofDir.getFileSystem(this.getConf());
        final HTableDescriptor htd = new HTableDescriptor(tableName);
        final TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        LoadIncrementalHFiles.visitBulkHFiles(fs, hfofDir, new BulkHFileVisitor<HColumnDescriptor>(){

            @Override
            public HColumnDescriptor bulkFamily(byte[] familyName) {
                HColumnDescriptor hcd = new HColumnDescriptor(familyName);
                htd.addFamily(hcd);
                return hcd;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bulkHFile(HColumnDescriptor hcd, FileStatus hfileStatus) throws IOException {
                Path hfile = hfileStatus.getPath();
                try (HFile.Reader reader = HFile.createReader(fs, hfile, new CacheConfig(LoadIncrementalHFiles.this.getConf()), LoadIncrementalHFiles.this.getConf());){
                    if (hcd.getCompressionType() != reader.getFileContext().getCompression()) {
                        hcd.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info("Setting compression " + hcd.getCompressionType().name() + " for family " + hcd.toString());
                    }
                    reader.loadFileInfo();
                    byte[] first = reader.getFirstRowKey();
                    byte[] last = reader.getLastRowKey();
                    LOG.info("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last));
                    Integer value = map.containsKey(first) ? (Integer)map.get(first) : 0;
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? (Integer)map.get(last) : 0;
                    map.put(last, value - 1);
                }
            }
        });
        byte[][] keys = LoadIncrementalHFiles.inferBoundaries(map);
        this.hbAdmin.createTable(htd, keys);
        LOG.info("Table " + tableName + " is available!!");
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.usage();
            return -1;
        }
        this.initialize();
        String dirPath = args[0];
        TableName tableName = TableName.valueOf(args[1]);
        boolean tableExists = this.doesTableExist(tableName);
        if (!tableExists) {
            if ("yes".equalsIgnoreCase(this.getConf().get(CREATE_TABLE_CONF_KEY, "yes"))) {
                this.createTable(tableName, dirPath);
            } else {
                String errorMsg = String.format("Table '%s' does not exist.", tableName);
                LOG.error(errorMsg);
                throw new TableNotFoundException(errorMsg);
            }
        }
        Path hfofDir = new Path(dirPath);
        try (Connection connection = ConnectionFactory.createConnection(this.getConf());
             HTable table = (HTable)connection.getTable(tableName);){
            this.doBulkLoad(hfofDir, table);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run(conf, new LoadIncrementalHFiles(), args);
        System.exit(ret);
    }

    static class LoadQueueItem {
        final byte[] family;
        final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString(this.family) + " path:" + this.hfilePath.toString();
        }
    }

    private static interface BulkHFileVisitor<TFamily> {
        public TFamily bulkFamily(byte[] var1) throws IOException;

        public void bulkHFile(TFamily var1, FileStatus var2) throws IOException;
    }
}

