/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CompareFilter
extends FilterBase {
    protected CompareOp compareOp;
    protected ByteArrayComparable comparator;

    public CompareFilter(CompareOp compareOp, ByteArrayComparable comparator) {
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    public CompareOp getOperator() {
        return this.compareOp;
    }

    public ByteArrayComparable getComparator() {
        return this.comparator;
    }

    protected boolean doCompare(CompareOp compareOp, ByteArrayComparable comparator, byte[] data, int offset, int length) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = comparator.compareTo(data, offset, length);
        switch (compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + compareOp.name());
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    public static ArrayList<Object> extractArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 2, "Expected 2 but got: %s", filterArguments.size());
        CompareOp compareOp = ParseFilter.createCompareOp(filterArguments.get(0));
        ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(1)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && compareOp != CompareOp.EQUAL && compareOp != CompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add((Object)compareOp);
        arguments.add(comparator);
        return arguments;
    }

    FilterProtos.CompareFilter convert() {
        FilterProtos.CompareFilter.Builder builder = FilterProtos.CompareFilter.newBuilder();
        HBaseProtos.CompareType compareOp = HBaseProtos.CompareType.valueOf(this.compareOp.name());
        builder.setCompareOp(compareOp);
        if (this.comparator != null) {
            builder.setComparator(ProtobufUtil.toComparator(this.comparator));
        }
        return builder.build();
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompareFilter)) {
            return false;
        }
        CompareFilter other = (CompareFilter)o;
        return this.getOperator().equals((Object)other.getOperator()) && (this.getComparator() == other.getComparator() || this.getComparator().areSerializedFieldsEqual(other.getComparator()));
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.compareOp.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        NO_OP;

    }
}

