/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.ACyclicDFACodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.grammar.v3.ANTLRLexer;
import org.antlr.grammar.v3.ANTLRParser;
import org.antlr.grammar.v3.ActionTranslator;
import org.antlr.grammar.v3.CodeGenTreeWalker;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;
import org.antlr.tool.ToolSTGroupFile;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    public static final int MSCL_DEFAULT = 300;
    public static int MAX_SWITCH_CASE_LABELS = 300;
    public static final int MSA_DEFAULT = 3;
    public static int MIN_SWITCH_ALTS = 3;
    public boolean GENERATE_SWITCHES_WHEN_POSSIBLE = true;
    public static boolean LAUNCH_ST_INSPECTOR = false;
    public static final int MADSI_DEFAULT = 60;
    public static int MAX_ACYCLIC_DFA_STATES_INLINE = 60;
    public static String classpathTemplateRootDirectoryName = "org/antlr/codegen/templates";
    public Grammar grammar;
    protected String language;
    public Target target = null;
    protected STGroup templates;
    protected STGroup baseTemplates;
    protected ST recognizerST;
    protected ST outputFileST;
    protected ST headerFileST;
    protected int uniqueLabelNumber = 1;
    protected Tool tool;
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    protected int lineWidth = 72;
    public ACyclicDFACodeGenerator acyclicDFAGenerator = new ACyclicDFACodeGenerator(this);
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    protected static final String vocabFilePattern = "<tokens:{it|<it.name>=<it.type>\n}><literals:{it|<it.name>=<it.type>\n}>";

    public CodeGenerator(Tool tool, Grammar grammar, String language) {
        this.tool = tool;
        this.grammar = grammar;
        this.language = language;
        this.target = CodeGenerator.loadLanguageTarget(language);
    }

    public static Target loadLanguageTarget(String language) {
        Target target = null;
        String targetName = "org.antlr.codegen." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            target = c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            target = new Target();
        }
        catch (InstantiationException ie) {
            ErrorManager.error(23, (Object)targetName, ie);
        }
        catch (IllegalAccessException cnfe) {
            ErrorManager.error(23, (Object)targetName, cnfe);
        }
        return target;
    }

    public void loadTemplates(String language) {
        String langDir = classpathTemplateRootDirectoryName + "/" + language;
        ToolSTGroupFile coreTemplates = new ToolSTGroupFile(langDir + "/" + language + ".stg");
        this.baseTemplates = coreTemplates;
        String outputOption = (String)this.grammar.getOption("output");
        if (outputOption != null && outputOption.equals("AST")) {
            if (this.debug && this.grammar.type != 1) {
                ToolSTGroupFile astParserTemplates;
                ToolSTGroupFile dbgTemplates = new ToolSTGroupFile(langDir + "/Dbg.stg");
                dbgTemplates.importTemplates((STGroup)coreTemplates);
                this.baseTemplates = dbgTemplates;
                ToolSTGroupFile astTemplates = new ToolSTGroupFile(langDir + "/AST.stg");
                astTemplates.importTemplates((STGroup)dbgTemplates);
                if (this.grammar.type == 3) {
                    astParserTemplates = new ToolSTGroupFile(langDir + "/ASTTreeParser.stg");
                    astParserTemplates.importTemplates((STGroup)astTemplates);
                } else {
                    astParserTemplates = new ToolSTGroupFile(langDir + "/ASTParser.stg");
                    astParserTemplates.importTemplates((STGroup)astTemplates);
                }
                ToolSTGroupFile astDbgTemplates = new ToolSTGroupFile(langDir + "/ASTDbg.stg");
                astDbgTemplates.importTemplates((STGroup)astParserTemplates);
                this.templates = astDbgTemplates;
                ((STGroup)dbgTemplates).iterateAcrossValues = true;
                ((STGroup)astDbgTemplates).iterateAcrossValues = true;
                ((STGroup)astParserTemplates).iterateAcrossValues = true;
            } else {
                ToolSTGroupFile astParserTemplates;
                ToolSTGroupFile astTemplates = new ToolSTGroupFile(langDir + "/AST.stg");
                astTemplates.importTemplates((STGroup)coreTemplates);
                if (this.grammar.type == 3) {
                    astParserTemplates = new ToolSTGroupFile(langDir + "/ASTTreeParser.stg");
                    astParserTemplates.importTemplates((STGroup)astTemplates);
                } else {
                    astParserTemplates = new ToolSTGroupFile(langDir + "/ASTParser.stg");
                    astParserTemplates.importTemplates((STGroup)astTemplates);
                }
                this.templates = astParserTemplates;
                ((STGroup)astTemplates).iterateAcrossValues = true;
                ((STGroup)astParserTemplates).iterateAcrossValues = true;
            }
        } else if (outputOption != null && outputOption.equals("template")) {
            if (this.debug && this.grammar.type != 1) {
                ToolSTGroupFile dbgTemplates = new ToolSTGroupFile(langDir + "/Dbg.stg");
                dbgTemplates.importTemplates((STGroup)coreTemplates);
                this.baseTemplates = dbgTemplates;
                ToolSTGroupFile stTemplates = new ToolSTGroupFile(langDir + "/ST.stg");
                stTemplates.importTemplates((STGroup)dbgTemplates);
                this.templates = stTemplates;
                ((STGroup)dbgTemplates).iterateAcrossValues = true;
            } else {
                ToolSTGroupFile stTemplates = new ToolSTGroupFile(langDir + "/ST.stg");
                stTemplates.importTemplates((STGroup)coreTemplates);
                this.templates = stTemplates;
            }
            this.templates.iterateAcrossValues = true;
        } else if (this.debug && this.grammar.type != 1) {
            ToolSTGroupFile dbgTemplates = new ToolSTGroupFile(langDir + "/Dbg.stg");
            dbgTemplates.importTemplates((STGroup)coreTemplates);
            this.baseTemplates = this.templates = dbgTemplates;
            this.baseTemplates.iterateAcrossValues = true;
        } else {
            this.templates = coreTemplates;
            ((STGroup)coreTemplates).iterateAcrossValues = true;
        }
    }

    public ST genRecognizer() {
        this.loadTemplates(this.language);
        if (this.templates == null) {
            return null;
        }
        if (ErrorManager.doNotAttemptAnalysis()) {
            return null;
        }
        this.target.performGrammarAnalysis(this, this.grammar);
        if (ErrorManager.doNotAttemptCodeGen()) {
            return null;
        }
        DFAOptimizer optimizer = new DFAOptimizer(this.grammar);
        optimizer.optimize();
        this.outputFileST = this.templates.getInstanceOf("outputFile");
        if (this.templates.isDefined("headerFile")) {
            this.headerFileST = this.templates.getInstanceOf("headerFile");
        } else {
            this.headerFileST = new ST(this.templates, "xyz");
            this.headerFileST.add("cyclicDFAs", (Object)null);
        }
        boolean filterMode = this.grammar.getOption("filter") != null && this.grammar.getOption("filter").equals("true");
        boolean canBacktrack = this.grammar.getSyntacticPredicates() != null || this.grammar.composite.getRootGrammar().atLeastOneBacktrackOption || filterMode;
        Map<String, Map<String, Object>> actions = this.grammar.getActions();
        this.verifyActionScopesOkForTarget(actions);
        this.translateActionAttributeReferences(actions);
        ST gateST = this.templates.getInstanceOf("actionGate");
        if (filterMode) {
            gateST = this.templates.getInstanceOf("filteringActionGate");
        }
        this.grammar.setSynPredGateIfNotAlready(gateST);
        this.headerFileST.add("actions", actions);
        this.outputFileST.add("actions", actions);
        this.headerFileST.add("buildTemplate", (Object)this.grammar.buildTemplate());
        this.outputFileST.add("buildTemplate", (Object)this.grammar.buildTemplate());
        this.headerFileST.add("buildAST", (Object)this.grammar.buildAST());
        this.outputFileST.add("buildAST", (Object)this.grammar.buildAST());
        this.outputFileST.add("rewriteMode", (Object)this.grammar.rewriteMode());
        this.headerFileST.add("rewriteMode", (Object)this.grammar.rewriteMode());
        this.outputFileST.add("backtracking", (Object)canBacktrack);
        this.headerFileST.add("backtracking", (Object)canBacktrack);
        String memoize = (String)this.grammar.getOption("memoize");
        this.outputFileST.add("memoize", (Object)(this.grammar.atLeastOneRuleMemoizes || memoize != null && memoize.equals("true") && canBacktrack ? 1 : 0));
        this.headerFileST.add("memoize", (Object)(this.grammar.atLeastOneRuleMemoizes || memoize != null && memoize.equals("true") && canBacktrack ? 1 : 0));
        this.outputFileST.add("trace", (Object)this.trace);
        this.headerFileST.add("trace", (Object)this.trace);
        this.outputFileST.add("profile", (Object)this.profile);
        this.headerFileST.add("profile", (Object)this.profile);
        if (this.grammar.type == 1) {
            this.recognizerST = this.templates.getInstanceOf("lexer");
            this.outputFileST.add("LEXER", (Object)true);
            this.headerFileST.add("LEXER", (Object)true);
            this.recognizerST.add("filterMode", (Object)filterMode);
        } else if (this.grammar.type == 2 || this.grammar.type == 4) {
            this.recognizerST = this.templates.getInstanceOf("parser");
            this.outputFileST.add("PARSER", (Object)true);
            this.headerFileST.add("PARSER", (Object)true);
        } else {
            this.recognizerST = this.templates.getInstanceOf("treeParser");
            this.outputFileST.add("TREE_PARSER", (Object)true);
            this.headerFileST.add("TREE_PARSER", (Object)true);
            this.recognizerST.add("filterMode", (Object)filterMode);
        }
        this.outputFileST.add("recognizer", (Object)this.recognizerST);
        this.headerFileST.add("recognizer", (Object)this.recognizerST);
        this.outputFileST.add("actionScope", (Object)this.grammar.getDefaultActionScope(this.grammar.type));
        this.headerFileST.add("actionScope", (Object)this.grammar.getDefaultActionScope(this.grammar.type));
        String targetAppropriateFileNameString = this.target.getTargetStringLiteralFromString(this.grammar.getFileName());
        this.outputFileST.add("fileName", (Object)targetAppropriateFileNameString);
        this.headerFileST.add("fileName", (Object)targetAppropriateFileNameString);
        this.outputFileST.add("ANTLRVersion", (Object)this.tool.VERSION);
        this.headerFileST.add("ANTLRVersion", (Object)this.tool.VERSION);
        this.outputFileST.add("generatedTimestamp", (Object)Tool.getCurrentTimeStamp());
        this.headerFileST.add("generatedTimestamp", (Object)Tool.getCurrentTimeStamp());
        CodeGenTreeWalker gen = new CodeGenTreeWalker(new CommonTreeNodeStream(this.grammar.getGrammarTree()));
        try {
            gen.grammar_(this.grammar, this.recognizerST, this.outputFileST, this.headerFileST);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        this.genTokenTypeConstants(this.recognizerST);
        this.genTokenTypeConstants(this.outputFileST);
        this.genTokenTypeConstants(this.headerFileST);
        if (this.grammar.type != 1) {
            this.genTokenTypeNames(this.recognizerST);
            this.genTokenTypeNames(this.outputFileST);
            this.genTokenTypeNames(this.headerFileST);
        }
        Set<String> synpredNames = null;
        if (this.grammar.synPredNamesUsedInDFA.size() > 0) {
            synpredNames = this.grammar.synPredNamesUsedInDFA;
        }
        this.outputFileST.add("synpreds", synpredNames);
        this.headerFileST.add("synpreds", synpredNames);
        this.recognizerST.add("grammar", (Object)this.grammar);
        if (ErrorManager.getErrorState().errors > 0) {
            return null;
        }
        if (LAUNCH_ST_INSPECTOR) {
            this.outputFileST.inspect();
            if (this.templates.isDefined("headerFile")) {
                this.headerFileST.inspect();
            }
        }
        try {
            this.target.genRecognizerFile(this.tool, this, this.grammar, this.outputFileST);
            if (this.templates.isDefined("headerFile")) {
                ST extST = this.templates.getInstanceOf("headerFileExtension");
                this.target.genRecognizerHeaderFile(this.tool, this, this.grammar, this.headerFileST, extST.render());
            }
            ST tokenVocabSerialization = this.genTokenVocabOutput();
            String vocabFileName = this.getVocabFileName();
            if (vocabFileName != null) {
                this.write(tokenVocabSerialization, vocabFileName);
            }
        }
        catch (IOException ioe) {
            ErrorManager.error(1, ioe);
        }
        return this.outputFileST;
    }

    protected void verifyActionScopesOkForTarget(Map<String, Map<String, Object>> actions) {
        for (Map.Entry<String, Map<String, Object>> entry : actions.entrySet()) {
            String scope = entry.getKey();
            if (this.target.isValidActionScope(this.grammar.type, scope)) continue;
            Map<String, Object> scopeActions = entry.getValue();
            GrammarAST actionAST = (GrammarAST)scopeActions.values().iterator().next();
            ErrorManager.grammarError(143, this.grammar, actionAST.getToken(), scope, this.grammar.getGrammarTypeString());
        }
    }

    protected void translateActionAttributeReferences(Map<String, Map<String, Object>> actions) {
        for (Map.Entry<String, Map<String, Object>> entry : actions.entrySet()) {
            Map<String, Object> scopeActions = entry.getValue();
            this.translateActionAttributeReferencesForSingleScope(null, scopeActions);
        }
    }

    public void translateActionAttributeReferencesForSingleScope(Rule r, Map<String, Object> scopeActions) {
        String ruleName = null;
        if (r != null) {
            ruleName = r.name;
        }
        for (Map.Entry<String, Object> entry : scopeActions.entrySet()) {
            String name = entry.getKey();
            GrammarAST actionAST = (GrammarAST)entry.getValue();
            List<? extends Object> chunks = this.translateAction(ruleName, actionAST);
            scopeActions.put(name, chunks);
        }
    }

    public void generateLocalFOLLOW(GrammarAST referencedElementNode, String referencedElementName, String enclosingRuleName, int elementIndex) {
        List<Object> tokenTypeList;
        long[] words;
        NFAState followingNFAState = referencedElementNode.followingNFAState;
        LookaheadSet follow = null;
        if (followingNFAState != null) {
            follow = this.grammar.FIRST(followingNFAState);
        }
        if (follow == null) {
            ErrorManager.internalError("no follow state or cannot compute follow");
            follow = new LookaheadSet();
        }
        if (follow.member(-1)) {
            follow.remove(-1);
        }
        if (follow.tokenTypeSet == null) {
            words = new long[1];
            tokenTypeList = new ArrayList();
        } else {
            BitSet bits = BitSet.of(follow.tokenTypeSet);
            words = bits.toPackedArray();
            tokenTypeList = follow.tokenTypeSet.toList();
        }
        String[] wordStrings = new String[words.length];
        for (int j = 0; j < words.length; ++j) {
            long w = words[j];
            wordStrings[j] = this.target.getTarget64BitStringFromValue(w);
        }
        this.recognizerST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", new Object[]{referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex)});
        this.outputFileST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", new Object[]{referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex)});
        this.headerFileST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", new Object[]{referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex)});
    }

    public ST genLookaheadDecision(ST recognizerST, DFA dfa) {
        ST decisionST;
        if (dfa.canInlineDecision()) {
            decisionST = this.acyclicDFAGenerator.genFixedLookaheadDecision(this.getTemplates(), dfa);
        } else {
            dfa.createStateTables(this);
            this.outputFileST.add("cyclicDFAs", (Object)dfa);
            this.headerFileST.add("cyclicDFAs", (Object)dfa);
            decisionST = this.templates.getInstanceOf("dfaDecision");
            String description = dfa.getNFADecisionStartState().getDescription();
            description = this.target.getTargetStringLiteralFromString(description);
            if (description != null) {
                decisionST.add("description", (Object)description);
            }
            decisionST.add("decisionNumber", (Object)Utils.integer(dfa.getDecisionNumber()));
        }
        return decisionST;
    }

    public ST generateSpecialState(DFAState s) {
        ST stateST = this.templates.getInstanceOf("cyclicDFAState");
        stateST.add("needErrorClause", (Object)true);
        stateST.add("semPredState", (Object)s.isResolvedWithPredicates());
        stateST.add("stateNumber", (Object)s.stateNumber);
        stateST.add("decisionNumber", (Object)s.dfa.decisionNumber);
        boolean foundGatedPred = false;
        ST eotST = null;
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            DFAState t;
            SemanticContext preds;
            ST edgeST;
            Transition edge = s.transition(i);
            if (edge.label.getAtom() == -2) {
                edgeST = this.templates.getInstanceOf("eotDFAEdge");
                stateST.remove("needErrorClause");
                eotST = edgeST;
            } else {
                edgeST = this.templates.getInstanceOf("cyclicDFAEdge");
                ST exprST = this.genLabelExpr(this.templates, edge, 1);
                edgeST.add("labelExpr", (Object)exprST);
            }
            edgeST.add("edgeNumber", (Object)Utils.integer(i + 1));
            edgeST.add("targetStateNumber", (Object)Utils.integer(edge.target.stateNumber));
            if (!edge.label.isSemanticPredicate() && (preds = (t = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                foundGatedPred = true;
                ST predST = preds.genExpr(this, this.getTemplates(), t.dfa);
                edgeST.add("predicates", (Object)predST.render());
            }
            if (edge.label.getAtom() == -2) continue;
            stateST.add("edges", (Object)edgeST);
        }
        if (foundGatedPred) {
            stateST.add("semPredState", (Object)foundGatedPred);
        }
        if (eotST != null) {
            stateST.add("edges", eotST);
        }
        return stateST;
    }

    protected ST genLabelExpr(STGroup templates, Transition edge, int k) {
        Label label = edge.label;
        if (label.isSemanticPredicate()) {
            return this.genSemanticPredicateExpr(templates, edge);
        }
        if (label.isSet()) {
            return this.genSetExpr(templates, label.getSet(), k, true);
        }
        ST eST = templates.getInstanceOf("lookaheadTest");
        eST.add("atom", (Object)this.getTokenTypeAsTargetLabel(label.getAtom()));
        eST.add("atomAsInt", (Object)Utils.integer(label.getAtom()));
        eST.add("k", (Object)Utils.integer(k));
        return eST;
    }

    protected ST genSemanticPredicateExpr(STGroup templates, Transition edge) {
        DFA dfa = ((DFAState)edge.target).dfa;
        Label label = edge.label;
        SemanticContext semCtx = label.getSemanticContext();
        return semCtx.genExpr(this, templates, dfa);
    }

    public ST genSetExpr(STGroup templates, IntSet set, int k, boolean partOfDFA) {
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("unable to generate expressions for non IntervalSet objects");
        }
        IntervalSet iset = (IntervalSet)set;
        if (iset.getIntervals() == null || iset.getIntervals().isEmpty()) {
            ST emptyST = new ST(templates, "");
            emptyST.impl.name = "empty-set-expr";
            return emptyST;
        }
        String testSTName = "lookaheadTest";
        String testRangeSTName = "lookaheadRangeTest";
        String testSetSTName = "lookaheadSetTest";
        String varSTName = "lookaheadVarName";
        if (!partOfDFA) {
            testSTName = "isolatedLookaheadTest";
            testRangeSTName = "isolatedLookaheadRangeTest";
            testSetSTName = "isolatedLookaheadSetTest";
            varSTName = "isolatedLookaheadVarName";
        }
        ST setST = templates.getInstanceOf("setTest");
        if (templates.isDefined(testSetSTName)) {
            ST sST = templates.getInstanceOf(testSetSTName);
            Iterator<Interval> iter = iset.getIntervals().iterator();
            int rangeNumber = 1;
            while (iter.hasNext()) {
                Interval I2 = iter.next();
                int b = I2.b;
                int a = I2.a;
                if (b - a < 4) {
                    for (int i = a; i <= b; ++i) {
                        sST.add("values", (Object)this.getTokenTypeAsTargetLabel(i));
                        sST.add("valuesAsInt", (Object)Utils.integer(i));
                    }
                    continue;
                }
                ST eST = templates.getInstanceOf(testRangeSTName);
                eST.add("lower", (Object)this.getTokenTypeAsTargetLabel(a));
                eST.add("lowerAsInt", (Object)Utils.integer(a));
                eST.add("upper", (Object)this.getTokenTypeAsTargetLabel(b));
                eST.add("upperAsInt", (Object)Utils.integer(b));
                eST.add("rangeNumber", (Object)Utils.integer(rangeNumber));
                eST.add("k", (Object)Utils.integer(k));
                setST.add("ranges", (Object)eST);
                ++rangeNumber;
            }
            sST.add("k", (Object)Utils.integer(k));
            setST.add("ranges", (Object)sST);
            return setST;
        }
        Iterator<Interval> iter = iset.getIntervals().iterator();
        int rangeNumber = 1;
        while (iter.hasNext()) {
            ST eST;
            Interval I3 = iter.next();
            int a = I3.a;
            int b = I3.b;
            if (a == b) {
                eST = templates.getInstanceOf(testSTName);
                eST.add("atom", (Object)this.getTokenTypeAsTargetLabel(a));
                eST.add("atomAsInt", (Object)Utils.integer(a));
            } else {
                eST = templates.getInstanceOf(testRangeSTName);
                eST.add("lower", (Object)this.getTokenTypeAsTargetLabel(a));
                eST.add("lowerAsInt", (Object)Utils.integer(a));
                eST.add("upper", (Object)this.getTokenTypeAsTargetLabel(b));
                eST.add("upperAsInt", (Object)Utils.integer(b));
                eST.add("rangeNumber", (Object)Utils.integer(rangeNumber));
            }
            eST.add("k", (Object)Utils.integer(k));
            setST.add("ranges", (Object)eST);
            ++rangeNumber;
        }
        return setST;
    }

    protected void genTokenTypeConstants(ST code) {
        for (String tokenID : this.grammar.getTokenIDs()) {
            int tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType != -1 && tokenType < 4) continue;
            code.addAggr("tokens.{name,type}", new Object[]{tokenID, Utils.integer(tokenType)});
        }
    }

    protected void genTokenTypeNames(ST code) {
        for (int t = 4; t <= this.grammar.getMaxTokenType(); ++t) {
            String tokenName = this.grammar.getTokenDisplayName(t);
            if (tokenName == null) continue;
            tokenName = this.target.getTargetStringLiteralFromString(tokenName, true);
            code.add("tokenNames", (Object)tokenName);
        }
    }

    public String getTokenTypeAsTargetLabel(int ttype) {
        if (this.grammar.type == 1) {
            String name = this.grammar.getTokenDisplayName(ttype);
            return this.target.getTargetCharLiteralFromANTLRCharLiteral(this, name);
        }
        return this.target.getTokenTypeAsTargetLabel(this, ttype);
    }

    protected ST genTokenVocabOutput() {
        int tokenType;
        ST vocabFileST = new ST(vocabFilePattern);
        vocabFileST.add("literals", (Object)null);
        vocabFileST.add("tokens", (Object)null);
        vocabFileST.impl.name = "vocab-file";
        for (String tokenID : this.grammar.getTokenIDs()) {
            tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType < 4) continue;
            vocabFileST.addAggr("tokens.{name,type}", new Object[]{tokenID, Utils.integer(tokenType)});
        }
        for (String literal : this.grammar.getStringLiterals()) {
            tokenType = this.grammar.getTokenType(literal);
            if (tokenType < 4) continue;
            vocabFileST.addAggr("tokens.{name,type}", new Object[]{literal, Utils.integer(tokenType)});
        }
        return vocabFileST;
    }

    public List<? extends Object> translateAction(String ruleName, GrammarAST actionTree) {
        if (actionTree.getType() == 12) {
            return this.translateArgAction(ruleName, actionTree);
        }
        ActionTranslator translator = new ActionTranslator(this, ruleName, actionTree);
        List<Object> chunks = translator.translateToChunks();
        chunks = this.target.postProcessAction(chunks, actionTree.token);
        return chunks;
    }

    public List<ST> translateArgAction(String ruleName, GrammarAST actionTree) {
        String actionText = actionTree.token.getText();
        List<String> args = CodeGenerator.getListOfArgumentsFromAction(actionText, 44);
        ArrayList<ST> translatedArgs = new ArrayList<ST>();
        for (String arg : args) {
            if (arg == null) continue;
            CommonToken actionToken = new CommonToken(4, arg);
            ActionTranslator translator = new ActionTranslator(this, ruleName, actionToken, actionTree.outerAltNum);
            List<Object> chunks = translator.translateToChunks();
            chunks = this.target.postProcessAction(chunks, actionToken);
            ST catST = new ST(this.templates, "<chunks>");
            catST.add("chunks", chunks);
            translatedArgs.add(catST);
        }
        if (translatedArgs.isEmpty()) {
            return null;
        }
        return translatedArgs;
    }

    public static List<String> getListOfArgumentsFromAction(String actionText, int separatorChar) {
        ArrayList<String> args = new ArrayList<String>();
        CodeGenerator.getListOfArgumentsFromAction(actionText, 0, -1, separatorChar, args);
        return args;
    }

    public static int getListOfArgumentsFromAction(String actionText, int start, int targetChar, int separatorChar, List<String> args) {
        String arg;
        int p;
        if (actionText == null) {
            return -1;
        }
        actionText = actionText.replaceAll("//.*\n", "");
        int n = actionText.length();
        int last = p = start;
        block8: while (p < n && actionText.charAt(p) != targetChar) {
            char c = actionText.charAt(p);
            switch (c) {
                case '\'': {
                    ++p;
                    while (p < n && actionText.charAt(p) != '\'') {
                        if (actionText.charAt(p) == '\\' && p + 1 < n && actionText.charAt(p + 1) == '\'') {
                            ++p;
                        }
                        ++p;
                    }
                    ++p;
                    continue block8;
                }
                case '\"': {
                    ++p;
                    while (p < n && actionText.charAt(p) != '\"') {
                        if (actionText.charAt(p) == '\\' && p + 1 < n && actionText.charAt(p + 1) == '\"') {
                            ++p;
                        }
                        ++p;
                    }
                    ++p;
                    continue block8;
                }
                case '(': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 41, separatorChar, args);
                    continue block8;
                }
                case '{': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 125, separatorChar, args);
                    continue block8;
                }
                case '<': {
                    if (actionText.indexOf(62, p + 1) >= p) {
                        p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 62, separatorChar, args);
                        continue block8;
                    }
                    ++p;
                    continue block8;
                }
                case '[': {
                    p = CodeGenerator.getListOfArgumentsFromAction(actionText, p + 1, 93, separatorChar, args);
                    continue block8;
                }
            }
            if (c == separatorChar && targetChar == -1) {
                String arg2 = actionText.substring(last, p);
                args.add(arg2.trim());
                last = p + 1;
            }
            ++p;
        }
        if (targetChar == -1 && p <= n && (arg = actionText.substring(last, p).trim()).length() > 0) {
            args.add(arg.trim());
        }
        return ++p;
    }

    public ST translateTemplateConstructor(String ruleName, int outerAltNum, Token actionToken, String templateActionText) {
        ANTLRLexer lexer = new ANTLRLexer(new ANTLRStringStream(templateActionText));
        lexer.setFileName(this.grammar.getFileName());
        ANTLRParser parser = ANTLRParser.createParser(new CommonTokenStream(lexer));
        parser.setFileName(this.grammar.getFileName());
        ANTLRParser.rewrite_template_return parseResult = null;
        try {
            parseResult = parser.rewrite_template();
        }
        catch (RecognitionException re) {
            ErrorManager.grammarError(146, this.grammar, actionToken, templateActionText);
        }
        catch (Exception tse) {
            ErrorManager.internalError("can't parse template action", tse);
        }
        GrammarAST rewriteTree = parseResult.getTree();
        CodeGenTreeWalker gen = new CodeGenTreeWalker(new CommonTreeNodeStream(rewriteTree));
        gen.init(this.grammar);
        gen.setCurrentRuleName(ruleName);
        gen.setOuterAltNum(outerAltNum);
        ST st = null;
        try {
            st = gen.rewrite_template();
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        return st;
    }

    public void issueInvalidScopeError(String x, String y, Rule enclosingRule, Token actionToken, int outerAltNum) {
        Rule r = this.grammar.getRule(x);
        AttributeScope scope = this.grammar.getGlobalScope(x);
        if (scope == null && r != null) {
            scope = r.ruleScope;
        }
        if (scope == null) {
            ErrorManager.grammarError(140, this.grammar, actionToken, x);
        } else if (scope.getAttribute(y) == null) {
            ErrorManager.grammarError(141, this.grammar, actionToken, x, y);
        }
    }

    public void issueInvalidAttributeError(String x, String y, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x, y);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x);
        if (label != null || enclosingRule.getRuleRefsInAlt(x, outerAltNum) != null) {
            Rule refdRule;
            AttributeScope scope;
            String refdRuleName = x;
            if (label != null) {
                refdRuleName = enclosingRule.getRuleLabel((String)x).referencedRuleName;
            }
            if ((scope = (refdRule = this.grammar.getRule(refdRuleName)).getAttributeScope(y)) == null) {
                ErrorManager.grammarError(116, this.grammar, actionToken, refdRuleName, y);
            } else if (scope.isParameterScope) {
                ErrorManager.grammarError(115, this.grammar, actionToken, refdRuleName, y);
            } else if (scope.isDynamicRuleScope) {
                ErrorManager.grammarError(112, this.grammar, actionToken, refdRuleName, y);
            }
        }
    }

    public void issueInvalidAttributeError(String x, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x);
        AttributeScope scope = enclosingRule.getAttributeScope(x);
        if (label != null || enclosingRule.getRuleRefsInAlt(x, outerAltNum) != null || enclosingRule.name.equals(x)) {
            ErrorManager.grammarError(117, this.grammar, actionToken, x);
        } else if (scope != null && scope.isDynamicRuleScope) {
            ErrorManager.grammarError(142, this.grammar, actionToken, x);
        } else {
            ErrorManager.grammarError(114, this.grammar, actionToken, x);
        }
    }

    public STGroup getTemplates() {
        return this.templates;
    }

    public STGroup getBaseTemplates() {
        return this.baseTemplates;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
        if (profile) {
            this.setDebug(true);
        }
    }

    public ST getRecognizerST() {
        return this.outputFileST;
    }

    public String getRecognizerFileName(String name, int type) {
        ST extST = this.templates.getInstanceOf("codeFileExtension");
        String recognizerName = this.grammar.getRecognizerName();
        return recognizerName + extST.render();
    }

    public String getVocabFileName() {
        if (this.grammar.isBuiltFromString()) {
            return null;
        }
        return this.grammar.name + VOCAB_FILE_EXTENSION;
    }

    public void write(ST code, String fileName) throws IOException {
        Writer w = this.tool.getOutputFile(this.grammar, fileName);
        AutoIndentWriter wr = new AutoIndentWriter(w);
        wr.setLineWidth(this.lineWidth);
        code.write((STWriter)wr);
        w.close();
    }

    protected boolean canGenerateSwitch(DFAState s) {
        if (!this.GENERATE_SWITCHES_WHEN_POSSIBLE) {
            return false;
        }
        int size = 0;
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            int EOTPredicts;
            Transition edge = s.transition(i);
            if (edge.label.isSemanticPredicate()) {
                return false;
            }
            if (edge.label.getAtom() == -2 && (EOTPredicts = ((DFAState)edge.target).getUniquelyPredictedAlt()) == -1) {
                return false;
            }
            if (((DFAState)edge.target).getGatedPredicatesInNFAConfigurations() != null) {
                return false;
            }
            size += edge.label.getSet().size();
        }
        return s.getNumberOfTransitions() >= MIN_SWITCH_ALTS && size <= MAX_SWITCH_CASE_LABELS;
    }

    public String createUniqueLabel(String name) {
        return new StringBuffer().append(name).append(this.uniqueLabelNumber++).toString();
    }
}

