/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.PhoenixMetrics;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.CSVCommonsLoader;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;
import org.apache.phoenix.util.UpgradeUtil;

public class PhoenixRuntime {
    public static final String CURRENT_SCN_ATTRIB = "CurrentSCN";
    public static final String JDBC_PROTOCOL = "jdbc:phoenix";
    public static final String JDBC_THIN_PROTOCOL = "jdbc:phoenix:thin";
    public static final char JDBC_PROTOCOL_TERMINATOR = ';';
    public static final char JDBC_PROTOCOL_SEPARATOR = ':';
    @Deprecated
    public static final String EMBEDDED_JDBC_PROTOCOL = "jdbc:phoenix:";
    public static final String UPSERT_BATCH_SIZE_ATTRIB = "UpsertBatchSize";
    public static final String TENANT_ID_ATTRIB = "TenantId";
    public static final String ANNOTATION_ATTRIB_PREFIX = "phoenix.annotation.";
    public static final String AUTO_COMMIT_ATTRIB = "AutoCommit";
    public static final String CONSISTENCY_ATTRIB = "Consistency";
    public static final String CONNECTIONLESS = "none";
    private static final String HEADER_IN_LINE = "in-line";
    private static final String SQL_FILE_EXT = ".sql";
    private static final String CSV_FILE_EXT = ".csv";
    public static final String PHOENIX_TEST_DRIVER_URL_PARAM = "test=true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ExecutionCommand execCmd = ExecutionCommand.parseArgs(args);
        String jdbcUrl = EMBEDDED_JDBC_PROTOCOL + execCmd.getConnectionString();
        int exitStatus = 0;
        PhoenixConnection conn = null;
        try {
            Properties props = new Properties();
            conn = DriverManager.getConnection(jdbcUrl, props).unwrap(PhoenixConnection.class);
            if (execCmd.isLocalIndexUpgrade()) {
                if (conn.getClientInfo(CURRENT_SCN_ATTRIB) != null) {
                    throw new SQLException("May not specify the CURRENT_SCN property when upgrading");
                }
                if (conn.getClientInfo(TENANT_ID_ATTRIB) != null) {
                    throw new SQLException("May not specify the TENANT_ID_ATTRIB property when upgrading");
                }
                UpgradeUtil.upgradeLocalIndexes(conn);
            } else {
                for (String inputFile : execCmd.getInputFiles()) {
                    if (inputFile.endsWith(SQL_FILE_EXT)) {
                        PhoenixRuntime.executeStatements(conn, new FileReader(inputFile), Collections.emptyList());
                        continue;
                    }
                    if (!inputFile.endsWith(CSV_FILE_EXT)) continue;
                    String tableName = execCmd.getTableName();
                    if (tableName == null) {
                        tableName = SchemaUtil.normalizeIdentifier(inputFile.substring(inputFile.lastIndexOf(File.separatorChar) + 1, inputFile.length() - CSV_FILE_EXT.length()));
                    }
                    CSVCommonsLoader csvLoader = new CSVCommonsLoader(conn, tableName, execCmd.getColumns(), execCmd.isStrict(), execCmd.getFieldDelimiter(), execCmd.getQuoteCharacter(), execCmd.getEscapeCharacter(), execCmd.getArrayElementSeparator());
                    csvLoader.upsert(inputFile);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitStatus = 1;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException props) {}
            }
            System.exit(exitStatus);
        }
    }

    private PhoenixRuntime() {
    }

    public static int executeStatements(Connection conn, Reader reader, List<Object> binds) throws IOException, SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        pconn.setAutoCommit(true);
        return pconn.executeStatements(reader, binds, System.out);
    }

    @Deprecated
    public static List<KeyValue> getUncommittedData(Connection conn) throws SQLException {
        Iterator<Pair<byte[], List<KeyValue>>> iterator = PhoenixRuntime.getUncommittedDataIterator(conn);
        if (iterator.hasNext()) {
            return iterator.next().getSecond();
        }
        return Collections.emptyList();
    }

    public static Iterator<Pair<byte[], List<KeyValue>>> getUncommittedDataIterator(Connection conn) throws SQLException {
        return PhoenixRuntime.getUncommittedDataIterator(conn, false);
    }

    public static Iterator<Pair<byte[], List<KeyValue>>> getUncommittedDataIterator(Connection conn, boolean includeMutableIndexes) throws SQLException {
        final PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        final Iterator<Pair<byte[], List<Mutation>>> iterator = pconn.getMutationState().toMutations(includeMutableIndexes);
        return new Iterator<Pair<byte[], List<KeyValue>>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<KeyValue>> next() {
                Pair pair = (Pair)iterator.next();
                ArrayList<KeyValue> keyValues = Lists.newArrayListWithExpectedSize(((List)pair.getSecond()).size() * 5);
                for (Mutation mutation : (List)pair.getSecond()) {
                    for (List keyValueList : mutation.getFamilyCellMap().values()) {
                        for (Cell keyValue : keyValueList) {
                            keyValues.add(KeyValueUtil.ensureKeyValue(keyValue));
                        }
                    }
                }
                Collections.sort(keyValues, pconn.getKeyValueBuilder().getKeyValueComparator());
                return new Pair<byte[], List<KeyValue>>((byte[])pair.getFirst(), (List<KeyValue>)keyValues);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PTable getTable(Connection conn, String name) throws SQLException {
        PTable table = null;
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        try {
            table = pconn.getMetaDataCache().getTable(new PTableKey(pconn.getTenantId(), name));
        }
        catch (TableNotFoundException e) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
            String tableName = SchemaUtil.getTableNameFromFullName(name);
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(schemaName, tableName);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw e;
            }
            table = result.getTable();
        }
        return table;
    }

    public static List<ColumnInfo> generateColumnInfo(Connection conn, String tableName, List<String> columns) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, SchemaUtil.normalizeFullTableName(tableName));
        ArrayList<ColumnInfo> columnInfoList = Lists.newArrayList();
        TreeSet<String> unresolvedColumnNames = new TreeSet<String>();
        if (columns == null || columns.isEmpty()) {
            int offset;
            for (int i = offset = table.getBucketNum() == null ? 0 : 1; i < table.getColumns().size(); ++i) {
                PColumn pColumn = table.getColumns().get(i);
                if (pColumn.equals(SaltingUtil.SALTING_COLUMN)) continue;
                columnInfoList.add(PhoenixRuntime.getColumnInfo(pColumn));
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = columns.get(i);
                try {
                    ColumnInfo columnInfo = PhoenixRuntime.getColumnInfo(table, columnName);
                    columnInfoList.add(columnInfo);
                    continue;
                }
                catch (ColumnNotFoundException cnfe) {
                    unresolvedColumnNames.add(columnName);
                    continue;
                }
                catch (AmbiguousColumnException ace) {
                    unresolvedColumnNames.add(columnName);
                }
            }
        }
        if (unresolvedColumnNames.size() > 0) {
            StringBuilder exceptionMessage = new StringBuilder();
            boolean first = true;
            exceptionMessage.append("Unable to resolve these column names:\n");
            for (String col : unresolvedColumnNames) {
                if (first) {
                    first = false;
                } else {
                    exceptionMessage.append(",");
                }
                exceptionMessage.append(col);
            }
            exceptionMessage.append("\nAvailable columns with column families:\n");
            first = true;
            for (PColumn pColumn : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    exceptionMessage.append(",");
                }
                exceptionMessage.append(pColumn.toString());
            }
            throw new SQLException(exceptionMessage.toString());
        }
        return columnInfoList;
    }

    public static ColumnInfo getColumnInfo(PTable table, String columnName) throws SQLException {
        if (table == null) {
            throw new SQLException("Table must not be null.");
        }
        if (columnName == null) {
            throw new SQLException("columnName must not be null.");
        }
        PColumn pColumn = null;
        if (columnName.contains(".")) {
            String[] tokens = columnName.split("\\.");
            if (tokens.length != 2) {
                throw new SQLException(String.format("Unable to process column %s, expected family-qualified name.", columnName));
            }
            String familyName = tokens[0];
            String familyColumn = tokens[1];
            PColumnFamily family = table.getColumnFamily(familyName);
            pColumn = family.getColumn(familyColumn);
        } else {
            pColumn = table.getColumn(columnName);
        }
        return PhoenixRuntime.getColumnInfo(pColumn);
    }

    public static ColumnInfo getColumnInfo(PColumn pColumn) throws SQLException {
        if (pColumn == null) {
            throw new SQLException("pColumn must not be null.");
        }
        return ColumnInfo.create(pColumn.toString(), pColumn.getDataType().getSqlType(), pColumn.getMaxLength(), pColumn.getScale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static byte[] encodePK(Connection conn, String fullTableName, Object[] values) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        int offset = (table.getBucketNum() == null ? 0 : 1) + (table.isMultiTenant() && pconn.getTenantId() != null ? 1 : 0);
        List<PColumn> pkColumns = table.getPKColumns();
        if (pkColumns.size() - offset != values.length) {
            throw new SQLException("Expected " + (pkColumns.size() - offset) + " but got " + values.length);
        }
        PDataType type = null;
        TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream(table.getRowKeySchema().getEstimatedValueLength());
        try {
            for (int i = offset; i < pkColumns.size(); ++i) {
                if (type != null && !type.isFixedWidth()) {
                    output.write(0);
                }
                type = pkColumns.get(i).getDataType();
                Object paddedObj = type.pad(values[i - offset], pkColumns.get(i).getMaxLength());
                byte[] value = type.toBytes(paddedObj);
                output.write(value);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static Object[] decodePK(Connection conn, String name, byte[] value) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, name);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        int offset = (table.getBucketNum() == null ? 0 : 1) + (table.isMultiTenant() && pconn.getTenantId() != null ? 1 : 0);
        int nValues = table.getPKColumns().size() - offset;
        RowKeySchema schema = table.getRowKeySchema();
        Object[] values = new Object[nValues];
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        schema.iterator(value, ptr);
        int i = 0;
        int fieldIdx = offset;
        while (i < nValues && schema.next(ptr, fieldIdx, value.length) != null) {
            values[i] = schema.getField(fieldIdx).getDataType().toObject(ptr);
            ++i;
            ++fieldIdx;
        }
        return values;
    }

    public static QueryPlan getOptimizedQueryPlan(PreparedStatement stmt) throws SQLException {
        Preconditions.checkNotNull(stmt);
        QueryPlan plan = stmt.unwrap(PhoenixPreparedStatement.class).optimizeQuery();
        return plan;
    }

    public static boolean hasOrderBy(QueryPlan plan) {
        Preconditions.checkNotNull(plan);
        List<OrderByExpression> orderBys = plan.getOrderBy().getOrderByExpressions();
        return orderBys != null && !orderBys.isEmpty();
    }

    public static int getLimit(QueryPlan plan) {
        Preconditions.checkNotNull(plan);
        return plan.getLimit() == null ? 0 : plan.getLimit();
    }

    private static String addQuotes(String str) {
        return str == null ? str : "\"" + str + "\"";
    }

    public static void getPkColsForSql(List<Pair<String, String>> columns, QueryPlan plan, Connection conn, boolean forDataTable) throws SQLException {
        Preconditions.checkNotNull(columns);
        Preconditions.checkNotNull(plan);
        Preconditions.checkNotNull(conn);
        List<PColumn> pkColumns = PhoenixRuntime.getPkColumns(plan.getTableRef().getTable(), conn, forDataTable);
        for (PColumn pCol : pkColumns) {
            String columnName = PhoenixRuntime.addQuotes(pCol.getName().getString());
            String familyName = pCol.getFamilyName() != null ? PhoenixRuntime.addQuotes(pCol.getFamilyName().getString()) : null;
            columns.add(new Pair<String, String>(familyName, columnName));
        }
    }

    public static void getPkColsDataTypesForSql(List<Pair<String, String>> columns, List<String> dataTypes, QueryPlan plan, Connection conn, boolean forDataTable) throws SQLException {
        Preconditions.checkNotNull(columns);
        Preconditions.checkNotNull(dataTypes);
        Preconditions.checkNotNull(plan);
        Preconditions.checkNotNull(conn);
        List<PColumn> pkColumns = PhoenixRuntime.getPkColumns(plan.getTableRef().getTable(), conn, forDataTable);
        for (PColumn pCol : pkColumns) {
            String sqlTypeName = PhoenixRuntime.getSqlTypeName(pCol);
            dataTypes.add(sqlTypeName);
            String columnName = PhoenixRuntime.addQuotes(pCol.getName().getString());
            String familyName = pCol.getFamilyName() != null ? PhoenixRuntime.addQuotes(pCol.getFamilyName().getString()) : null;
            columns.add(new Pair<String, String>(familyName, columnName));
        }
    }

    public static String getSqlTypeName(PColumn pCol) {
        PDataType dataType = pCol.getDataType();
        Integer maxLength = pCol.getMaxLength();
        Integer scale = pCol.getScale();
        return PhoenixRuntime.getSqlTypeName(dataType, maxLength, scale);
    }

    public static String getSqlTypeName(PDataType dataType, Integer maxLength, Integer scale) {
        return dataType.isArrayType() ? PhoenixRuntime.getArraySqlTypeName(maxLength, scale, dataType) : PhoenixRuntime.appendMaxLengthAndScale(maxLength, scale, dataType.getSqlTypeName());
    }

    public static String getArraySqlTypeName(@Nullable Integer maxLength, @Nullable Integer scale, PDataType arrayType) {
        String baseTypeSqlName = PDataType.arrayBaseType(arrayType).getSqlTypeName();
        return PhoenixRuntime.appendMaxLengthAndScale(maxLength, scale, baseTypeSqlName) + " " + "ARRAY";
    }

    private static String appendMaxLengthAndScale(@Nullable Integer maxLength, @Nullable Integer scale, String sqlTypeName) {
        if (maxLength != null) {
            sqlTypeName = sqlTypeName + "(" + maxLength;
            if (scale != null) {
                sqlTypeName = sqlTypeName + "," + scale;
            }
            sqlTypeName = sqlTypeName + ")";
        }
        return sqlTypeName;
    }

    private static List<PColumn> getPkColumns(PTable ptable, Connection conn, boolean forDataTable) throws SQLException {
        PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
        List<PColumn> pkColumns = ptable.getPKColumns();
        int offset = (ptable.getBucketNum() == null ? 0 : 1) + (ptable.isMultiTenant() && pConn.getTenantId() != null ? 1 : 0) + (ptable.getViewIndexId() == null ? 0 : 1);
        pkColumns = pkColumns.subList(offset, pkColumns.size());
        if (ptable.getType() == PTableType.INDEX && forDataTable) {
            String fullDataTableName = ptable.getParentName().getString();
            List<PColumn> dataColumns = IndexUtil.getDataColumns(fullDataTableName, pkColumns, pConn);
            pkColumns = dataColumns;
        }
        return pkColumns;
    }

    public static byte[] encodeValues(Connection conn, String fullTableName, Object[] values, List<Pair<String, String>> columns) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        List<PColumn> pColumns = PhoenixRuntime.getPColumns(table, columns);
        ArrayList<LiteralExpression> expressions = new ArrayList<LiteralExpression>(pColumns.size());
        int i = 0;
        for (PColumn col : pColumns) {
            Object value = values[i];
            LiteralExpression expr = LiteralExpression.newConstant(value, col.getDataType(), col.getMaxLength(), col.getScale());
            expressions.add(expr);
            ++i;
        }
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(pColumns);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        return kvSchema.toBytes(expressions.toArray(new Expression[0]), valueSet, ptr);
    }

    public static Object[] decodeValues(Connection conn, String fullTableName, byte[] value, List<Pair<String, String>> columns) throws SQLException {
        Boolean hasValue;
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        KeyValueSchema kvSchema = PhoenixRuntime.buildKeyValueSchema(PhoenixRuntime.getPColumns(table, columns));
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(value);
        ValueBitSet valueSet = ValueBitSet.newInstance(kvSchema);
        valueSet.clear();
        valueSet.or(ptr);
        int maxOffset = ptr.getOffset() + ptr.getLength();
        kvSchema.iterator(ptr);
        int i = 0;
        ArrayList<Object> values = new ArrayList<Object>();
        while ((hasValue = Boolean.valueOf(kvSchema.next(ptr, i, maxOffset, valueSet) != null)).booleanValue()) {
            if (hasValue.booleanValue()) {
                values.add(kvSchema.getField(i).getDataType().toObject(ptr));
            }
            ++i;
        }
        return values.toArray();
    }

    private static KeyValueSchema buildKeyValueSchema(List<PColumn> columns) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(PhoenixRuntime.getMinNullableIndex(columns));
        for (PColumn col : columns) {
            builder.addField(col);
        }
        return builder.build();
    }

    private static int getMinNullableIndex(List<PColumn> columns) {
        int minNullableIndex = columns.size();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).isNullable()) continue;
            minNullableIndex = i;
            break;
        }
        return minNullableIndex;
    }

    private static List<PColumn> getPColumns(PTable table, List<Pair<String, String>> columns) throws SQLException {
        ArrayList<PColumn> pColumns = new ArrayList<PColumn>(columns.size());
        for (Pair<String, String> column : columns) {
            pColumns.add(PhoenixRuntime.getPColumn(table, column.getFirst(), column.getSecond()));
        }
        return pColumns;
    }

    private static PColumn getPColumn(PTable table, @Nullable String familyName, String columnName) throws SQLException {
        if (table == null) {
            throw new SQLException("Table must not be null.");
        }
        if (columnName == null) {
            throw new SQLException("columnName must not be null.");
        }
        familyName = SchemaUtil.normalizeIdentifier(familyName);
        columnName = SchemaUtil.normalizeIdentifier(columnName);
        PColumn pColumn = null;
        if (familyName != null) {
            PColumnFamily family = table.getColumnFamily(familyName);
            pColumn = family.getColumn(columnName);
        } else {
            pColumn = table.getColumn(columnName);
        }
        return pColumn;
    }

    public static Expression getTenantIdExpression(Connection conn, String fullTableName) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        if (!(SchemaUtil.isMetaTable(table) || SchemaUtil.isSequenceTable(table) || table.isMultiTenant())) {
            return null;
        }
        if (table.getIndexType() == PTable.IndexType.LOCAL) {
            throw new SQLFeatureNotSupportedException();
        }
        int pkPosition = table.getBucketNum() == null ? 0 : 1;
        List<PColumn> pkColumns = table.getPKColumns();
        return new RowKeyColumnExpression(pkColumns.get(pkPosition), new RowKeyValueAccessor(pkColumns, pkPosition));
    }

    public static Collection<Metric> getInternalPhoenixMetrics() {
        return PhoenixMetrics.getMetrics();
    }

    static class ExecutionCommand {
        private String connectionString;
        private List<String> columns;
        private String tableName;
        private char fieldDelimiter;
        private char quoteCharacter;
        private Character escapeCharacter;
        private String arrayElementSeparator;
        private boolean strict;
        private boolean localIndexUpgrade;
        private List<String> inputFiles;

        ExecutionCommand() {
        }

        public static ExecutionCommand parseArgs(String[] args) {
            Option tableOption = new Option("t", "table", true, "Overrides the table into which the CSV data is loaded and is case sensitive");
            Option headerOption = new Option("h", "header", true, "Overrides the column names to which the CSV data maps and is case sensitive. A special value of in-line indicating that the first line of the CSV file determines the column to which the data maps");
            Option strictOption = new Option("s", "strict", false, "Use strict mode by throwing an exception if a column name doesn't match during CSV loading");
            Option delimiterOption = new Option("d", "delimiter", true, "Field delimiter for CSV loader. A digit is interpreted as 1 -> ctrl A, 2 -> ctrl B ... 9 -> ctrl I.");
            Option quoteCharacterOption = new Option("q", "quote-character", true, "Quote character for CSV loader. A digit is interpreted as a control character");
            Option escapeCharacterOption = new Option("e", "escape-character", true, "Escape character for CSV loader. A digit is interpreted as a control character");
            Option arrayValueSeparatorOption = new Option("a", "array-separator", true, "Define the array element separator, defaults to ':'");
            Option localIndexUpgradeOption = new Option("l", "local-index-upgrade", false, "Used to upgrade local index data by moving index data from separate table to separate column families in the same table.");
            Options options = new Options();
            options.addOption(tableOption);
            options.addOption(headerOption);
            options.addOption(strictOption);
            options.addOption(delimiterOption);
            options.addOption(quoteCharacterOption);
            options.addOption(escapeCharacterOption);
            options.addOption(arrayValueSeparatorOption);
            options.addOption(localIndexUpgradeOption);
            PosixParser parser = new PosixParser();
            CommandLine cmdLine = null;
            try {
                cmdLine = parser.parse(options, args);
            }
            catch (ParseException e) {
                ExecutionCommand.usageError(options);
            }
            ExecutionCommand execCmd = new ExecutionCommand();
            if (cmdLine.hasOption(tableOption.getOpt())) {
                execCmd.tableName = cmdLine.getOptionValue(tableOption.getOpt());
            }
            if (cmdLine.hasOption(headerOption.getOpt())) {
                String columnString = cmdLine.getOptionValue(headerOption.getOpt());
                execCmd.columns = PhoenixRuntime.HEADER_IN_LINE.equals(columnString) ? ImmutableList.of() : ImmutableList.copyOf(Splitter.on(",").trimResults().split(columnString));
            }
            execCmd.strict = cmdLine.hasOption(strictOption.getOpt());
            execCmd.fieldDelimiter = ExecutionCommand.getCharacter(cmdLine.getOptionValue(delimiterOption.getOpt(), ","));
            execCmd.quoteCharacter = ExecutionCommand.getCharacter(cmdLine.getOptionValue(quoteCharacterOption.getOpt(), "\""));
            if (cmdLine.hasOption(escapeCharacterOption.getOpt())) {
                execCmd.escapeCharacter = Character.valueOf(ExecutionCommand.getCharacter(cmdLine.getOptionValue(escapeCharacterOption.getOpt(), "\\")));
            }
            execCmd.arrayElementSeparator = cmdLine.getOptionValue(arrayValueSeparatorOption.getOpt(), ":");
            execCmd.localIndexUpgrade = cmdLine.hasOption(localIndexUpgradeOption.getOpt());
            ArrayList<String> argList = Lists.newArrayList(cmdLine.getArgList());
            if (argList.isEmpty()) {
                ExecutionCommand.usageError("Connection string to HBase must be supplied", options);
            }
            execCmd.connectionString = (String)argList.remove(0);
            ArrayList<String> inputFiles = Lists.newArrayList();
            if (execCmd.localIndexUpgrade) {
                return execCmd;
            }
            for (String arg : argList) {
                if (arg.endsWith(PhoenixRuntime.CSV_FILE_EXT) || arg.endsWith(PhoenixRuntime.SQL_FILE_EXT)) {
                    inputFiles.add(arg);
                    continue;
                }
                ExecutionCommand.usageError("Don't know how to interpret argument '" + arg + "'", options);
            }
            if (inputFiles.isEmpty()) {
                ExecutionCommand.usageError("At least one input file must be supplied", options);
            }
            execCmd.inputFiles = inputFiles;
            return execCmd;
        }

        private static char getCharacter(String s) {
            if (s.length() > 1) {
                throw new IllegalArgumentException("Invalid single character: '" + s + "'");
            }
            return s.charAt(0);
        }

        private static void usageError(String errorMsg, Options options) {
            System.out.println(errorMsg);
            ExecutionCommand.usageError(options);
        }

        private static void usageError(Options options) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("psql [-t table-name] [-h comma-separated-column-names | in-line] [-d field-delimiter-char quote-char escape-char]<zookeeper>  <path-to-sql-or-csv-file>...", options);
            System.out.println("Examples:\n  psql localhost my_ddl.sql\n  psql localhost my_ddl.sql my_table.csv\n  psql -t MY_TABLE my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 -d : my_cluster:1825 my_table2012-Q3.csv");
            System.exit(-1);
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public String getTableName() {
            return this.tableName;
        }

        public char getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public char getQuoteCharacter() {
            return this.quoteCharacter;
        }

        public Character getEscapeCharacter() {
            return this.escapeCharacter;
        }

        public String getArrayElementSeparator() {
            return this.arrayElementSeparator;
        }

        public List<String> getInputFiles() {
            return this.inputFiles;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean isLocalIndexUpgrade() {
            return this.localIndexUpgrade;
        }
    }
}

