/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import org.apache.phoenix.call.CallWrapper;

public class PhoenixContextExecutor {
    public static CallWrapper inContext() {
        return new CurrentContextWrapper();
    }

    public static <T> T call(Callable<T> target) throws Exception {
        ClassLoader saveCcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(PhoenixContextExecutor.class.getClassLoader());
            T t = target.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(saveCcl);
        }
    }

    public static <T> T callWithoutPropagation(Callable<T> target) {
        try {
            return PhoenixContextExecutor.call(target);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private static class CurrentContextWrapper
    implements CallWrapper {
        private ClassLoader saveCcl;

        private CurrentContextWrapper() {
        }

        @Override
        public void before() {
            this.saveCcl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(PhoenixContextExecutor.class.getClassLoader());
        }

        @Override
        public void after() {
            Thread.currentThread().setContextClassLoader(this.saveCcl);
        }
    }
}

