/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataUtil.class);
    public static final String VIEW_INDEX_TABLE_PREFIX = "_IDX_";
    public static final byte[] VIEW_INDEX_TABLE_PREFIX_BYTES = Bytes.toBytes("_IDX_");
    public static final String LOCAL_INDEX_TABLE_PREFIX = "_LOCAL_IDX_";
    public static final byte[] LOCAL_INDEX_TABLE_PREFIX_BYTES = Bytes.toBytes("_LOCAL_IDX_");
    public static final String VIEW_INDEX_SEQUENCE_PREFIX = "_SEQ_";
    public static final String VIEW_INDEX_SEQUENCE_NAME_PREFIX = "_ID_";
    public static final byte[] VIEW_INDEX_SEQUENCE_PREFIX_BYTES = Bytes.toBytes("_SEQ_");
    public static final String VIEW_INDEX_ID_COLUMN_NAME = "_INDEX_ID";
    public static final String PARENT_TABLE_KEY = "PARENT_TABLE";
    public static final byte[] PARENT_TABLE_KEY_BYTES = Bytes.toBytes("PARENT_TABLE");
    public static final String IS_VIEW_INDEX_TABLE_PROP_NAME = "IS_VIEW_INDEX_TABLE";
    public static final byte[] IS_VIEW_INDEX_TABLE_PROP_BYTES = Bytes.toBytes("IS_VIEW_INDEX_TABLE");
    public static final String IS_LOCAL_INDEX_TABLE_PROP_NAME = "IS_LOCAL_INDEX_TABLE";
    public static final byte[] IS_LOCAL_INDEX_TABLE_PROP_BYTES = Bytes.toBytes("IS_LOCAL_INDEX_TABLE");

    public static boolean areClientAndServerCompatible(long serverHBaseAndPhoenixVersion) {
        return MetaDataUtil.areClientAndServerCompatible(MetaDataUtil.decodePhoenixVersion(serverHBaseAndPhoenixVersion), 4, 4);
    }

    static boolean areClientAndServerCompatible(int serverVersion, int clientMajorVersion, int clientMinorVersion) {
        return VersionUtil.encodeMinPatchVersion(clientMajorVersion, clientMinorVersion) <= serverVersion && VersionUtil.encodeMaxMinorVersion(clientMajorVersion) >= serverVersion;
    }

    public static int decodePhoenixVersion(long version) {
        return (int)(version << 24 >>> 32);
    }

    public static long encodeMutableIndexConfiguredProperly(long version, boolean isValid) {
        if (!isValid) {
            return version | 1L;
        }
        return version;
    }

    public static boolean decodeMutableIndexConfiguredProperly(long version) {
        return (version & 0xFL) == 0L;
    }

    public static int decodeHBaseVersion(long version) {
        return (int)(version >>> 40);
    }

    public static String decodeHBaseVersionAsString(int version) {
        int major = version >>> 16 & 0xFF;
        int minor = version >>> 8 & 0xFF;
        int patch = version & 0xFF;
        return major + "." + minor + "." + patch;
    }

    public static int encodePhoenixVersion() {
        return VersionUtil.encodeVersion(4, 4, 0);
    }

    public static long encodeHBaseAndPhoenixVersions(String hbaseVersion) {
        return (long)VersionUtil.encodeVersion(hbaseVersion) << 40 | (long)VersionUtil.encodeVersion(4, 4, 0) << 8;
    }

    public static void getTenantIdAndSchemaAndTableName(List<Mutation> tableMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
    }

    public static void getTenantIdAndFunctionName(List<Mutation> functionMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(functionMetadata);
        SchemaUtil.getVarChars(m.getRow(), 2, rowKeyMetaData);
    }

    public static byte[] getParentTableName(List<Mutation> tableMetadata) {
        if (tableMetadata.size() == 1) {
            return null;
        }
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        Mutation m = MetaDataUtil.getParentTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
        if (Bytes.compareTo(schemaName, rowKeyMetaData[1]) == 0 && Bytes.compareTo(tableName, rowKeyMetaData[2]) == 0) {
            return null;
        }
        return rowKeyMetaData[2];
    }

    public static long getSequenceNumber(Mutation tableMutation) {
        List kvs = (List)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, 0, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES.length) != 0) continue;
                return PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
            }
        }
        throw new IllegalStateException();
    }

    public static long getSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getTableHeaderRow(tableMetaData));
    }

    public static PTableType getTableType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesPtr value) {
        if (MetaDataUtil.getMutationValue(MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, builder, value)) {
            return PTableType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }

    public static long getParentSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getParentTableHeaderRow(tableMetaData));
    }

    public static Mutation getTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(0);
    }

    public static boolean getMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (builder.compareQualifier(kv, key, 0, key.length) != 0) continue;
                builder.getValueAsPtr(kv, ptr);
                return true;
            }
        }
        return false;
    }

    public static Mutation getPutOnlyTableHeaderRow(List<Mutation> tableMetaData) {
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            return m;
        }
        throw new IllegalStateException("No table header row found in table meatadata");
    }

    public static Mutation getParentTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(tableMetaData.size() - 1);
    }

    public static long getClientTimeStamp(List<Mutation> tableMetadata) {
        Mutation m = tableMetadata.get(0);
        return MetaDataUtil.getClientTimeStamp(m);
    }

    public static long getClientTimeStamp(Mutation m) {
        Collection kvs = m.getFamilyCellMap().values();
        return kvs.isEmpty() ? m.getTimeStamp() : ((Cell)((List)kvs.iterator().next()).get(0)).getTimestamp();
    }

    public static byte[] getParentLinkKey(String tenantId, String schemaName, String tableName, String indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes(tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes(indexName));
    }

    public static byte[] getParentLinkKey(byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, indexName);
    }

    public static boolean isMultiTenant(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isSalted(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        return MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES, builder, ptr);
    }

    public static byte[] getViewIndexPhysicalName(byte[] physicalTableName) {
        return ByteUtil.concat(VIEW_INDEX_TABLE_PREFIX_BYTES, new byte[][]{physicalTableName});
    }

    public static String getViewIndexTableName(String tableName) {
        return VIEW_INDEX_TABLE_PREFIX + tableName;
    }

    public static String getViewIndexSchemaName(String schemaName) {
        return schemaName;
    }

    public static byte[] getLocalIndexPhysicalName(byte[] physicalTableName) {
        return ByteUtil.concat(LOCAL_INDEX_TABLE_PREFIX_BYTES, new byte[][]{physicalTableName});
    }

    public static String getLocalIndexTableName(String tableName) {
        return LOCAL_INDEX_TABLE_PREFIX + tableName;
    }

    public static String getLocalIndexSchemaName(String schemaName) {
        return schemaName;
    }

    public static String getUserTableName(String localIndexTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(localIndexTableName);
        if (!schemaName.isEmpty()) {
            schemaName = schemaName.substring(LOCAL_INDEX_TABLE_PREFIX.length());
        }
        String tableName = localIndexTableName.substring((schemaName.isEmpty() ? 0 : schemaName.length() + ".".length()) + LOCAL_INDEX_TABLE_PREFIX.length());
        return SchemaUtil.getTableName(schemaName, tableName);
    }

    public static String getViewIndexSchemaName(PName physicalName) {
        return VIEW_INDEX_SEQUENCE_PREFIX + physicalName.getString();
    }

    public static SequenceKey getViewIndexSequenceKey(String tenantId, PName physicalName, int nSaltBuckets) {
        String schemaName = MetaDataUtil.getViewIndexSchemaName(physicalName);
        String tableName = VIEW_INDEX_SEQUENCE_NAME_PREFIX + (tenantId == null ? "" : tenantId);
        return new SequenceKey(null, schemaName, tableName, nSaltBuckets);
    }

    public static PDataType getViewIndexIdDataType() {
        return PSmallint.INSTANCE;
    }

    public static String getViewIndexIdColumnName() {
        return VIEW_INDEX_ID_COLUMN_NAME;
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, PName name) throws SQLException {
        return MetaDataUtil.hasViewIndexTable(connection, name.getBytes());
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, String schemaName, String tableName) throws SQLException {
        return MetaDataUtil.hasViewIndexTable(connection, SchemaUtil.getTableNameAsBytes(schemaName, tableName));
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        try {
            HTableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalIndexName);
            return desc != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(IS_VIEW_INDEX_TABLE_PROP_BYTES)));
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, PName name) throws SQLException {
        return MetaDataUtil.hasLocalIndexTable(connection, name.getBytes());
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, String schemaName, String tableName) throws SQLException {
        return MetaDataUtil.hasLocalIndexTable(connection, SchemaUtil.getTableNameAsBytes(schemaName, tableName));
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        try {
            HTableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalTableName);
            if (desc == null) {
                return false;
            }
            return MetaDataUtil.hasLocalIndexColumnFamily(desc);
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexColumnFamily(HTableDescriptor desc) {
        for (HColumnDescriptor cf : desc.getColumnFamilies()) {
            if (!cf.getNameAsString().startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    public static void deleteViewIndexSequences(PhoenixConnection connection, PName name) throws SQLException {
        String schemaName = MetaDataUtil.getViewIndexSchemaName(name);
        connection.createStatement().executeUpdate("DELETE FROM SYSTEM.\"SEQUENCE\" WHERE TENANT_ID IS NULL AND SEQUENCE_SCHEMA = '" + schemaName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tableRegionsOnline(Configuration conf, PTable table) {
        HConnection hcon = null;
        try {
            hcon = HConnectionManager.getConnection(conf);
            List<HRegionLocation> locations = hcon.locateRegions(TableName.valueOf(table.getTableName().getBytes()));
            for (HRegionLocation loc : locations) {
                try {
                    ServerName sn = loc.getServerName();
                    if (sn == null) continue;
                    AdminProtos.AdminService.BlockingInterface admin = hcon.getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(loc.getRegionInfo().getRegionName());
                    admin.getRegionInfo(null, request);
                }
                catch (ServiceException e) {
                    IOException ie = ProtobufUtil.getRemoteException(e);
                    logger.debug("Region " + loc.getRegionInfo().getEncodedName() + " isn't online due to:" + ie);
                    boolean bl = false;
                    if (hcon == null) return bl;
                    try {
                        hcon.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (RemoteException e) {
                    logger.debug("Cannot get region " + loc.getRegionInfo().getEncodedName() + " info due to error:" + e);
                    boolean bl = false;
                    if (hcon == null) return bl;
                    try {
                        hcon.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                    catch (IOException ex) {
                        logger.warn("tableRegionsOnline failed due to:" + ex);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return true;
                    }
                }
            }
        }
        finally {
            if (hcon != null) {
                try {
                    hcon.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Scan newTableRowsScan(byte[] key, long startTimeStamp, long stopTimeStamp) throws IOException {
        Scan scan = new Scan();
        scan.setTimeRange(startTimeStamp, stopTimeStamp);
        scan.setStartRow(key);
        byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
        ByteUtil.nextKey(stopKey, stopKey.length);
        scan.setStopRow(stopKey);
        return scan;
    }
}

